/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.eclipse.capella.ui.trace.extension;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.Trace;
import org.polarsys.capella.core.platform.eclipse.capella.ui.trace.extension.ITraceExtension;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;

public class TraceExtensionManager {
    public static TraceExtensionManager eINSTANCE = new TraceExtensionManager();
    String EXTENSION_POINT_ID = "org.polarsys.capella.core.platform.eclipse.capella.ui.trace.extension";
    String EXTENSION_POINT_CLASS = "traceExtension";
    Set<ITraceExtension> extensions;

    private TraceExtensionManager() {
        this.initializeTraceExtensions();
    }

    private Set<ITraceExtension> initializeTraceExtensions() {
        if (this.extensions == null) {
            this.extensions = new HashSet<ITraceExtension>();
            IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
            IConfigurationElement[] iConfigurationElementArray = extensionRegistry.getConfigurationElementsFor(this.EXTENSION_POINT_ID);
            int n = iConfigurationElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                try {
                    ITraceExtension extension = (ITraceExtension)configurationElement.createExecutableExtension(this.EXTENSION_POINT_CLASS);
                    this.extensions.add(extension);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
                ++n2;
            }
        }
        return this.extensions;
    }

    public boolean isActive(ITraceExtension extension, ResourceSet rSet) {
        ViewpointManager vpManager = ViewpointManager.getInstance((ResourceSet)rSet);
        return vpManager.isActive(extension.getViewpointID());
    }

    public boolean canDelete(Trace obj) {
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, obj.eResource().getResourceSet()) || !extension.canDelete(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean canRemoveSource(Trace obj) {
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, obj.eResource().getResourceSet()) || !extension.canRemoveSource(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean canRemoveTarget(Trace obj) {
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, obj.eResource().getResourceSet()) || !extension.canRemoveTarget(obj)) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignableFrom(Class<?> clazz, ResourceSet context) {
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, context) || !extension.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    public String getTraceName(Class<? extends AbstractTrace> clazz, ResourceSet context) {
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, context) || !extension.isAssignableFrom(clazz)) continue;
            return extension.getTraceName();
        }
        return null;
    }

    public Trace getNewTraceInstanceFromTraceName(String traceName, ResourceSet context) {
        if (traceName == null || traceName.isEmpty()) {
            return null;
        }
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, context) || !traceName.equals(extension.getTraceName())) continue;
            return extension.getNewTraceInstance();
        }
        return null;
    }

    public List<String> getAllTraceTypes(ResourceSet context) {
        ArrayList<String> allTraceTypes = new ArrayList<String>();
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, context)) continue;
            allTraceTypes.add(extension.getTraceName());
        }
        return allTraceTypes;
    }

    public List<String> getAllManualTraceTypes(ResourceSet context) {
        ArrayList<String> allTraceTypes = new ArrayList<String>();
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, context) || !extension.isManualTrace()) continue;
            allTraceTypes.add(extension.getTraceName());
        }
        return allTraceTypes;
    }

    public boolean canAddRemoveItemsToTrace(EObject element) {
        if (element == null) {
            return false;
        }
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, element.eResource().getResourceSet()) || !extension.canAddRemoveItemsToTrace(element)) continue;
            return true;
        }
        return false;
    }

    public boolean canEdit(EObject element) {
        if (element == null) {
            return false;
        }
        for (ITraceExtension extension : this.extensions) {
            if (!this.isActive(extension, element.eResource().getResourceSet()) || !extension.canEdit(element)) continue;
            return true;
        }
        return false;
    }
}

