/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.activities;

import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.core.transition.common.ExtensionHelper;
import org.polarsys.capella.core.transition.common.constants.Messages;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.activity.IActivityExtender;
import org.polarsys.kitalpha.cadence.core.api.IActivity;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.DeclaredParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.ParameterError;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class AbstractActivity
implements IActivity {
    public String getActivityIdentifier() {
        return this.getClass().getSimpleName();
    }

    protected IStatus preRun(IContext context, ActivityParameters activityParams) {
        IStatus status = Status.OK_STATUS;
        for (IHandler handler : ExtensionHelper.collectActivityExtendersFromExtensions(context, "org.polarsys.capella.core.transition.handlers", this.getActivityIdentifier(), (String)context.get((Object)"TRANSPOSER_PURPOSE"), (String)context.get((Object)"TRANSPOSER_MAPPING"))) {
            if (!(handler instanceof IActivityExtender)) continue;
            IActivityExtender activityExtender = (IActivityExtender)handler;
            activityExtender.init(context);
            status = activityExtender.preActivity(context, this.getActivityIdentifier(), activityParams);
            if (this.checkStatus(status)) continue;
            return status;
        }
        return status;
    }

    protected IStatus postRun(IContext context, ActivityParameters activityParams) {
        IStatus status = Status.OK_STATUS;
        for (IHandler handler : ExtensionHelper.collectActivityExtendersFromExtensions(context, "org.polarsys.capella.core.transition.handlers", this.getActivityIdentifier(), (String)context.get((Object)"TRANSPOSER_PURPOSE"), (String)context.get((Object)"TRANSPOSER_MAPPING"))) {
            IActivityExtender activityExtender;
            if (!(handler instanceof IActivityExtender) || this.checkStatus(status = (activityExtender = (IActivityExtender)handler).postActivity(context, this.getActivityIdentifier(), activityParams))) continue;
            return status;
        }
        return status;
    }

    public IStatus run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        IStatus status = Status.OK_STATUS;
        status = this.preRun(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this._run(activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.postRun(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.verificationRun(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        return status;
    }

    protected IStatus verificationRun(IContext context, ActivityParameters activityParams) {
        return Status.OK_STATUS;
    }

    protected abstract IStatus _run(ActivityParameters var1);

    protected IContext getContext(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        return context;
    }

    public Collection<DeclaredParameter> getParameters() {
        return null;
    }

    public Map<String, ParameterError<?>> validateParameters(ActivityParameters valuedParameters) {
        return null;
    }

    protected IHandler loadHandlerFromParameters(String handlerId, ActivityParameters activityParams) {
        GenericParameter parameter = activityParams.getParameter(handlerId);
        if (parameter != null && IHandler.class.isAssignableFrom(parameter.getParameterType())) {
            return (IHandler)parameter.getValue();
        }
        return null;
    }

    protected String loadStringFromParameters(String stringId, ActivityParameters activityParams) {
        GenericParameter parameter = activityParams.getParameter(stringId);
        if (parameter != null && String.class.isAssignableFrom(parameter.getParameterType())) {
            return (String)parameter.getValue();
        }
        return null;
    }

    protected boolean checkStatus(IStatus status) {
        return !status.matches(8) && !status.matches(4);
    }

    protected IStatus checkParameters(IContext context, String[] strings) {
        if (strings != null) {
            String[] stringArray = strings;
            int n = strings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                if (!context.exists((Object)string) || context.get((Object)string) == null) {
                    return new Status(4, Messages.Activity_Transition, NLS.bind((String)"Parameter ''{0}'' must be defined", (Object)string));
                }
                ++n2;
            }
        }
        return Status.OK_STATUS;
    }
}

