/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer.current;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.polarsys.capella.core.transition.common.transposer.ExtendedMappingHelper;
import org.polarsys.capella.core.transition.common.transposer.current.RuleMappingExtensionService;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.CommonFactory;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.Mapping;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingElement;
import org.polarsys.kitalpha.transposer.rules.handler.rules.common.MappingPossibility;
import org.polarsys.kitalpha.transposer.rules.handler.rules.contribution.ContributedPurpose;
import org.polarsys.kitalpha.transposer.rules.handler.rules.impl.PurposeRegistryImpl;
import org.polarsys.kitalpha.transposer.rules.handler.rules.runtime.RuntimeFactory;
import org.polarsys.kitalpha.transposer.rules.handler.rules.runtime.RuntimePurpose;

public class GenericPurposeRegistry
extends PurposeRegistryImpl {
    protected static GenericPurposeRegistry __instance = new GenericPurposeRegistry();
    protected Map _runtimePurposes = new HashMap();

    protected GenericPurposeRegistry() {
        this.init();
    }

    public static GenericPurposeRegistry getInstance() {
        return __instance;
    }

    public RuntimePurpose getRegisteredPurpose(String string1, String mappingId) {
        for (Object element : this.getRegisteredPurposes()) {
            RuntimePurpose purpose = (RuntimePurpose)element;
            if (string1 == null || !string1.equals(purpose.getName()) || mappingId == null || !mappingId.equals(purpose.getId())) continue;
            return purpose;
        }
        return this.registerPurpose(string1, mappingId);
    }

    public Mapping getContributedMapping(String purpose, String mappingId) {
        ContributedPurpose contributedPurpose = this.getContributedPurpose(purpose);
        Mapping result = null;
        if (contributedPurpose != null && mappingId != null) {
            for (Object element : contributedPurpose.getMappings()) {
                Mapping mapping = (Mapping)element;
                if (!mappingId.equals(mapping.getId())) continue;
                result = mapping;
            }
        }
        return result;
    }

    public ContributedPurpose getContributedPurpose(String purpose) {
        for (Object element : this.getContributedPurposes()) {
            ContributedPurpose contributedPurpose = (ContributedPurpose)element;
            if (purpose == null || !purpose.equals(contributedPurpose.getName())) continue;
            return contributedPurpose;
        }
        return null;
    }

    public IStatus validateRegisteredPurposes() {
        int severity = 1;
        String message = "Registered purpose are valid, check the error log for information.";
        for (Object element : this.getRegisteredPurposes()) {
            RuntimePurpose runtimePurpose = (RuntimePurpose)element;
            IStatus result = runtimePurpose.validate();
            if (result.getSeverity() == 1) continue;
            severity = result.getSeverity();
        }
        if (severity == 2) {
            message = "WARNING ! Registered purpose validate with warnings, check the error log for information.";
        }
        if (severity == 2) {
            message = "ERROR ! Some registered purpose are invalid, check the error log for information.";
        }
        return new Status(severity, "org.polarsys.kitalpha.transposer.rules.handler", message);
    }

    public IStatus validateContributedPurposes() {
        int severity = 1;
        String message = "Contributed purpose are valid, check the error log for information.";
        for (Object element : this.getContributedPurposes()) {
            ContributedPurpose contributedPurpose = (ContributedPurpose)element;
            IStatus result = contributedPurpose.validate();
            if (result.getSeverity() == 1) continue;
            severity = result.getSeverity();
        }
        if (severity == 2) {
            message = "WARNING ! Contributed purpose validate with warnings, check the error log for information.";
        }
        if (severity == 2) {
            message = "ERROR ! Some contributed purpose are invalid, check the error log for information.";
        }
        return new Status(severity, "org.polarsys.kitalpha.transposer.rules.handler", message);
    }

    public void reset() {
        this._runtimePurposes.clear();
    }

    public void init() {
        this.reset();
        this.getContributedPurposes().addAll(RuleMappingExtensionService.getInstance().getContributedPurposes());
    }

    public RuntimePurpose registerPurpose(String purpose, String mappingId) {
        ContributedPurpose selectedPurpose = null;
        Mapping selectedMapping = null;
        for (Object element : this.getContributedPurposes()) {
            ContributedPurpose contributedPurpose = (ContributedPurpose)element;
            if (!purpose.equals(contributedPurpose.getName())) continue;
            selectedPurpose = contributedPurpose;
        }
        if (selectedPurpose == null) {
            throw new NullPointerException("The purpose to register is not in contributed ones : " + purpose);
        }
        for (Object element : selectedPurpose.getMappings()) {
            Mapping contributedMapping = (Mapping)element;
            if (!mappingId.equals(contributedMapping.getId())) continue;
            selectedMapping = contributedMapping;
        }
        if (selectedMapping == null) {
            throw new NullPointerException("The mapping to register is not in contributed ones : " + purpose + "::" + mappingId);
        }
        RuntimePurpose runtimePurpose = RuntimeFactory.eINSTANCE.createRuntimePurpose();
        runtimePurpose.setName(selectedPurpose.getName());
        runtimePurpose.setDescription(this.getDescription(purpose, selectedMapping));
        if (selectedPurpose.getMappings().size() == 1 && ExtendedMappingHelper.getExtendedMappings((Mapping)selectedPurpose.getMappings().get(0)).isEmpty()) {
            runtimePurpose.setMapping((Mapping)EcoreUtil.copy((EObject)((Mapping)selectedPurpose.getMappings().get(0))));
        } else {
            runtimePurpose.setMapping(this.buildRuntimeMapping(selectedPurpose, selectedMapping));
        }
        runtimePurpose.setId(runtimePurpose.getMapping().getId());
        this.getRegisteredPurposes().add((Object)runtimePurpose);
        return runtimePurpose;
    }

    private String getDescription(String purpose, Mapping mapping) {
        StringBuilder runtimeDescription = new StringBuilder();
        runtimeDescription.append("Purpose ").append(purpose).append("\n").append("\n").append(mapping.getCompleteDescription());
        return runtimeDescription.toString();
    }

    private Mapping buildRuntimeMapping(ContributedPurpose contributedPurpose, Mapping selectedMapping) {
        Mapping runtimeMapping = CommonFactory.eINSTANCE.createMapping();
        HashMap<Class, MappingElement> runtimeMappingElements = new HashMap<Class, MappingElement>();
        HashMap contributedMappingsElements = new HashMap();
        this.selectContributedMappingElementsToUse(contributedMappingsElements, selectedMapping);
        runtimeMapping.setId(selectedMapping.getId());
        runtimeMapping.setName(selectedMapping.getName());
        runtimeMapping.setOwnedContext(selectedMapping.getContext());
        runtimeMapping.setOwnedDomainHelper(selectedMapping.getDomainHelper());
        for (MappingElement contributedElement : contributedMappingsElements.values()) {
            MappingElement runtimeElement = CommonFactory.eINSTANCE.createMappingElement();
            runtimeElement.setName(contributedElement.getName());
            runtimeElement.setDomainMetaClass(contributedElement.getDomainMetaClass());
            if (!contributedElement.getOwnedPossibilities().isEmpty()) {
                runtimeElement.getOwnedPossibilities().addAll(EcoreUtil.copyAll((Collection)contributedElement.getAllPossibilities()));
            }
            if (contributedElement.getDefaultPossibility() != null) {
                runtimeElement.setOwnedDefaultPossibility((MappingPossibility)EcoreUtil.copy((EObject)contributedElement.getDefaultPossibility()));
            }
            runtimeMappingElements.put(runtimeElement.getDomainMetaClass(), runtimeElement);
        }
        runtimeMapping.getOwnedMappingElements().addAll(runtimeMappingElements.values());
        return runtimeMapping;
    }

    protected void selectContributedMappingElementsToUse(Map contributedMappingsElements, Mapping mapping) {
        if (mapping.getExtendedMapping() != null) {
            this.selectContributedMappingElementsToUse(contributedMappingsElements, mapping.getExtendedMapping());
        }
        for (MappingElement currentElement : mapping.getAllOwnedMappingElements()) {
            contributedMappingsElements.put(currentElement.getDomainMetaClass(), currentElement);
        }
    }
}

