/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.wizards;

import java.lang.reflect.InvocationTargetException;
import java.util.Properties;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.util.KnownRepositories;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.wizards.ConfigurationWizardMainPage;
import org.eclipse.team.internal.ccvs.ui.wizards.NewLocationWizard;

public class AlternativeLocationWizard
extends NewLocationWizard {
    private ICVSRepositoryLocation location;

    @Override
    public boolean performFinish() {
        boolean useLocation;
        ICVSRepositoryLocation[] location;
        block12: {
            location = new ICVSRepositoryLocation[1];
            useLocation = true;
            try {
                location[0] = this.mainPage.getLocation();
                location[0] = KnownRepositories.getInstance().addRepository(location[0], false);
                if (!this.mainPage.getValidate()) break block12;
                try {
                    this.getContainer().run(true, true, monitor -> {
                        try {
                            location[0].validateConnection(monitor);
                        }
                        catch (TeamException e) {
                            throw new InvocationTargetException(e);
                        }
                    });
                }
                catch (InterruptedException interruptedException) {
                }
                catch (InvocationTargetException e) {
                    Throwable t = e.getTargetException();
                    if (t instanceof TeamException) {
                        throw (TeamException)t;
                    }
                    if (t instanceof Exception) {
                        throw CVSException.wrapException((Exception)((Exception)t));
                    }
                    throw CVSException.wrapException((Exception)e);
                }
            }
            catch (TeamException e) {
                if (location[0] == null) {
                    CVSUIPlugin.openError(this.getContainer().getShell(), CVSUIMessages.AlternativeLocationWizard_exception, null, e);
                    return false;
                }
                IStatus error = e.getStatus();
                if (error.isMultiStatus() && error.getChildren().length == 1) {
                    error = error.getChildren()[0];
                }
                if (error.isMultiStatus()) {
                    CVSUIPlugin.openError(this.getContainer().getShell(), CVSUIMessages.AlternativeLocationWizard_validationFailedTitle, null, e);
                }
                useLocation = MessageDialog.openQuestion((Shell)this.getContainer().getShell(), (String)CVSUIMessages.AlternativeLocationWizard_validationFailedTitle, (String)NLS.bind((String)CVSUIMessages.AlternativeLocationWizard_validationFailedText, (Object[])new Object[]{error.getMessage()}));
            }
        }
        if (useLocation) {
            KnownRepositories.getInstance().addRepository(location[0], true);
        } else {
            KnownRepositories.getInstance().disposeRepository(location[0]);
        }
        this.location = useLocation ? location[0] : null;
        return useLocation;
    }

    public AlternativeLocationWizard(Properties initialProperties) {
        super(initialProperties);
    }

    @Override
    public void addPages() {
        super.addPages();
    }

    @Override
    protected ConfigurationWizardMainPage createMainPage() {
        return new AlternativeConfigurationWizardMainPage("repositoryPage1", CVSUIMessages.AlternativeLocationWizard_heading, CVSUIPlugin.getPlugin().getImageDescriptor("wizban/newlocation_wizban.png"));
    }

    public ICVSRepositoryLocation getLocation() {
        return this.location;
    }

    private class AlternativeConfigurationWizardMainPage
    extends ConfigurationWizardMainPage {
        public AlternativeConfigurationWizardMainPage(String pageName, String title, ImageDescriptor titleImage) {
            super(pageName, title, titleImage);
        }

        @Override
        protected void validateFields() {
            super.validateFields();
            if (!this.isPageComplete() && this.getErrorMessage() != null && this.getErrorMessage().equals(CVSUIMessages.ConfigurationWizardMainPage_0)) {
                this.setErrorMessage(CVSUIMessages.AlternativeConfigurationWizardMainPage_0);
            }
        }
    }
}

