/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractExchangeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.common.queries.interpretor.QueryInterpretor;
import org.polarsys.capella.core.data.capellacommon.CapabilityRealizationInvolvement;
import org.polarsys.capella.core.data.capellacore.AbstractDependenciesPkg;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellacore.Generalization;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.ExchangeItemAllocation;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceImplementation;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.cs.InterfaceUse;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.helpers.information.services.ExchangeItemExt;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.communication.CommunicationLinkProtocol;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityExtend;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityGeneralization;
import org.polarsys.capella.core.data.interaction.AbstractCapabilityInclude;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.pa.LogicalInterfaceRealization;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.AbstractDependenciesPkgExt;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.queries.QueryIdentifierConstants;

public class InterfaceExt {
    public static ExchangeItemAllocation addExchangeItem(Interface itf, ExchangeItem item) {
        return InterfaceExt.addExchangeItem(itf, item, CommunicationLinkProtocol.UNSET, CommunicationLinkProtocol.UNSET);
    }

    public static ExchangeItemAllocation addExchangeItem(Interface itf, ExchangeItem item, CommunicationLinkProtocol sendProtocol, CommunicationLinkProtocol receiveProtocol) {
        if (item != null) {
            ExchangeItemAllocation allocation = CsFactory.eINSTANCE.createExchangeItemAllocation();
            allocation.setSendProtocol(sendProtocol);
            allocation.setReceiveProtocol(receiveProtocol);
            allocation.setAllocatedItem(item);
            itf.getOwnedExchangeItemAllocations().add((Object)allocation);
            CapellaElementExt.creationService((EObject)allocation);
            return allocation;
        }
        return null;
    }

    public static Collection<Interface> getAllInterfaces(EObject context) {
        return QueryInterpretor.executeQuery((String)QueryIdentifierConstants.GET_ALL_INTERFACES, (Object)context);
    }

    public static Collection<? extends Interface> getAllSuperGeneralizableElements(Interface interf) {
        HashSet<Interface> result = new HashSet<Interface>();
        result.add(interf);
        for (GeneralizableElement ge : GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)interf)) {
            if (!(ge instanceof Interface)) continue;
            Interface ai = (Interface)ge;
            result.add(ai);
        }
        return result;
    }

    public static Collection<? extends Interface> getAllSuperGeneralizableElements(Collection<? extends Interface> interfaces) {
        HashSet<? extends Interface> result = new HashSet<Interface>();
        for (Interface interface_ : interfaces) {
            result.addAll(InterfaceExt.getAllSuperGeneralizableElements(interface_));
        }
        return result;
    }

    public static List<SystemComponent> getImplementerSystemComponents(Interface interf) {
        ArrayList<SystemComponent> result = new ArrayList<SystemComponent>();
        for (Component cpnt : interf.getImplementorComponents()) {
            if (!(cpnt instanceof SystemComponent)) continue;
            result.add((SystemComponent)cpnt);
        }
        return result;
    }

    public static List<ConfigurationItem> getImplementerEPBSComponents(Interface interf) {
        ArrayList<ConfigurationItem> result = new ArrayList<ConfigurationItem>();
        for (Component cpnt : interf.getImplementorComponents()) {
            if (!(cpnt instanceof ConfigurationItem)) continue;
            result.add((ConfigurationItem)cpnt);
        }
        return result;
    }

    public static List<LogicalComponent> getImplementerLogicalComponents(Interface interf) {
        ArrayList<LogicalComponent> result = new ArrayList<LogicalComponent>();
        for (Component cpnt : interf.getImplementorComponents()) {
            if (!(cpnt instanceof LogicalComponent)) continue;
            result.add((LogicalComponent)cpnt);
        }
        return result;
    }

    public static List<PhysicalComponent> getImplementerPhysicalComponents(Interface interf) {
        ArrayList<PhysicalComponent> result = new ArrayList<PhysicalComponent>();
        for (Component cpnt : interf.getImplementorComponents()) {
            if (!(cpnt instanceof PhysicalComponent)) continue;
            result.add((PhysicalComponent)cpnt);
        }
        return result;
    }

    public static Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> getInterfaceDependencies2(Interface interface1) {
        HashMap<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> result = new HashMap<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>>();
        for (AbstractExchangeItem anOperation : interface1.getExchangeItems()) {
            if (!(anOperation instanceof ExchangeItem)) continue;
            ExchangeItem item = (ExchangeItem)anOperation;
            InterfaceExt.addToResultMap((EObject)item, ExchangeItemExt.getExchangeItemDependencies2((AbstractExchangeItem)item), result);
        }
        HashMap<AbstractDependenciesPkg, Collection<EObject>> map = null;
        for (Generalization aGeneralization : interface1.getSuperGeneralizations()) {
            map = new HashMap<AbstractDependenciesPkg, Collection<EObject>>();
            AbstractDependenciesPkgExt.checkDependenciesAndAddToResult(map, (EObject)aGeneralization.getSuper());
            InterfaceExt.addToResultMap((EObject)aGeneralization, map, result);
        }
        return result;
    }

    private static void addToResultMap(EObject tgt, Map<AbstractDependenciesPkg, Collection<EObject>> map, Map<AbstractDependenciesPkg, Collection<Couple<EObject, Collection<EObject>>>> result) {
        Couple couple = null;
        HashSet col = null;
        if (map != null) {
            for (AbstractDependenciesPkg pkg : map.keySet()) {
                if (!result.containsKey(pkg)) {
                    col = new HashSet();
                    result.put(pkg, col);
                }
                couple = new Couple((Object)tgt, map.get(pkg));
                result.get(pkg).add((Couple<EObject, Collection<EObject>>)couple);
            }
        }
    }

    public static Collection<AbstractDependenciesPkg> getInterfaceDependencies(Interface interface1) {
        return InterfaceExt.getInterfaceDependencies2(interface1).keySet();
    }

    public static InterfacePkg getOwnerInterfacePkg(Interface interf) {
        if (interf.eContainer() instanceof Interface) {
            return InterfaceExt.getOwnerInterfacePkg((Interface)interf.eContainer());
        }
        if (interf.eContainer() instanceof InterfacePkg) {
            return (InterfacePkg)interf.eContainer();
        }
        return null;
    }

    public static List<ComponentPort> getProvidedByComponentPorts(Interface interf) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)interf, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
            if (!(objectRef instanceof ComponentPort)) continue;
            result.add((ComponentPort)objectRef);
        }
        return result;
    }

    public static List<ComponentPort> getProvidedByPorts(Interface interf) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)interf, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
            if (!(objectRef instanceof ComponentPort)) continue;
            result.add((ComponentPort)objectRef);
        }
        return result;
    }

    public static List<Component> getProviderComponent(Interface itf) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)itf, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
            EObject objContainer;
            if (!(objectRef instanceof Port) || !((objContainer = ((Port)objectRef).eContainer()) instanceof Component)) continue;
            result.add((Component)objContainer);
        }
        return result;
    }

    public static Collection<Component> getRelatedComponents(Interface itf) {
        HashSet<Component> result = new HashSet<Component>();
        result.addAll((Collection<Component>)itf.getImplementorComponents());
        result.addAll((Collection<Component>)itf.getUserComponents());
        ArrayList<EReference> refs = new ArrayList<EReference>();
        refs.add(InformationPackage.Literals.PORT__REQUIRED_INTERFACES);
        refs.add(InformationPackage.Literals.PORT__PROVIDED_INTERFACES);
        for (Object objectRef : EObjectExt.getReferencers((EObject)itf, refs)) {
            EObject objContainer;
            if (!(objectRef instanceof Port) || !((objContainer = ((Port)objectRef).eContainer()) instanceof Component)) continue;
            result.add((Component)objContainer);
        }
        return result;
    }

    public static List<Component> getRequireComponent(Interface itf) {
        ArrayList<Component> result = new ArrayList<Component>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)itf, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
            EObject objContainer;
            if (!(objectRef instanceof Port) || !((objContainer = ((Port)objectRef).eContainer()) instanceof Component)) continue;
            result.add((Component)objContainer);
        }
        return result;
    }

    public static List<ComponentPort> getRequiredByComponentPorts(Interface interf) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)interf, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
            if (!(objectRef instanceof ComponentPort)) continue;
            result.add((ComponentPort)objectRef);
        }
        return result;
    }

    public static List<ComponentPort> getRequiredByPorts(Interface interf) {
        ArrayList<ComponentPort> result = new ArrayList<ComponentPort>();
        for (Object objectRef : EObjectExt.getReferencers((EObject)interf, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
            if (!(objectRef instanceof ComponentPort)) continue;
            result.add((ComponentPort)objectRef);
        }
        return result;
    }

    public static InterfacePkg getRootOwnerInterfacePkg(Interface interf) {
        if (interf.eContainer() instanceof Interface) {
            return InterfaceExt.getRootOwnerInterfacePkg((Interface)interf.eContainer());
        }
        if (interf.eContainer() instanceof InterfacePkg) {
            return InterfacePkgExt.getRootInterfacePkg((InterfacePkg)interf.eContainer());
        }
        return null;
    }

    public static List<SystemComponent> getUserSystemComponents(Interface interf) {
        ArrayList<SystemComponent> result = new ArrayList<SystemComponent>();
        for (Component cpnt : interf.getUserComponents()) {
            if (!(cpnt instanceof SystemComponent)) continue;
            result.add((SystemComponent)cpnt);
        }
        return result;
    }

    public static List<ConfigurationItem> getUserEPBSComponents(Interface interf) {
        ArrayList<ConfigurationItem> result = new ArrayList<ConfigurationItem>();
        for (Component cpnt : interf.getUserComponents()) {
            if (!(cpnt instanceof ConfigurationItem)) continue;
            result.add((ConfigurationItem)cpnt);
        }
        return result;
    }

    public static List<LogicalComponent> getUserLogicalComponents(Interface interf) {
        ArrayList<LogicalComponent> result = new ArrayList<LogicalComponent>();
        for (Component cpnt : interf.getUserComponents()) {
            if (!(cpnt instanceof LogicalComponent)) continue;
            result.add((LogicalComponent)cpnt);
        }
        return result;
    }

    public static List<PhysicalComponent> getUserPhysicalComponents(Interface interf) {
        ArrayList<PhysicalComponent> result = new ArrayList<PhysicalComponent>();
        for (Component cpnt : interf.getUserComponents()) {
            if (!(cpnt instanceof PhysicalComponent)) continue;
            result.add((PhysicalComponent)cpnt);
        }
        return result;
    }

    public static List<CapellaElement> filterLCRealizedInterfaces(List<?> interfaces) {
        ArrayList<CapellaElement> availableElements = new ArrayList<CapellaElement>();
        for (Object element : interfaces) {
            if (!(element instanceof Interface)) continue;
            Interface lcInterface = (Interface)element;
            EList incomingTraces = lcInterface.getIncomingTraces();
            boolean isRealized = false;
            for (AbstractTrace abstractTrace : incomingTraces) {
                if (!(abstractTrace instanceof LogicalInterfaceRealization)) continue;
                isRealized = true;
                break;
            }
            if (isRealized) continue;
            availableElements.add((CapellaElement)element);
        }
        return availableElements;
    }

    public static Interface getInterfaceFromLink(Relationship element) {
        if (element != null) {
            if (element instanceof InterfaceImplementation) {
                return ((InterfaceImplementation)element).getImplementedInterface();
            }
            if (element instanceof InterfaceUse) {
                return ((InterfaceUse)element).getUsedInterface();
            }
        }
        return null;
    }

    public static boolean isProvidedByComponentPorts(Interface interf) {
        for (Object objectRef : EObjectExt.getReferencers((EObject)interf, (EReference)InformationPackage.Literals.PORT__PROVIDED_INTERFACES)) {
            if (!(objectRef instanceof ComponentPort)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRequiredByComponentPorts(Interface interf) {
        for (Object objectRef : EObjectExt.getReferencers((EObject)interf, (EReference)InformationPackage.Literals.PORT__REQUIRED_INTERFACES)) {
            if (!(objectRef instanceof ComponentPort)) continue;
            return true;
        }
        return false;
    }

    public static EObject getTargetElementFromLink(EObject element) {
        if (element != null) {
            if (element instanceof InterfaceImplementation) {
                return ((InterfaceImplementation)element).getImplementedInterface();
            }
            if (element instanceof InterfaceUse) {
                return ((InterfaceUse)element).getUsedInterface();
            }
            if (element instanceof CapabilityRealizationInvolvement) {
                return ((CapabilityRealizationInvolvement)element).getInvolved();
            }
            if (element instanceof AbstractCapabilityExtend) {
                return ((AbstractCapabilityExtend)element).getExtended();
            }
            if (element instanceof AbstractCapabilityInclude) {
                return ((AbstractCapabilityInclude)element).getIncluded();
            }
            if (element instanceof AbstractCapabilityGeneralization) {
                return ((AbstractCapabilityGeneralization)element).getSuper();
            }
            if (element instanceof Generalization) {
                return ((Generalization)element).getSuper();
            }
        }
        return null;
    }

    public static Collection<AbstractExchangeItem> getAllExchangeItems(Interface interfasse) {
        HashSet<AbstractExchangeItem> interfaceExchangeItems = new HashSet<AbstractExchangeItem>();
        Iterator iterator = interfasse.getExchangeItems().iterator();
        while (iterator.hasNext()) {
            ExchangeItem exchangeItem2;
            ExchangeItem exchangeItem = exchangeItem2 = (ExchangeItem)iterator.next();
            interfaceExchangeItems.add((AbstractExchangeItem)exchangeItem);
        }
        return interfaceExchangeItems;
    }
}

