/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellacommon.Region;
import org.polarsys.capella.core.data.capellacommon.StateMachine;
import org.polarsys.capella.core.data.capellacore.ModellingArchitecture;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.Block;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.MissionPkg;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.DataType;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.la.LogicalFunctionPkg;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.oa.OperationalActivityPkg;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.oa.OperationalCapabilityPkg;
import org.polarsys.capella.core.data.oa.RolePkg;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.data.pa.PhysicalFunctionPkg;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;

public class ModelQueryHelper {
    public static CapabilityPkg getCapabilityPkg(Project project) {
        return (CapabilityPkg)ModelQueryHelper.getCapabilityPkgFrom(project, (ComponentArchitecture)ModelQueryHelper.getSystemAnalysis(project));
    }

    public static AbstractCapabilityPkg getCapabilityPkgFrom(Project project, ComponentArchitecture architecture) {
        if (architecture != null) {
            AbstractCapabilityPkg abstractCapabilityPkg = architecture.getOwnedAbstractCapabilityPkg();
            return abstractCapabilityPkg;
        }
        return null;
    }

    private static CapabilityRealizationPkg getCapabilityRealizationPkg(BlockArchitecture blockArchitecture) {
        AbstractCapabilityPkg abstractCapabilityPkg;
        if (blockArchitecture != null && (abstractCapabilityPkg = blockArchitecture.getOwnedAbstractCapabilityPkg()) instanceof CapabilityRealizationPkg) {
            return (CapabilityRealizationPkg)abstractCapabilityPkg;
        }
        return null;
    }

    private static DataPkg getDataPkg(BlockArchitecture blockArchitecture) {
        return blockArchitecture.getOwnedDataPkg();
    }

    public static EPBSArchitecture getEPBSArchitecture(Project project) {
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering(project);
        if (systemEngineering != null) {
            for (ModellingArchitecture arch : systemEngineering.getOwnedArchitectures()) {
                if (!(arch instanceof EPBSArchitecture)) continue;
                return (EPBSArchitecture)arch;
            }
        }
        return null;
    }

    public static ConfigurationItem getEpbsSystem(Project project) {
        EPBSArchitecture epbsArchitecture = ModelQueryHelper.getEPBSArchitecture(project);
        if (epbsArchitecture != null) {
            return (ConfigurationItem)epbsArchitecture.getSystem();
        }
        return null;
    }

    public static CapabilityRealizationPkg getLACapabilityRealizationPkg(Project project) {
        LogicalArchitecture logicalArchitecture = ModelQueryHelper.getLogicalArchitecture(project);
        if (logicalArchitecture != null) {
            return ModelQueryHelper.getCapabilityRealizationPkg((BlockArchitecture)logicalArchitecture);
        }
        return null;
    }

    public static DataPkg getLADataPkg(Project project) {
        LogicalArchitecture logicalArchitecture = ModelQueryHelper.getLogicalArchitecture(project);
        if (logicalArchitecture != null) {
            return ModelQueryHelper.getDataPkg((BlockArchitecture)logicalArchitecture);
        }
        return null;
    }

    public static LogicalComponentPkg getLogicalComponentPkg(Project project) {
        LogicalArchitecture logicalArchitecture = ModelQueryHelper.getLogicalArchitecture(project);
        if (logicalArchitecture != null) {
            return logicalArchitecture.getOwnedLogicalComponentPkg();
        }
        return null;
    }

    public static LogicalArchitecture getLogicalArchitecture(Project project) {
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering(project);
        if (systemEngineering != null) {
            for (ModellingArchitecture arch : systemEngineering.getOwnedArchitectures()) {
                if (!(arch instanceof LogicalArchitecture)) continue;
                return (LogicalArchitecture)arch;
            }
        }
        return null;
    }

    public static Region getLogicalStateMachineRegion(Project project) {
        LogicalComponent lc = ModelQueryHelper.getLogicalSystem(project);
        if (lc != null) {
            return ModelQueryHelper.getStateMachineRegion((Block)lc);
        }
        return null;
    }

    public static LogicalComponent getLogicalSystem(Project project) {
        LogicalArchitecture logicalArchitecture = ModelQueryHelper.getLogicalArchitecture(project);
        if (logicalArchitecture != null) {
            return (LogicalComponent)logicalArchitecture.getSystem();
        }
        return null;
    }

    public static DataPkg getOADataPkg(Project project) {
        DataPkg result = null;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null) {
            result = ModelQueryHelper.getDataPkg((BlockArchitecture)operationalAnalysis);
        }
        return result;
    }

    public static OperationalAnalysis getOperationalAnalysis(Project project) {
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering(project);
        if (systemEngineering != null) {
            for (ModellingArchitecture arch : systemEngineering.getOwnedArchitectures()) {
                if (!(arch instanceof OperationalAnalysis)) continue;
                return (OperationalAnalysis)arch;
            }
        }
        return null;
    }

    public static OperationalCapabilityPkg getOperationalCapabilityPkg(Project project) {
        AbstractCapabilityPkg abstractCapabilityPkg;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null && (abstractCapabilityPkg = operationalAnalysis.getOwnedAbstractCapabilityPkg()) instanceof OperationalCapabilityPkg) {
            return (OperationalCapabilityPkg)abstractCapabilityPkg;
        }
        return null;
    }

    public static EntityPkg getOperationalEntityPkg(Project project) {
        EntityPkg result = null;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null) {
            result = operationalAnalysis.getOwnedEntityPkg();
        }
        return result;
    }

    public static RolePkg getOperationalRolePkg(Project project) {
        RolePkg result = null;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null) {
            result = operationalAnalysis.getOwnedRolePkg();
        }
        return result;
    }

    public static CapabilityRealizationPkg getPACapabilityRealizationPkg(Project project) {
        PhysicalArchitecture physicalArchitecture = ModelQueryHelper.getPhysicalArchitecture(project);
        if (physicalArchitecture != null) {
            return ModelQueryHelper.getCapabilityRealizationPkg((BlockArchitecture)physicalArchitecture);
        }
        return null;
    }

    public static DataPkg getPADataPkg(Project project) {
        PhysicalArchitecture physicalArchitecture = ModelQueryHelper.getPhysicalArchitecture(project);
        if (physicalArchitecture != null) {
            return ModelQueryHelper.getDataPkg((BlockArchitecture)physicalArchitecture);
        }
        return null;
    }

    public static PhysicalComponentPkg getPhysicalComponentPkg(Project project) {
        PhysicalArchitecture physicalArchitecture = ModelQueryHelper.getPhysicalArchitecture(project);
        if (physicalArchitecture != null) {
            return physicalArchitecture.getOwnedPhysicalComponentPkg();
        }
        return null;
    }

    public static PhysicalArchitecture getPhysicalArchitecture(Project project) {
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering(project);
        if (systemEngineering != null) {
            for (ModellingArchitecture arch : systemEngineering.getOwnedArchitectures()) {
                if (!(arch instanceof PhysicalArchitecture)) continue;
                return (PhysicalArchitecture)arch;
            }
        }
        return null;
    }

    public static Region getPhysicalStateMachineRegion(Project project) {
        PhysicalComponent pc = ModelQueryHelper.getPhysicalSystem(project);
        if (pc != null) {
            return ModelQueryHelper.getStateMachineRegion((Block)pc);
        }
        return null;
    }

    public static PhysicalComponent getPhysicalSystem(Project project) {
        PhysicalArchitecture physicalArchitecture = ModelQueryHelper.getPhysicalArchitecture(project);
        if (physicalArchitecture != null) {
            return (PhysicalComponent)physicalArchitecture.getSystem();
        }
        return null;
    }

    public static ConfigurationItem getRootConfigurationItem(Project project) {
        EPBSArchitecture epbsArchitecture = ModelQueryHelper.getEPBSArchitecture(project);
        if (epbsArchitecture != null) {
            return (ConfigurationItem)epbsArchitecture.getSystem();
        }
        return null;
    }

    public static ConfigurationItemPkg getRootConfigurationItemPkg(Project project) {
        EPBSArchitecture epbsArchitecture = ModelQueryHelper.getEPBSArchitecture(project);
        if (epbsArchitecture != null) {
            return epbsArchitecture.getOwnedConfigurationItemPkg();
        }
        return null;
    }

    public static Entity getRootEntity(Project project) {
        EntityPkg pkg;
        Iterator iterator;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null && (iterator = (pkg = operationalAnalysis.getOwnedEntityPkg()).getOwnedEntities().iterator()).hasNext()) {
            Entity entity = (Entity)iterator.next();
            return entity;
        }
        return null;
    }

    public static LogicalFunction getRootLogicalFunction(Project project) {
        Iterator iterator;
        FunctionPkg pkg;
        LogicalArchitecture logicalArchitecture = ModelQueryHelper.getLogicalArchitecture(project);
        if (logicalArchitecture != null && (pkg = logicalArchitecture.getOwnedFunctionPkg()) instanceof LogicalFunctionPkg && (iterator = ((LogicalFunctionPkg)pkg).getOwnedLogicalFunctions().iterator()).hasNext()) {
            LogicalFunction fct = (LogicalFunction)iterator.next();
            return fct;
        }
        return null;
    }

    public static OperationalActivity getRootOperationalActivity(Project project) {
        Iterator iterator;
        FunctionPkg pkg;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null && (pkg = operationalAnalysis.getOwnedFunctionPkg()) instanceof OperationalActivityPkg && (iterator = ((OperationalActivityPkg)pkg).getOwnedOperationalActivities().iterator()).hasNext()) {
            OperationalActivity fct = (OperationalActivity)iterator.next();
            return fct;
        }
        return null;
    }

    public static OperationalActivity getAnOperationalActivity(String operationalActivityName, Project project) {
        OperationalActivity result = null;
        OperationalActivity rootOperationalActivity = ModelQueryHelper.getRootOperationalActivity(project);
        if (rootOperationalActivity != null) {
            EList subOpActivities = rootOperationalActivity.getChildrenOperationalActivities();
            for (OperationalActivity op : subOpActivities) {
                if (!op.getName().equalsIgnoreCase(operationalActivityName)) continue;
                result = op;
            }
        }
        return result;
    }

    public static OperationalCapabilityPkg getRootOperationalCapability(Project project) {
        AbstractCapabilityPkg pkg;
        OperationalAnalysis operationalAnalysis = ModelQueryHelper.getOperationalAnalysis(project);
        if (operationalAnalysis != null && (pkg = operationalAnalysis.getOwnedAbstractCapabilityPkg()) instanceof OperationalCapabilityPkg) {
            return (OperationalCapabilityPkg)pkg;
        }
        return null;
    }

    public static PhysicalFunction getRootPhysicalFunction(Project project) {
        Iterator iterator;
        FunctionPkg pkg;
        PhysicalArchitecture physicalArchitecture = ModelQueryHelper.getPhysicalArchitecture(project);
        if (physicalArchitecture != null && (pkg = physicalArchitecture.getOwnedFunctionPkg()) instanceof PhysicalFunctionPkg && (iterator = ((PhysicalFunctionPkg)pkg).getOwnedPhysicalFunctions().iterator()).hasNext()) {
            PhysicalFunction fct = (PhysicalFunction)iterator.next();
            return fct;
        }
        return null;
    }

    public static SystemFunction getRootSystemFunction(Project project) {
        Iterator iterator;
        FunctionPkg pkg;
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null && (pkg = systemAnalysis.getOwnedFunctionPkg()) instanceof SystemFunctionPkg && (iterator = ((SystemFunctionPkg)pkg).getOwnedSystemFunctions().iterator()).hasNext()) {
            SystemFunction fct = (SystemFunction)iterator.next();
            return fct;
        }
        return null;
    }

    public static AbstractCapabilityPkg getSACapabilityPkg(Project project) {
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            return systemAnalysis.getOwnedAbstractCapabilityPkg();
        }
        return null;
    }

    public static DataPkg getSADataPkg(Project project) {
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            return ModelQueryHelper.getDataPkg((BlockArchitecture)systemAnalysis);
        }
        return null;
    }

    public static MissionPkg getSAMissionPkg(Project project) {
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            return systemAnalysis.getOwnedMissionPkg();
        }
        return null;
    }

    public static Region getStateMachineRegion(Block block) {
        for (StateMachine sm : block.getOwnedStateMachines()) {
            Iterator iterator = sm.getOwnedRegions().iterator();
            if (!iterator.hasNext()) continue;
            Region region = (Region)iterator.next();
            return region;
        }
        return null;
    }

    public static SystemComponent getSystem(Project project) {
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            return (SystemComponent)systemAnalysis.getSystem();
        }
        return null;
    }

    public static ComponentPkg getSystemComponentPkg(Project project) {
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            return systemAnalysis.getOwnedSystemComponentPkg();
        }
        return null;
    }

    public static InterfacePkg getSystemInterfacePkg(Project project) {
        InterfacePkg resultInterfacePkg = null;
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            resultInterfacePkg = systemAnalysis.getOwnedInterfacePkg();
        }
        return resultInterfacePkg;
    }

    public static InterfacePkg getLogicalInterfacePkg(Project project) {
        InterfacePkg resultInterfacePkg = null;
        LogicalArchitecture logicalArchitecture = ModelQueryHelper.getLogicalArchitecture(project);
        if (logicalArchitecture != null) {
            resultInterfacePkg = logicalArchitecture.getOwnedInterfacePkg();
        }
        return resultInterfacePkg;
    }

    public static DataPkg getSystemDataPkg(Project project) {
        DataPkg resultDataPkg = null;
        SystemAnalysis systemAnalysis = ModelQueryHelper.getSystemAnalysis(project);
        if (systemAnalysis != null) {
            resultDataPkg = systemAnalysis.getOwnedDataPkg();
        }
        return resultDataPkg;
    }

    public static DataPkg getSystemDataPredefinedTypesPkg(Project project) {
        DataPkg result = null;
        DataPkg systemDataPkg = ModelQueryHelper.getSystemDataPkg(project);
        EList ownedDataPkgs = systemDataPkg.getOwnedDataPkgs();
        for (DataPkg dataPkg : ownedDataPkgs) {
            if (!NamingConstants.PredefinedTypesCmd_predefinedDataTypePkg_name.equalsIgnoreCase(dataPkg.getName())) continue;
            result = dataPkg;
        }
        return result;
    }

    public static DataType getBooleanTypeFromPredefinedTypesPkg(DataPkg predefinedTypesPkg) {
        EList ownedDataTypes = predefinedTypesPkg.getOwnedDataTypes();
        DataType resultDataType = null;
        for (DataType dataType : ownedDataTypes) {
            if (!(dataType instanceof BooleanType)) continue;
            resultDataType = dataType;
        }
        return resultDataType;
    }

    public static SystemAnalysis getSystemAnalysis(Project project) {
        SystemEngineering systemEngineering = ModelQueryHelper.getSystemEngineering(project);
        if (systemEngineering != null) {
            for (ModellingArchitecture arch : systemEngineering.getOwnedArchitectures()) {
                if (!(arch instanceof SystemAnalysis)) continue;
                return (SystemAnalysis)arch;
            }
        }
        return null;
    }

    public static SystemEngineering getSystemEngineering(Project project) {
        if (project != null) {
            for (ModelRoot root : project.getOwnedModelRoots()) {
                if (!(root instanceof SystemEngineering)) continue;
                return (SystemEngineering)root;
            }
        }
        return null;
    }

    public static Region getSystemStateMachineRegion(Project project) {
        SystemComponent system = ModelQueryHelper.getSystem(project);
        if (system != null) {
            return ModelQueryHelper.getStateMachineRegion((Block)system);
        }
        return null;
    }
}

