/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.data.activity.ActivityNode;
import org.polarsys.capella.common.data.modellingcore.AbstractInformationFlow;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.cache.ModelCache;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.cs.PhysicalPort;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.ComponentExchangeKind;
import org.polarsys.capella.core.data.fa.ComponentPort;
import org.polarsys.capella.core.data.fa.ComponentPortAllocation;
import org.polarsys.capella.core.data.fa.ComponentPortKind;
import org.polarsys.capella.core.data.fa.ExchangeSpecification;
import org.polarsys.capella.core.data.fa.FaFactory;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.OrientationPortKind;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Port;
import org.polarsys.capella.core.data.information.PortAllocation;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PartExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.model.helpers.RefinementLinkExt;

public class PortExt {
    public static void attachPort(Port port, ActivityNode activityNode) {
        if ((activityNode instanceof AbstractFunction || activityNode instanceof FunctionPort) && !PortExt.isRelatedTo(port, activityNode)) {
            PortAllocation portrealS = InformationFactory.eINSTANCE.createPortAllocation();
            portrealS.setSourceElement((TraceableElement)port);
            portrealS.setTargetElement((TraceableElement)activityNode);
            port.getOwnedPortAllocations().add((Object)portrealS);
            CapellaElementExt.creationService((EObject)portrealS);
        }
    }

    public static boolean canCommunicate(ComponentPort sourcePort, ComponentPort targetPort) {
        EList providedInterfaces = sourcePort.getProvidedInterfaces();
        boolean matched = false;
        Iterator iterator = providedInterfaces.iterator();
        while (iterator.hasNext() && !matched) {
            Interface providedInterface = (Interface)iterator.next();
            matched = targetPort.getRequiredInterfaces().contains((Object)providedInterface);
        }
        if (!matched) {
            EList requiredInterfaces = sourcePort.getRequiredInterfaces();
            iterator = requiredInterfaces.iterator();
            while (iterator.hasNext() && !matched) {
                Interface requiredInterface = (Interface)iterator.next();
                matched = targetPort.getProvidedInterfaces().contains((Object)requiredInterface);
            }
        }
        return matched;
    }

    public static ComponentPort createInFlowPort() {
        ComponentPort inP = FaFactory.eINSTANCE.createComponentPort();
        inP.setKind(ComponentPortKind.FLOW);
        inP.setOrientation(OrientationPortKind.IN);
        return inP;
    }

    public static ComponentPort createInFlowPort(String name) {
        ComponentPort inP = FaFactory.eINSTANCE.createComponentPort(name);
        inP.setKind(ComponentPortKind.FLOW);
        inP.setOrientation(OrientationPortKind.IN);
        return inP;
    }

    public static ComponentPort createOutFlowPort() {
        ComponentPort inP = FaFactory.eINSTANCE.createComponentPort();
        inP.setKind(ComponentPortKind.FLOW);
        inP.setOrientation(OrientationPortKind.OUT);
        return inP;
    }

    public static ComponentPort createOutFlowPort(String name) {
        ComponentPort inP = FaFactory.eINSTANCE.createComponentPort(name);
        inP.setKind(ComponentPortKind.FLOW);
        inP.setOrientation(OrientationPortKind.OUT);
        return inP;
    }

    public static ComponentPort createStandardPort() {
        ComponentPort inP = FaFactory.eINSTANCE.createComponentPort();
        inP.setKind(ComponentPortKind.STANDARD);
        return inP;
    }

    public static final List<ComponentExchange> getAssemblyComponentExchanges(ComponentPort port) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            if (flow.getKind() != ComponentExchangeKind.ASSEMBLY) continue;
            componentExchanges.add(flow);
        }
        return componentExchanges;
    }

    public static final Collection<ComponentPort> getConnectedComponentPortsWithoutDelegation(ComponentPort port) {
        HashSet<ComponentPort> connected = new HashSet<ComponentPort>(1);
        for (ComponentExchange ex : port.getComponentExchanges()) {
            if (ex.getKind() == ComponentExchangeKind.DELEGATION) continue;
            Port sourcePort = ComponentExchangeExt.getSourcePort(ex);
            Port targetPort = ComponentExchangeExt.getTargetPort(ex);
            if (sourcePort != null && sourcePort instanceof ComponentPort) {
                connected.add((ComponentPort)sourcePort);
            }
            if (targetPort == null || !(targetPort instanceof ComponentPort)) continue;
            connected.add((ComponentPort)targetPort);
        }
        connected.remove(port);
        return connected;
    }

    public static final Collection<ComponentPort> getConnectedComponentPorts(ComponentPort port) {
        HashSet<ComponentPort> connected = new HashSet<ComponentPort>(1);
        for (ComponentExchange ex : port.getComponentExchanges()) {
            Port sourcePort = ComponentExchangeExt.getSourcePort(ex);
            Port targetPort = ComponentExchangeExt.getTargetPort(ex);
            if (sourcePort != null && sourcePort instanceof ComponentPort) {
                connected.add((ComponentPort)sourcePort);
            }
            if (targetPort == null || !(targetPort instanceof ComponentPort)) continue;
            connected.add((ComponentPort)targetPort);
        }
        connected.remove(port);
        return connected;
    }

    public static final List<ComponentPortAllocation> getIncomingComponentPortAllocations(ComponentPort port) {
        ArrayList<ComponentPortAllocation> componentExchanges = new ArrayList<ComponentPortAllocation>(1);
        for (AbstractTrace flow : port.getIncomingTraces()) {
            if (!(flow instanceof ComponentPortAllocation)) continue;
            componentExchanges.add((ComponentPortAllocation)flow);
        }
        return componentExchanges;
    }

    public static final List<ComponentExchange> getDelegationComponentExchanges(ComponentPort port) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            if (flow.getKind() != ComponentExchangeKind.DELEGATION) continue;
            componentExchanges.add(flow);
        }
        return componentExchanges;
    }

    public static final List<ComponentExchange> getFlowComponentExchanges(ComponentPort port) {
        ArrayList<ComponentExchange> componentExchanges = new ArrayList<ComponentExchange>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            if (flow.getKind() != ComponentExchangeKind.FLOW) continue;
            componentExchanges.add(flow);
        }
        return componentExchanges;
    }

    public static final Collection<ComponentPort> getAllLinkedDelegatedComponentPorts(ComponentPort componentPort1) {
        ComponentPort port;
        LinkedList<ComponentPort> ports = new LinkedList<ComponentPort>();
        ArrayList<ComponentPort> visited = new ArrayList<ComponentPort>();
        ports.add(componentPort1);
        while (ports.size() > 0) {
            port = (ComponentPort)ports.removeFirst();
            if (visited.contains(port)) continue;
            visited.add(port);
            ports.addAll(PortExt.getDelegatingComponentPorts(port));
        }
        visited.remove(componentPort1);
        ports.add(componentPort1);
        while (ports.size() > 0) {
            port = (ComponentPort)ports.removeFirst();
            if (visited.contains(port)) continue;
            visited.add(port);
            ports.addAll(PortExt.getDelegatedComponentPorts(port));
        }
        return visited;
    }

    public static final Collection<ComponentPort> getAllDelegatedComponentPorts(ComponentPort componentPort1) {
        LinkedList<ComponentPort> ports = new LinkedList<ComponentPort>();
        HashSet<ComponentPort> visited = new HashSet<ComponentPort>();
        ports.add(componentPort1);
        while (ports.size() > 0) {
            ComponentPort port = (ComponentPort)ports.removeFirst();
            if (visited.contains(port)) continue;
            visited.add(port);
            ports.addAll(PortExt.getDelegatedComponentPorts(port));
        }
        visited.remove(componentPort1);
        return visited;
    }

    public static final Collection<ComponentPort> getAllDelegatingComponentPorts(ComponentPort componentPort1) {
        LinkedList<ComponentPort> ports = new LinkedList<ComponentPort>();
        HashSet<ComponentPort> visited = new HashSet<ComponentPort>();
        ports.add(componentPort1);
        while (ports.size() > 0) {
            ComponentPort port = (ComponentPort)ports.removeFirst();
            if (visited.contains(port)) continue;
            visited.add(port);
            ports.addAll(PortExt.getDelegatingComponentPorts(port));
        }
        visited.remove(componentPort1);
        return visited;
    }

    public static final Collection<ComponentPort> getDelegatingComponentPorts(ComponentPort port) {
        ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            Port opposite;
            if (flow.getKind() != ComponentExchangeKind.DELEGATION || !port.equals(ComponentExchangeExt.getTargetPort(flow)) || !((opposite = ComponentExchangeExt.getOppositePort(flow, (Port)port)) instanceof ComponentPort)) continue;
            ports.add((ComponentPort)opposite);
        }
        return ports;
    }

    public static final Collection<ComponentExchange> getDelegatingComponentExchanges(ComponentPort port) {
        ArrayList<ComponentExchange> exchanges = new ArrayList<ComponentExchange>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            if (flow.getKind() != ComponentExchangeKind.DELEGATION || !port.equals(ComponentExchangeExt.getTargetPort(flow))) continue;
            exchanges.add(flow);
        }
        return exchanges;
    }

    public static final Collection<ComponentPort> getDelegatedComponentPorts(ComponentPort port) {
        ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            Port opposite;
            if (flow.getKind() != ComponentExchangeKind.DELEGATION || !port.equals(ComponentExchangeExt.getSourcePort(flow)) || !((opposite = ComponentExchangeExt.getOppositePort(flow, (Port)port)) instanceof ComponentPort)) continue;
            ports.add((ComponentPort)opposite);
        }
        return ports;
    }

    public static final Collection<ComponentExchange> getDelegatedComponentExchanges(ComponentPort port) {
        ArrayList<ComponentExchange> exchanges = new ArrayList<ComponentExchange>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            if (flow.getKind() != ComponentExchangeKind.DELEGATION || !port.equals(ComponentExchangeExt.getSourcePort(flow))) continue;
            exchanges.add(flow);
        }
        return exchanges;
    }

    public static final Collection<ComponentPort> getLinkedDelegatedComponentPorts(ComponentPort port) {
        ArrayList<ComponentPort> ports = new ArrayList<ComponentPort>(1);
        for (ComponentExchange flow : port.getComponentExchanges()) {
            Port opposite;
            if (flow.getKind() != ComponentExchangeKind.DELEGATION || !((opposite = ComponentExchangeExt.getOppositePort(flow, (Port)port)) instanceof ComponentPort)) continue;
            ports.add((ComponentPort)opposite);
        }
        return ports;
    }

    public static List<Interface> getProvidedInterfaces(ComponentPort port) {
        SystemComponent portType;
        ArrayList<Interface> providedInterfaces = new ArrayList<Interface>();
        if (port != null && (portType = (SystemComponent)port.getType()) != null) {
            if (portType instanceof PhysicalComponent) {
                PhysicalComponent pc = (PhysicalComponent)portType;
                providedInterfaces.addAll(PhysicalComponentExt.getProvidedInterfaces(pc));
            } else {
                EList providedSet = portType.getImplementedInterfaces();
                for (Interface itf : providedSet) {
                    providedInterfaces.add(itf);
                }
            }
        }
        return providedInterfaces;
    }

    public static Component getRelatedComponent(ComponentPort port) {
        if (port.eContainer() instanceof Component) {
            return (Component)port.eContainer();
        }
        return null;
    }

    public static Component getRelatedComponent(PhysicalPort port) {
        if (port.eContainer() instanceof Component) {
            return (Component)port.eContainer();
        }
        return null;
    }

    public static final List<ExchangeSpecification> getRelatedExchangeSpecifications(ComponentPort port) {
        ArrayList<ExchangeSpecification> exchanges = new ArrayList<ExchangeSpecification>(1);
        for (AbstractInformationFlow flow : port.getInformationFlows()) {
            if (!(flow instanceof ExchangeSpecification)) continue;
            ExchangeSpecification exchange = (ExchangeSpecification)flow;
            exchanges.add(exchange);
        }
        return exchanges;
    }

    public static List<Interface> getRequiredInterfaces(ComponentPort port) {
        SystemComponent portType;
        ArrayList<Interface> requiredInterfaces = new ArrayList<Interface>();
        if (port != null && (portType = (SystemComponent)port.getType()) != null) {
            if (portType instanceof PhysicalComponent) {
                PhysicalComponent pc = (PhysicalComponent)portType;
                requiredInterfaces.addAll(PhysicalComponentExt.getRequiredInterfaces(pc));
            } else {
                EList requiredSet = portType.getUsedInterfaces();
                for (Interface itf : requiredSet) {
                    requiredInterfaces.add(itf);
                }
            }
        }
        return requiredInterfaces;
    }

    public static final boolean haveComplementaryOrientation(ComponentPort first, ComponentPort second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getOrientation() == OrientationPortKind.IN) {
            return second.getOrientation() != OrientationPortKind.IN;
        }
        if (first.getOrientation() == OrientationPortKind.OUT) {
            return second.getOrientation() != OrientationPortKind.OUT;
        }
        return true;
    }

    public static final boolean haveSameOrientation(ComponentPort first, ComponentPort second) {
        if (first == null || second == null) {
            return false;
        }
        if (first.getOrientation() == OrientationPortKind.IN) {
            return second.getOrientation() != OrientationPortKind.OUT;
        }
        if (first.getOrientation() == OrientationPortKind.OUT) {
            return second.getOrientation() != OrientationPortKind.IN;
        }
        return true;
    }

    public static Boolean isRelatedComponentAllocatingRelatedFunction(ComponentPort componentPort, ActivityNode functionPort) {
        EList allocatingComponents;
        Component component = PortExt.getRelatedComponent(componentPort);
        if (component == null) {
            return null;
        }
        AbstractFunction abstractFunction = FunctionExt.getRelatedFunction((ActivityNode)functionPort);
        if (abstractFunction == null) {
            return null;
        }
        List<Component> componentsHierarchy = ComponentExt.getAllSubUsedAndDeployedComponents(component);
        if (Collections.disjoint(componentsHierarchy, allocatingComponents = abstractFunction.getAllocationBlocks())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public static boolean isFlowPort(EObject aFeature) {
        return aFeature instanceof ComponentPort && ((ComponentPort)aFeature).getKind() == ComponentPortKind.FLOW;
    }

    public static boolean isIn(ComponentPort aFeature) {
        return aFeature.getOrientation() == OrientationPortKind.IN || aFeature.getOrientation() == OrientationPortKind.INOUT;
    }

    public static boolean isInFlowPort(EObject port) {
        return PortExt.isFlowPort(port) && PortExt.isIn((ComponentPort)port);
    }

    public static boolean isInStrictFlowPort(EObject port) {
        return PortExt.isFlowPort(port) && PortExt.isInStrict((ComponentPort)port);
    }

    public static boolean isInStrict(ComponentPort cp) {
        return OrientationPortKind.IN.equals((Object)cp.getOrientation());
    }

    public static boolean isOutStrict(ComponentPort cp) {
        return OrientationPortKind.OUT.equals((Object)cp.getOrientation());
    }

    public static boolean isInoutStrict(ComponentPort cp) {
        return OrientationPortKind.INOUT.equals((Object)cp.getOrientation());
    }

    public static boolean isNotCompatibleWith(ComponentPort comparedPort, ComponentPort reference) {
        if (comparedPort == null || reference == null) {
            return true;
        }
        SystemComponent comparedType = (SystemComponent)comparedPort.getType();
        SystemComponent referenceType = (SystemComponent)reference.getType();
        if (comparedType == null || referenceType == null) {
            return true;
        }
        EList comparedProvItf = comparedPort.getProvidedInterfaces();
        EList comparedReqItf = comparedPort.getRequiredInterfaces();
        EList referenceProvItf = reference.getProvidedInterfaces();
        EList referenceReqItf = reference.getRequiredInterfaces();
        for (Interface refItf : referenceReqItf) {
            if (!comparedProvItf.contains(refItf)) continue;
            return false;
        }
        for (Interface refItf : referenceProvItf) {
            if (!comparedReqItf.contains(refItf)) continue;
            return false;
        }
        return true;
    }

    public static boolean isOut(ComponentPort aFeature) {
        return aFeature.getOrientation() == OrientationPortKind.OUT || aFeature.getOrientation() == OrientationPortKind.INOUT;
    }

    public static boolean isOutFlowPort(EObject port) {
        return PortExt.isFlowPort(port) && PortExt.isOut((ComponentPort)port);
    }

    public static boolean isOutStrictFlowPort(EObject port) {
        return PortExt.isFlowPort(port) && PortExt.isOutStrict((ComponentPort)port);
    }

    public static boolean isInoutStrictFlowPort(EObject port) {
        return PortExt.isFlowPort(port) && PortExt.isInoutStrict((ComponentPort)port);
    }

    public static boolean isRelatedTo(Port cport, ActivityNode fport) {
        if (cport == null || fport == null) {
            return false;
        }
        for (AbstractTrace trace : cport.getIncomingTraces()) {
            if (trace.getSourceElement() != null && trace.getSourceElement().equals(fport)) {
                return true;
            }
            if (trace.getTargetElement() == null || !trace.getTargetElement().equals(fport)) continue;
            return true;
        }
        for (AbstractTrace trace : cport.getOutgoingTraces()) {
            if (trace.getSourceElement() != null && trace.getSourceElement().equals(fport)) {
                return true;
            }
            if (trace.getTargetElement() == null || !trace.getTargetElement().equals(fport)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStandardPort(Object aFeature) {
        return aFeature instanceof ComponentPort && ((ComponentPort)aFeature).getKind() == ComponentPortKind.STANDARD;
    }

    public static boolean isTransitionedTo(ComponentPort sourcePrevious, ComponentPort sourceCurrent) {
        if (RefinementLinkExt.isLinkedTo((TraceableElement)sourceCurrent, (TraceableElement)sourcePrevious)) {
            return true;
        }
        for (ComponentPort port : PortExt.retrieveParentDelegating(sourceCurrent)) {
            if (!RefinementLinkExt.isLinkedTo((TraceableElement)port, (TraceableElement)sourcePrevious)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTransitionedTo(FunctionPort sourcePrevious, FunctionPort sourceCurrent) {
        return RefinementLinkExt.isLinkedTo((TraceableElement)sourceCurrent, (TraceableElement)sourcePrevious);
    }

    public static Collection<ComponentPort> retrieveParentDelegating(ComponentPort sourceCurrent) {
        LinkedList<ComponentPort> ports = new LinkedList<ComponentPort>();
        HashSet<ComponentPort> visited = new HashSet<ComponentPort>();
        ports.add(sourceCurrent);
        while (ports.size() > 0) {
            ComponentPort port = (ComponentPort)ports.removeFirst();
            visited.add(port);
            for (ComponentPort cp : PortExt.getLinkedDelegatedComponentPorts(sourceCurrent)) {
                if (visited.contains(cp)) continue;
                ports.addLast(cp);
            }
        }
        return visited;
    }

    public static boolean transitionedPortIsValid(ActivityNode eObj, TraceableElement container) {
        if (container != null) {
            for (AbstractTrace traceFunction : container.getIncomingTraces()) {
                AbstractFunction targetFunction;
                if (!(traceFunction.getSourceElement() instanceof AbstractFunction) || !EcoreUtil2.isOrIsContainedBy((EObject)eObj, (EObject)(targetFunction = (AbstractFunction)traceFunction.getSourceElement()))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean transitionedPortIsValid(ComponentPort eObj) {
        for (AbstractTrace trace : eObj.getOutgoingTraces()) {
            ComponentPort exc;
            Component container;
            if (!(trace.getTargetElement() instanceof ComponentPort) || !PortExt.transitionedPortIsValid(eObj, (TraceableElement)(container = (Component)(exc = (ComponentPort)trace.getTargetElement()).eContainer()))) continue;
            return true;
        }
        return false;
    }

    public static boolean transitionedPortIsValid(ComponentPort eObj, TraceableElement container) {
        if (container != null) {
            for (AbstractTrace traceFunction : container.getIncomingTraces()) {
                if (!(traceFunction.getSourceElement() instanceof Component)) continue;
                Component targetFunction = (Component)traceFunction.getSourceElement();
                if (eObj.eContainer() != targetFunction && !ComponentExt.isComponentAncestor((Component)eObj.eContainer(), targetFunction)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean transitionedPortIsValid(FunctionPort eObj) {
        for (AbstractTrace trace : eObj.getOutgoingTraces()) {
            if (!(trace.getTargetElement() instanceof FunctionPort)) continue;
            FunctionPort exc = (FunctionPort)trace.getTargetElement();
            AbstractFunction container = (AbstractFunction)exc.eContainer();
            if (!(eObj instanceof ActivityNode) || !PortExt.transitionedPortIsValid((ActivityNode)eObj, (TraceableElement)container)) continue;
            return true;
        }
        return false;
    }

    public static Collection<PhysicalLink> getDelegatedPhysicalLinks(PhysicalPort port) {
        HashSet<PhysicalLink> links = new HashSet<PhysicalLink>();
        Component component = PortExt.getRelatedComponent(port);
        Collection parts = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)component);
        for (PhysicalLink link : port.getInvolvedLinks()) {
            Collection<Part> firstPartAncestors;
            Collection sourceParts = PhysicalLinkExt.getSourceParts((PhysicalLink)link);
            Collection targetParts = PhysicalLinkExt.getTargetParts((PhysicalLink)link);
            boolean isSource = false;
            boolean isTarget = false;
            for (Part owningPart : parts) {
                if (sourceParts.contains(owningPart)) {
                    isSource = true;
                    continue;
                }
                if (!targetParts.contains(owningPart)) continue;
                isTarget = true;
            }
            if (isSource && !isTarget) {
                block2: for (Part part : targetParts) {
                    firstPartAncestors = PartExt.getFirstPartAncestors(part);
                    for (Part part2 : firstPartAncestors) {
                        if (!sourceParts.contains(part2)) continue;
                        links.add(link);
                        continue block2;
                    }
                }
                continue;
            }
            if (!isTarget || isSource) continue;
            block4: for (Part part : sourceParts) {
                firstPartAncestors = PartExt.getFirstPartAncestors(part);
                for (Part part2 : firstPartAncestors) {
                    if (!targetParts.contains(part2)) continue;
                    links.add(link);
                    continue block4;
                }
            }
        }
        return links;
    }

    public static Collection<PhysicalLink> getDelegatingPhysicalLinks(PhysicalPort port) {
        HashSet<PhysicalLink> links = new HashSet<PhysicalLink>();
        Component component = PortExt.getRelatedComponent(port);
        Collection parts = (Collection)ModelCache.getCache(ComponentExt::getRepresentingParts, (Object)component);
        for (PhysicalLink link : port.getInvolvedLinks()) {
            Collection<Part> firstPartAncestors;
            Collection sourceParts = PhysicalLinkExt.getSourceParts((PhysicalLink)link);
            Collection targetParts = PhysicalLinkExt.getTargetParts((PhysicalLink)link);
            boolean isSource = false;
            boolean isTarget = false;
            for (Part owningPart : parts) {
                if (sourceParts.contains(owningPart)) {
                    isSource = true;
                    continue;
                }
                if (!targetParts.contains(owningPart)) continue;
                isTarget = true;
            }
            if (isSource && !isTarget) {
                block2: for (Part part : sourceParts) {
                    firstPartAncestors = PartExt.getFirstPartAncestors(part);
                    for (Part part2 : firstPartAncestors) {
                        if (!targetParts.contains(part2)) continue;
                        links.add(link);
                        continue block2;
                    }
                }
                continue;
            }
            if (!isTarget || isSource) continue;
            block4: for (Part part : targetParts) {
                firstPartAncestors = PartExt.getFirstPartAncestors(part);
                for (Part part2 : firstPartAncestors) {
                    if (!sourceParts.contains(part2)) continue;
                    links.add(link);
                    continue block4;
                }
            }
        }
        return links;
    }

    public static Collection<PhysicalLink> getDelegationPhysicalLinks(PhysicalPort port) {
        ArrayList<PhysicalLink> links = new ArrayList<PhysicalLink>();
        links.addAll(PortExt.getDelegatedPhysicalLinks(port));
        links.addAll(PortExt.getDelegatingPhysicalLinks(port));
        return links;
    }
}

