/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.data.fa.FunctionPort;
import org.polarsys.capella.core.data.fa.FunctionalChain;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.model.helpers.graph.Graph;
import org.polarsys.capella.core.model.helpers.graph.GraphEdge;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;
import org.polarsys.capella.core.model.helpers.graph.InternalLink;
import org.polarsys.capella.core.model.helpers.graph.InvolvementGraph;

public class InternalLinksGraph
extends Graph<FunctionalChain, FunctionPort, InternalLink, InternalLinkNode, InternalLinkEdge> {
    public InternalLinksGraph(InvolvementGraph involvementGraph) {
        super((FunctionalChain)involvementGraph.getSemantic());
        for (InvolvementGraph.InvolvementEdge edge : involvementGraph.getEdges().values()) {
            if (!involvementGraph.isInvolvingFunctionalExchange(edge)) continue;
            FunctionalExchange exchange = involvementGraph.getInvolvedFunctionalExchange(edge);
            InternalLinkNode sourceCurrent = (InternalLinkNode)this.getOrCreateNode((FunctionPort)exchange.getSource());
            for (InvolvementGraph.InvolvementEdge e : ((InvolvementGraph.InvolvementNode)edge.getSource()).getIncomingEdges()) {
                if (!involvementGraph.isInvolvingFunctionalExchange(e)) continue;
                FunctionalExchange previousExchange = involvementGraph.getInvolvedFunctionalExchange(e);
                InternalLinkNode targetPrevious = (InternalLinkNode)this.getOrCreateNode((FunctionPort)previousExchange.getTarget());
                InternalLinkEdge newEdge = (InternalLinkEdge)this.getOrCreateEdge(new InternalLink((FunctionPort)targetPrevious.getSemantic(), (FunctionPort)sourceCurrent.getSemantic()));
                newEdge.setSource(targetPrevious);
                newEdge.setTarget(sourceCurrent);
            }
        }
    }

    public boolean hasInternalLink(EObject source, EObject target) {
        return this.edges.keySet().stream().filter(InternalLink.class::isInstance).map(InternalLink.class::cast).anyMatch(key -> key.getSource() == source && key.getTarget() == target);
    }

    @Override
    public InternalLinkNode createNode(FunctionPort semantic) {
        return new InternalLinkNode(semantic);
    }

    @Override
    public InternalLinkEdge createEdge(InternalLink semantic) {
        return new InternalLinkEdge(semantic);
    }

    public class InternalLinkEdge
    extends GraphEdge<InternalLink, InternalLinkNode> {
        public InternalLinkEdge(InternalLink semantic) {
            super(semantic);
        }
    }

    public class InternalLinkNode
    extends GraphNode<FunctionPort, InternalLinkEdge> {
        public InternalLinkNode(FunctionPort semantic) {
            super(semantic);
        }
    }
}

