/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.registry;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.codegen.ecore.genmodel.GenModel;
import org.eclipse.emf.codegen.ecore.genmodel.GenPackage;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EPackageRegistryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public final class CapellaPackageRegistry {
    private static final URI CAPELLA_GENMODEL_URI = URI.createPlatformResourceURI((String)"org.polarsys.capella.core.data.gen/model/CapellaModeller.genmodel", (boolean)true);
    private static Collection<EPackage> allCapellaPackages = null;

    private CapellaPackageRegistry() {
    }

    public static synchronized Collection<EPackage> getAllCapellaPackages() {
        if (allCapellaPackages == null) {
            ArrayList<EPackage> l = new ArrayList<EPackage>();
            for (GenPackage p : CapellaPackageRegistry.getCapellaGenModel().getAllGenAndUsedGenPackagesWithClassifiers()) {
                EPackage registered = EPackage.Registry.INSTANCE.getEPackage(p.getNSURI());
                if (registered != null) {
                    l.add(registered);
                    continue;
                }
                l.add(p.getEcorePackage());
            }
            allCapellaPackages = Collections.unmodifiableList(l);
        }
        return allCapellaPackages;
    }

    public static EPackage.Registry create(EPackage.Registry delegate) {
        EPackageRegistryImpl registry = new EPackageRegistryImpl(delegate);
        for (EPackage p : CapellaPackageRegistry.getAllCapellaPackages()) {
            registry.put((Object)p.getNsURI(), (Object)p);
        }
        return registry;
    }

    private static GenModel getCapellaGenModel() {
        ResourceSetImpl rs = new ResourceSetImpl();
        rs.getURIConverter().getURIMap().putAll(EcorePlugin.computePlatformURIMap());
        return (GenModel)rs.getResource(CAPELLA_GENMODEL_URI, true).getContents().get(0);
    }
}

