/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.metric.actions;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.metric.MetricActivator;
import org.polarsys.capella.core.ui.metric.MetricMessages;
import org.polarsys.capella.core.ui.metric.actions.ProgressMonitoringActionsHelper;
import org.polarsys.capella.core.ui.metric.dialog.ProgressMonitoringOverviewDialog;
import org.polarsys.capella.core.ui.metric.utils.ProgressMonitoringPropagator;

public class ProgressMonitoringOverviewAction
extends BaseSelectionListenerAction {
    public ProgressMonitoringOverviewAction() {
        super(MetricMessages.progressMonitoring_overviewAction_lbl);
        this.setImageDescriptor(MetricActivator.getDefault().getImageDescriptor("chart_16.gif"));
    }

    public void run() {
        EObject rootSemanticObject = ProgressMonitoringActionsHelper.getSelectedEObject(this.getStructuredSelection());
        if (rootSemanticObject == null) {
            return;
        }
        ProgressMonitoringOverviewDialog dialog = new ProgressMonitoringOverviewDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), MetricMessages.progressMonitoring_dialog_title, MetricMessages.progressMonitoring_dialog_msg, rootSemanticObject, ProgressMonitoringPropagator.getInstance().getTaggedObjects(rootSemanticObject));
        dialog.open();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean showProgressActions = false;
        if (selection != null && selection.size() == 1) {
            Object selectedObj = selection.getFirstElement();
            if (selectedObj instanceof IFile) {
                Session session = SessionHelper.getSession((IFile)((IFile)selectedObj));
                if (session != null && session.isOpen()) {
                    Resource resource = session.getSessionResource();
                    DAnalysis da = (DAnalysis)EcoreUtil.getObjectByType((Collection)resource.getContents(), (EClassifier)ViewpointPackage.Literals.DANALYSIS);
                    ArrayList models = new ArrayList();
                    if (da != null) {
                        models.addAll(da.getModels());
                        for (DAnalysis refDa : da.getReferencedAnalysis()) {
                            models.addAll(refDa.getModels());
                        }
                    }
                    for (EObject model : models) {
                        boolean bl = showProgressActions = showProgressActions || ProgressMonitoringPropagator.getInstance().isEnumerationPropertyTypeDefinedForProject(model);
                    }
                }
            } else if (selectedObj instanceof EObject) {
                return ProgressMonitoringPropagator.getInstance().isEnumerationPropertyTypeDefinedForProject((EObject)selectedObj);
            }
        }
        return false;
    }
}

