/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.system.rules.cs;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.ComponentPkg;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.ctx.SystemComponentPkg;
import org.polarsys.capella.core.data.la.LaPackage;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.data.la.LogicalComponentPkg;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.data.oa.EntityPkg;
import org.polarsys.capella.core.data.oa.OaPackage;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.transition.common.handlers.contextscope.ContextScopeHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.selection.EClassSelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.ISelectionContext;
import org.polarsys.capella.core.transition.common.handlers.selection.SelectionContextHandlerHelper;
import org.polarsys.capella.core.transition.common.handlers.transformation.TransformationHandlerHelper;
import org.polarsys.capella.core.transition.system.rules.AbstractCapellaElementRule;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class ComponentPkgRule
extends AbstractCapellaElementRule {
    @Override
    protected EClass getSourceType() {
        return CsPackage.Literals.COMPONENT_PKG;
    }

    protected void retrieveContainer(EObject element, List<EObject> result, IContext context) {
        if (!(element.eContainer() instanceof BlockArchitecture)) {
            super.retrieveContainer(element, result, context);
        }
    }

    protected EObject getBestContainer(EObject element, EObject result, IContext context) {
        EObject container = element.eContainer();
        if (container != null) {
            EObject parent = container;
            while (parent != null) {
                ISelectionContext sContext = SelectionContextHandlerHelper.getHandler((IContext)context).getSelectionContext(context, "SC__T", element, result);
                EObject targetContainer = TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(parent, context, (ISelectionContext)new EClassSelectionContext(sContext, CsPackage.Literals.COMPONENT));
                if (targetContainer == null) {
                    targetContainer = TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(parent, context, sContext);
                }
                if (targetContainer != null) {
                    return targetContainer;
                }
                parent = parent.eContainer();
            }
        }
        return super.getBestContainer(element, result, context);
    }

    protected EObject getDefaultContainer(EObject element, EObject result, IContext context) {
        EObject root = TransformationHandlerHelper.getInstance((IContext)context).getLevelElement(element, context);
        BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(root, context, CsPackage.Literals.BLOCK_ARCHITECTURE, element, result);
        if (result instanceof SystemComponentPkg) {
            return BlockArchitectureExt.getComponentPkg((BlockArchitecture)target);
        }
        if (result instanceof LogicalComponentPkg) {
            return BlockArchitectureExt.getComponentPkg((BlockArchitecture)target);
        }
        if (result instanceof PhysicalComponentPkg) {
            return BlockArchitectureExt.getComponentPkg((BlockArchitecture)target);
        }
        return target;
    }

    @Override
    protected void retrieveGoDeep(EObject source, List<EObject> result, IContext context) {
        super.retrieveGoDeep(source, result, context);
        if (ContextScopeHandlerHelper.getInstance((IContext)context).contains("SOURCE_SCOPE", source, context)) {
            if (source instanceof ComponentPkg) {
                result.addAll((Collection<EObject>)((ComponentPkg)source).getOwnedParts());
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)((ComponentPkg)source).getOwnedParts(), context);
            }
            if (source instanceof EntityPkg) {
                EntityPkg sourceElement = (EntityPkg)source;
                result.addAll((Collection<EObject>)sourceElement.getOwnedEntityPkgs());
                result.addAll((Collection<EObject>)sourceElement.getOwnedEntities());
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedEntityPkgs(), context);
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedEntities(), context);
            } else if (source instanceof SystemComponentPkg) {
                SystemComponentPkg sourceElement = (SystemComponentPkg)source;
                result.addAll((Collection<EObject>)sourceElement.getOwnedSystemComponentPkgs());
                result.addAll((Collection<EObject>)sourceElement.getOwnedSystemComponents());
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedSystemComponentPkgs(), context);
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedSystemComponents(), context);
            } else if (source instanceof LogicalComponentPkg) {
                LogicalComponentPkg sourceElement = (LogicalComponentPkg)source;
                result.addAll((Collection<EObject>)sourceElement.getOwnedLogicalComponentPkgs());
                result.addAll((Collection<EObject>)sourceElement.getOwnedLogicalComponents());
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedLogicalComponentPkgs(), context);
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedLogicalComponents(), context);
            } else if (source instanceof PhysicalComponentPkg) {
                PhysicalComponentPkg sourceElement = (PhysicalComponentPkg)source;
                result.addAll((Collection<EObject>)sourceElement.getOwnedPhysicalComponentPkgs());
                result.addAll((Collection<EObject>)sourceElement.getOwnedPhysicalComponents());
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedPhysicalComponentPkgs(), context);
                ContextScopeHandlerHelper.getInstance((IContext)context).addAll("SOURCE_SCOPE", (Collection)sourceElement.getOwnedPhysicalComponents(), context);
            }
        }
    }

    protected EStructuralFeature getTargetContainementFeature(EObject element, EObject result, EObject container, IContext context) {
        EClass targetType = this.getTargetType(element, context);
        if (container instanceof EntityPkg) {
            if (OaPackage.Literals.ENTITY_PKG.isSuperTypeOf(targetType)) {
                return OaPackage.Literals.ENTITY_PKG__OWNED_ENTITY_PKGS;
            }
        } else if (!(container instanceof Entity)) {
            if (container instanceof SystemAnalysis) {
                if (CtxPackage.Literals.SYSTEM_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return CtxPackage.Literals.SYSTEM_ANALYSIS__OWNED_SYSTEM_COMPONENT_PKG;
                }
            } else if (container instanceof SystemComponentPkg) {
                if (CtxPackage.Literals.SYSTEM_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return CtxPackage.Literals.SYSTEM_COMPONENT_PKG__OWNED_SYSTEM_COMPONENT_PKGS;
                }
            } else if (container instanceof SystemComponent) {
                if (CtxPackage.Literals.SYSTEM_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return CtxPackage.Literals.SYSTEM_COMPONENT__OWNED_SYSTEM_COMPONENT_PKGS;
                }
            } else if (container instanceof LogicalArchitecture) {
                if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT_PKG;
                }
                if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return LaPackage.Literals.LOGICAL_ARCHITECTURE__OWNED_LOGICAL_COMPONENT_PKG;
                }
            } else if (container instanceof LogicalComponentPkg) {
                if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return LaPackage.Literals.LOGICAL_COMPONENT_PKG__OWNED_LOGICAL_COMPONENT_PKGS;
                }
            } else if (container instanceof LogicalComponent) {
                if (LaPackage.Literals.LOGICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return LaPackage.Literals.LOGICAL_COMPONENT__OWNED_LOGICAL_COMPONENT_PKGS;
                }
            } else if (container instanceof PhysicalArchitecture) {
                if (PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT_PKG;
                }
                if (PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return PaPackage.Literals.PHYSICAL_ARCHITECTURE__OWNED_PHYSICAL_COMPONENT_PKG;
                }
            } else if (container instanceof PhysicalComponentPkg) {
                if (PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                    return PaPackage.Literals.PHYSICAL_COMPONENT_PKG__OWNED_PHYSICAL_COMPONENT_PKGS;
                }
            } else if (container instanceof PhysicalComponent && PaPackage.Literals.PHYSICAL_COMPONENT_PKG.isSuperTypeOf(targetType)) {
                return PaPackage.Literals.PHYSICAL_COMPONENT__OWNED_PHYSICAL_COMPONENT_PKGS;
            }
        }
        return element.eContainingFeature();
    }

    @Override
    protected EObject transformDirectElement(EObject element, IContext context) {
        if (element.eContainer() instanceof BlockArchitecture) {
            ComponentPkg result;
            EObject root = TransformationHandlerHelper.getInstance((IContext)context).getLevelElement(element, context);
            BlockArchitecture target = (BlockArchitecture)TransformationHandlerHelper.getInstance((IContext)context).getBestTracedElement(root, context, CsPackage.Literals.BLOCK_ARCHITECTURE);
            if ((element instanceof EntityPkg || element instanceof SystemComponentPkg || element instanceof LogicalComponentPkg || element instanceof PhysicalComponentPkg) && (result = BlockArchitectureExt.getComponentPkg((BlockArchitecture)target, (boolean)true)) != null) {
                if (!BlockArchitectureExt.isDefaultNameComponentPkg((AbstractNamedElement)((AbstractNamedElement)element))) {
                    result.setName(((AbstractNamedElement)element).getName());
                }
                return result;
            }
        }
        return super.transformDirectElement(element, context);
    }
}

