/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.wizards.dialogs;

import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;

public class EIAllocationTreeViewerCellModifier
implements ICellModifier {
    public static final String RENAMED_NOTIFICATION = "renamed_notification";
    private boolean enabled = false;
    private Tree tree;

    public EIAllocationTreeViewerCellModifier(Tree tree) {
        this.tree = tree;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean canModify(Object element, String property) {
        return this.isEnabled();
    }

    public Object getValue(Object element, String property) {
        if (element instanceof AbstractNamedElement) {
            return ((AbstractNamedElement)element).getName();
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        Object data;
        if (element instanceof TreeItem && (data = ((TreeItem)element).getData()) instanceof AbstractNamedElement) {
            String newName = value.toString();
            this.rename((AbstractNamedElement)data, newName);
            this.sendNotification((TreeItem)element, data);
        }
    }

    public void rename(AbstractNamedElement element, String name) {
        if (!element.getName().equals(name)) {
            element.setName(name);
        }
    }

    public void sendNotification(TreeItem item, Object data) {
        Event event = new Event();
        event.item = item;
        event.data = data;
        event.text = RENAMED_NOTIFICATION;
        this.tree.notifyListeners(3, event);
    }
}

