/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.acceleo.internal.ide.ui.wizards.module.example;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.acceleo.internal.ide.ui.AcceleoUIMessages;
import org.eclipse.acceleo.internal.ide.ui.wizards.module.example.AbstractAcceleoInitializationStrategy;

public class Acceleo2InitializationStrategy
extends AbstractAcceleoInitializationStrategy {
    private final String[] mappings = new String[]{"<% metamodel * %>", "[comment metamodel $1/]", "<% import * %>", "[comment import $1/]", "file = \" <%*%> \"\\n", "file = \"$1\"", "file = \" <%*%> *\"\\n", "file = \"$1.concat($2)\"", "<% script name = \"$\" type = \"$\" %>\\n", "[template public $1 (v$2 : $2)]", "<% script type = \"$\" name = \"$\" %>\\n", "[template public $2 (v$1 : $1)]", "<% script type = \"$\" name = \"$\" file = \"*\" %>\\n", "[template public $2 (v$1 : $1)]\n\t[file ($3, false)]\n\t\t[$2Sub()/]\n\t[/file]\n\n[template private $2Sub (v$1 : $1)]", "<% script name = \"$\" type = \"$\" file = \"*\" %>\\n", "[template public $1 (v$2 : $2)]\n\t[file ($3, false)]\n\t\t[$1Sub()/]\n\t[/file]\n\n[template private $1Sub (v$2 : $2)]", "<% script type = \"$\" name = \"$\" file = \"*\" post = \"*\" %>\\n", "[template public $2 (v$1 : $1)]\n\t[file ($3, false)]\n\t\t[$2Sub().$4/]\n\t[/file]\n\n[template private $2Sub (v$1 : $1)]", "<% script name = \"$\" type = \"$\" file = \"*\" post = \"*\" %>\\n", "[template public $1 (v$2 : $2)]\n\t[file ($3, false)]\n\t\t[$1Sub().$4/]\n\t[/file]\n\n[template private $1Sub (v$2 : $2)]", "<% script name = \"$\" type = \"$\" * %>\\n", "[template public $1 (v$2 : $2)$3]", "<% script type = \"$\" name = \"$\" * %>\\n", "[template public $2 (v$1 : $1)$3]", "<% for (*.filter(\"$\")*) { %>\\n", "[for (v$2 : $2 | $1.oclAsType($2)$3)]", "<% for (*) { %>\\n", "[for (v : EObject | $1)]", "<% for * { %>\\n", "[for $1]", "<% if * { %>\\n", "[if $1]", "<% } else if * { %>\\n", "[else if $1]", "<% } else { %>\\n", "[else]", "<% startUserCode * %>\\n", "[protected ('TODO')]", "<% endUserCode * %>\\n", "[/protected]", "<%-- * --%>\\n", "[comment $1 /]", "<% * %>\\n", "[$1/]", "[*&&*]\\n", "[$1and $2]", "[*||*]\\n", "[$1or $2]", "[*!=*]\\n", "[$1<> $2]", "[*==*]\\n", "[$1== $2]", "[*\"*\"*\"*\"*]\\n", "[$1'$2'$3'$4'$5]", "[*\"*\"*]\\n", "[$1'$2'$3]", "[*.sep(\"*\")*]\\n", "[$1 separator('$2')$3]", "[*current(\"$\")*]\\n", "[$1v$2$3]", "[*current()*]\\n", "[$1v$2]", "[*toLowerCase()*]\\n", "[$1toLower()$2]", "[*toUpperCase()*]\\n", "[$1toUpper()$2]", "[*toU1Case()*]\\n", "[$1toUpperFirst()$2]", "[*toL1Case()*]\\n", "[$1toLowerFirst()$2]", "[*filter(\"$\")*]\\n", "[$1oclAsType($2)$3]"};

    @Override
    public String getDescription() {
        return AcceleoUIMessages.getString("MTContentStrategy.Description");
    }

    @Override
    public String getInitialFileNameFilter() {
        return "*.mt ";
    }

    @Override
    protected void modifyM2TContent(StringBuffer text, String moduleName) {
        int i = 0;
        while (i < this.mappings.length - 1) {
            String initialString = this.mappings[i];
            String replacingString = this.mappings[i + 1];
            this.replaceAll(text, initialString, replacingString);
            i += 2;
        }
        int offset = 0;
        while (offset > -1) {
            String tab;
            if ((offset = this.replaceNext(text, "[ } /]\\n", offset, "")) <= -1) continue;
            int beginLine = text.lastIndexOf("\n", offset) + 1;
            if (beginLine > -1 && offset < text.length() && beginLine < offset) {
                tab = text.substring(beginLine, offset);
                if (tab.trim().length() != 0) {
                    tab = "";
                }
            } else {
                tab = "";
            }
            int offsetIf = text.lastIndexOf(String.valueOf('\n') + tab + "[if", offset);
            int offsetFor = text.lastIndexOf(String.valueOf('\n') + tab + "[for", offset);
            if (offsetIf == -1 && offsetFor == -1) {
                offsetIf = text.lastIndexOf("[if", offset);
                offsetFor = text.lastIndexOf("[for", offset);
            }
            String newText = offsetFor > offsetIf ? "[/for]" : "[/if]";
            text.insert(offset, newText);
            offset += newText.length();
        }
        offset = 0;
        String templateBeginTag = "[template";
        if ((offset = this.replaceNext(text, "[template", offset, "[template")) > -1) {
            while (offset > -1) {
                if ((offset = this.replaceNext(text, "[template", offset, "")) <= -1) continue;
                if (offset > 0 && text.charAt(offset - 1) == '\n') {
                    text.deleteCharAt(--offset);
                }
                String newText = "[/template]\n\n[template";
                text.insert(offset, newText);
                offset += newText.length();
            }
            text.append("\n[/template]");
        }
        offset = 0;
        while (offset > -1) {
            offset = this.replaceNext(text, "[file (", offset, "[comment @main /]\n\t[file (");
        }
        this.modifyTemplateInvocation(text, "\\[[a-zA-Z_]+");
        this.modifyTemplateInvocation(text, "\\.a-zA-Z_]+");
        text.insert(0, "[module " + moduleName + "('" + this.getMetamodelURI(text) + "')/]\n\n");
    }

    private void modifyTemplateInvocation(StringBuffer text, String pattern) {
        Pattern p = Pattern.compile(String.valueOf(pattern) + "[ ]*/\\]");
        Matcher m = p.matcher(text);
        int offset = 0;
        while (offset > -1 && m.find(offset)) {
            int b = m.start();
            offset = m.end();
            String string = text.substring(b, offset).trim();
            Pattern pID = Pattern.compile("[a-zA-Z_]+");
            Matcher mID = pID.matcher(string);
            if (mID.find()) {
                string = string.substring(mID.start(), mID.end());
            }
            if (text.indexOf("public " + string + " (") <= -1 && text.indexOf("public " + string + "(") <= -1) continue;
            text.insert(offset - 2, "()");
        }
    }

    private String getMetamodelURI(StringBuffer text) {
        int iMetamodel = text.indexOf("metamodel");
        int iImport = text.indexOf("import");
        int b = iMetamodel > -1 && iMetamodel < iImport ? iMetamodel + "metamodel".length() : (iImport > -1 ? iImport + "import".length() : 0);
        int e = text.indexOf("\n", b);
        if (e == -1) {
            e = text.length();
        }
        return text.substring(b, e).trim();
    }

    @Override
    public boolean forceQuery() {
        return false;
    }

    @Override
    public boolean forceTemplate() {
        return true;
    }

    @Override
    public boolean forceDocumentation() {
        return true;
    }
}

