/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.capellacommon.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacommon.CapellacommonPackage;
import org.polarsys.capella.core.data.capellacommon.StateTransition;
import org.polarsys.capella.core.data.capellacommon.StateTransitionRealization;
import org.polarsys.capella.core.data.capellacore.Relationship;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.RelationshipHelper;

public class StateTransitionHelper {
    private static StateTransitionHelper instance;

    private StateTransitionHelper() {
    }

    public static StateTransitionHelper getInstance() {
        if (instance == null) {
            instance = new StateTransitionHelper();
        }
        return instance;
    }

    public Object doSwitch(StateTransition element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CapellacommonPackage.Literals.STATE_TRANSITION__REALIZED_STATE_TRANSITIONS)) {
            ret = this.getRealizedStateTransitions(element);
        } else if (feature.equals(CapellacommonPackage.Literals.STATE_TRANSITION__REALIZING_STATE_TRANSITIONS)) {
            ret = this.getRealizingStateTransitions(element);
        }
        if (ret == null) {
            ret = RelationshipHelper.getInstance().doSwitch((Relationship)element, feature);
        }
        return ret;
    }

    protected List<StateTransition> getRealizedStateTransitions(StateTransition element) {
        ArrayList<StateTransition> result = new ArrayList<StateTransition>();
        for (AbstractTrace trace : element.getOutgoingTraces()) {
            StateTransition transition;
            if (!(trace instanceof StateTransitionRealization) || (transition = ((StateTransitionRealization)trace).getRealizedStateTransition()) == null) continue;
            result.add(transition);
        }
        return result;
    }

    protected List<StateTransition> getRealizingStateTransitions(StateTransition element) {
        ArrayList<StateTransition> result = new ArrayList<StateTransition>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            StateTransition transition;
            if (!(trace instanceof StateTransitionRealization) || (transition = ((StateTransitionRealization)trace).getRealizingStateTransition()) == null) continue;
            result.add(transition);
        }
        return result;
    }
}

