/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfaceAllocation;
import org.polarsys.capella.core.data.cs.InterfaceAllocator;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.CapellaElementHelper;

public class InterfaceAllocatorHelper {
    private static InterfaceAllocatorHelper instance;

    private InterfaceAllocatorHelper() {
    }

    public static InterfaceAllocatorHelper getInstance() {
        if (instance == null) {
            instance = new InterfaceAllocatorHelper();
        }
        return instance;
    }

    public Object doSwitch(InterfaceAllocator element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CsPackage.Literals.INTERFACE_ALLOCATOR__ALLOCATED_INTERFACES)) {
            ret = this.getAllocatedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.INTERFACE_ALLOCATOR__PROVISIONED_INTERFACE_ALLOCATIONS)) {
            ret = this.getProvisionedInterfaceAllocations(element);
        }
        if (ret == null) {
            ret = CapellaElementHelper.getInstance().doSwitch((CapellaElement)element, feature);
        }
        return ret;
    }

    protected List<Interface> getAllocatedInterfaces(InterfaceAllocator element) {
        EList allocs = element.getProvisionedInterfaceAllocations();
        ArrayList<Interface> ret = new ArrayList<Interface>();
        for (InterfaceAllocation alloc : allocs) {
            Interface allocated = alloc.getAllocatedInterface();
            if (allocated == null) continue;
            ret.add(allocated);
        }
        return ret;
    }

    protected List<InterfaceAllocation> getProvisionedInterfaceAllocations(InterfaceAllocator element) {
        EList traces = element.getOutgoingTraces();
        ArrayList<InterfaceAllocation> ret = new ArrayList<InterfaceAllocation>();
        for (AbstractTrace trace : traces) {
            if (!(trace instanceof InterfaceAllocation)) continue;
            ret.add((InterfaceAllocation)trace);
        }
        return ret;
    }
}

