/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.cs.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.helpers.modellingcore.delegates.InformationsExchangerHelper;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.core.data.capellacore.Type;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.AbstractPathInvolvedElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.helpers.cs.delegates.AbstractPathInvolvedElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.DeployableElementHelper;
import org.polarsys.capella.core.data.helpers.cs.delegates.DeploymentTargetHelper;
import org.polarsys.capella.core.data.helpers.information.delegates.AbstractInstanceHelper;
import org.polarsys.capella.core.data.information.AbstractInstance;

public class PartHelper {
    private static PartHelper instance;

    private PartHelper() {
    }

    public static PartHelper getInstance() {
        if (instance == null) {
            instance = new PartHelper();
        }
        return instance;
    }

    public Object doSwitch(Part element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CsPackage.Literals.PART__PROVIDED_INTERFACES)) {
            ret = this.getProvidedInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.PART__REQUIRED_INTERFACES)) {
            ret = this.getRequiredInterfaces(element);
        } else if (feature.equals(CsPackage.Literals.PART__DEPLOYED_PARTS)) {
            ret = this.getDeployedParts(element);
        } else if (feature.equals(CsPackage.Literals.PART__DEPLOYING_PARTS)) {
            ret = this.getDeployingParts(element);
        }
        if (ret == null) {
            ret = AbstractInstanceHelper.getInstance().doSwitch((AbstractInstance)element, feature);
        }
        if (ret == null) {
            ret = InformationsExchangerHelper.getInstance().doSwitch((InformationsExchanger)element, feature);
        }
        if (ret == null) {
            ret = DeployableElementHelper.getInstance().doSwitch((DeployableElement)element, feature);
        }
        if (ret == null) {
            ret = AbstractPathInvolvedElementHelper.getInstance().doSwitch((AbstractPathInvolvedElement)element, feature);
        }
        if (ret == null) {
            ret = DeploymentTargetHelper.getInstance().doSwitch((DeploymentTarget)element, feature);
        }
        return ret;
    }

    protected List<Interface> getProvidedInterfaces(Part element) {
        List<Interface> ret = new ArrayList<Interface>();
        Type representedElement = element.getType();
        if (representedElement instanceof Component) {
            ret = ComponentHelper.getInstance().getProvidedInterfaces((Component)representedElement);
        }
        return ret;
    }

    protected List<Interface> getRequiredInterfaces(Part element) {
        List<Interface> ret = new ArrayList<Interface>();
        Type representedElement = element.getType();
        if (representedElement instanceof Component) {
            ret = ComponentHelper.getInstance().getRequiredInterfaces((Component)representedElement);
        }
        return ret;
    }

    protected List<Part> getDeployedParts(Part element) {
        ArrayList<Part> ret = new ArrayList<Part>();
        for (AbstractDeploymentLink deploymentLink : element.getDeploymentLinks()) {
            DeployableElement deployableElement = deploymentLink.getDeployedElement();
            if (!(deployableElement instanceof Part)) continue;
            ret.add((Part)deployableElement);
        }
        return ret;
    }

    protected List<Part> getDeployingParts(Part element) {
        ArrayList<Part> ret = new ArrayList<Part>();
        for (AbstractDeploymentLink deploymentLink : element.getDeployingLinks()) {
            DeploymentTarget deploymentTarget = deploymentLink.getLocation();
            if (!(deploymentTarget instanceof Part)) continue;
            ret.add((Part)deploymentTarget);
        }
        return ret;
    }
}

