/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacore.InvolverElement;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionInvolvement;
import org.polarsys.capella.core.data.ctx.SystemComponent;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.InvolverElementHelper;
import org.polarsys.capella.core.data.helpers.capellacore.delegates.NamedElementHelper;

public class MissionHelper {
    private static MissionHelper instance;

    private MissionHelper() {
    }

    public static MissionHelper getInstance() {
        if (instance == null) {
            instance = new MissionHelper();
        }
        return instance;
    }

    public Object doSwitch(Mission element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CtxPackage.Literals.MISSION__INVOLVED_SYSTEM_COMPONENTS)) {
            ret = this.getInvolvedSystemComponents(element);
        } else if (feature.equals(CtxPackage.Literals.MISSION__EXPLOITED_CAPABILITIES)) {
            ret = this.getExploitedCapabilities(element);
        }
        if (ret == null) {
            ret = NamedElementHelper.getInstance().doSwitch((NamedElement)element, feature);
        }
        if (ret == null) {
            ret = InvolverElementHelper.getInstance().doSwitch((InvolverElement)element, feature);
        }
        return ret;
    }

    protected List<SystemComponent> getInvolvedSystemComponents(Mission element) {
        ArrayList<SystemComponent> ret = new ArrayList<SystemComponent>();
        for (MissionInvolvement involvement : element.getOwnedMissionInvolvements()) {
            SystemComponent systemComponent = involvement.getSystemComponent();
            if (systemComponent == null) continue;
            ret.add(systemComponent);
        }
        return ret;
    }

    protected List<Capability> getExploitedCapabilities(Mission element) {
        EList exploitations = element.getOwnedCapabilityExploitations();
        ArrayList<Capability> ret = new ArrayList<Capability>();
        for (CapabilityExploitation exploitation : exploitations) {
            Capability capa = exploitation.getCapability();
            if (capa == null) continue;
            ret.add(capa);
        }
        return ret;
    }
}

