/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.cs.ArchitectureAllocation;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.CapabilityPkg;
import org.polarsys.capella.core.data.ctx.CtxPackage;
import org.polarsys.capella.core.data.ctx.OperationalAnalysisRealization;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.ctx.SystemFunctionPkg;
import org.polarsys.capella.core.data.fa.FunctionPkg;
import org.polarsys.capella.core.data.helpers.cs.delegates.BlockArchitectureHelper;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;

public class SystemAnalysisHelper {
    private static SystemAnalysisHelper instance;

    private SystemAnalysisHelper() {
    }

    public static SystemAnalysisHelper getInstance() {
        if (instance == null) {
            instance = new SystemAnalysisHelper();
        }
        return instance;
    }

    public Object doSwitch(SystemAnalysis element, EStructuralFeature feature) {
        Object ret = null;
        if (feature.equals(CtxPackage.Literals.SYSTEM_ANALYSIS__ALLOCATED_OPERATIONAL_ANALYSIS_REALIZATIONS)) {
            ret = this.getAllocatedOperationalAnalysisRealizations(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_ANALYSIS__CONTAINED_CAPABILITY_PKG)) {
            ret = this.getContainedCapabilityPkg(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_ANALYSIS__CONTAINED_SYSTEM_FUNCTION_PKG)) {
            ret = this.getContainedSystemFunctionPkg(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_ANALYSIS__ALLOCATED_OPERATIONAL_ANALYSES)) {
            ret = this.getAllocatedOperationalAnalyses(element);
        } else if (feature.equals(CtxPackage.Literals.SYSTEM_ANALYSIS__ALLOCATING_LOGICAL_ARCHITECTURES)) {
            ret = this.getAllocatingLogicalArchitectures(element);
        }
        if (ret == null) {
            ret = BlockArchitectureHelper.getInstance().doSwitch((BlockArchitecture)element, feature);
        }
        return ret;
    }

    protected List<OperationalAnalysisRealization> getAllocatedOperationalAnalysisRealizations(SystemAnalysis element) {
        ArrayList<OperationalAnalysisRealization> ret = new ArrayList<OperationalAnalysisRealization>();
        for (ArchitectureAllocation architectureAllocation : element.getProvisionedArchitectureAllocations()) {
            if (!(architectureAllocation instanceof OperationalAnalysisRealization)) continue;
            ret.add((OperationalAnalysisRealization)architectureAllocation);
        }
        return ret;
    }

    protected CapabilityPkg getContainedCapabilityPkg(SystemAnalysis element) {
        AbstractCapabilityPkg abstractCapabilityPkg = element.getOwnedAbstractCapabilityPkg();
        if (abstractCapabilityPkg instanceof CapabilityPkg) {
            return (CapabilityPkg)abstractCapabilityPkg;
        }
        return null;
    }

    protected SystemFunctionPkg getContainedSystemFunctionPkg(SystemAnalysis element) {
        FunctionPkg functionPkg = element.getOwnedFunctionPkg();
        if (functionPkg instanceof SystemFunctionPkg) {
            return (SystemFunctionPkg)functionPkg;
        }
        return null;
    }

    protected List<OperationalAnalysis> getAllocatedOperationalAnalyses(SystemAnalysis element) {
        ArrayList<OperationalAnalysis> ret = new ArrayList<OperationalAnalysis>();
        for (BlockArchitecture architecture : element.getAllocatedArchitectures()) {
            if (!(architecture instanceof OperationalAnalysis)) continue;
            ret.add((OperationalAnalysis)architecture);
        }
        return ret;
    }

    protected List<LogicalArchitecture> getAllocatingLogicalArchitectures(SystemAnalysis element) {
        ArrayList<LogicalArchitecture> ret = new ArrayList<LogicalArchitecture>();
        for (BlockArchitecture architecture : element.getAllocatingArchitectures()) {
            if (!(architecture instanceof LogicalArchitecture)) continue;
            ret.add((LogicalArchitecture)architecture);
        }
        return ret;
    }
}

