/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.validation.function;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.ctx.SystemFunction;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.oa.OperationalActivity;
import org.polarsys.capella.core.data.pa.PhysicalFunction;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class MDCHK_RootFunction_FunctionRealization
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof AbstractFunction) {
            AbstractFunction targetFunction;
            AbstractFunction function = (AbstractFunction)eObj;
            String currentFunctionName = NLS.bind((String)"Root \"{0}\"{1}", (Object)function.getName(), (Object)EObjectLabelProviderHelper.getMetaclassLabel((EObject)function, (boolean)true));
            String targetFunctionName = "";
            BlockArchitecture currentLevelArchitecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)function);
            BlockArchitecture previousArchitectures = BlockArchitectureExt.getPreviousBlockArchitecture((BlockArchitecture)currentLevelArchitecture);
            if (previousArchitectures != null && (targetFunction = BlockArchitectureExt.getRootFunction((BlockArchitecture)previousArchitectures)) != null) {
                targetFunctionName = NLS.bind((String)"Root \"{0}\"{1}", (Object)targetFunction.getName(), (Object)EObjectLabelProviderHelper.getMetaclassLabel((EObject)targetFunction, (boolean)true));
            }
            if (function.equals(BlockArchitectureExt.getRootFunction((BlockArchitecture)BlockArchitectureExt.getRootBlockArchitecture((EObject)function)))) {
                if (function instanceof SystemFunction) {
                    if (((SystemFunction)function).getRealizedOperationalActivities().isEmpty()) {
                        if (previousArchitectures == null) {
                            return ctx.createFailureStatus(new Object[]{currentFunctionName, "the Operational Analysis (Not Found), Please create Operational Analysis"});
                        }
                        targetFunctionName = targetFunctionName.isEmpty() ? "Root Operational Activity (Not Found)" : targetFunctionName;
                        return ctx.createFailureStatus(new Object[]{currentFunctionName, targetFunctionName});
                    }
                } else if (function instanceof LogicalFunction) {
                    if (((LogicalFunction)function).getRealizedSystemFunctions().isEmpty()) {
                        targetFunctionName = targetFunctionName.isEmpty() ? "Root System Function (Not Found)" : targetFunctionName;
                        return ctx.createFailureStatus(new Object[]{currentFunctionName, targetFunctionName});
                    }
                } else if (function instanceof PhysicalFunction && ((PhysicalFunction)function).getRealizedLogicalFunctions().isEmpty()) {
                    targetFunctionName = targetFunctionName.isEmpty() ? "Root Logical Function (Not Found)" : targetFunctionName;
                    return ctx.createFailureStatus(new Object[]{currentFunctionName, targetFunctionName});
                }
                for (AbstractTrace trace : function.getIncomingTraces()) {
                    TraceableElement sourceElement = trace.getSourceElement();
                    if (!(trace instanceof FunctionRealization) || function instanceof LogicalFunction && sourceElement instanceof PhysicalFunction || function instanceof SystemFunction && sourceElement instanceof LogicalFunction || function instanceof OperationalActivity && sourceElement instanceof SystemFunction) continue;
                    return ctx.createFailureStatus(new Object[]{currentFunctionName, "by accurate Root Function"});
                }
            }
        }
        return ctx.createSuccessStatus();
    }
}

