/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.interfaces.generateInterfaces;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.information.ExchangeItem;
import org.polarsys.capella.core.projection.interfaces.InterfaceGenerationPreferences;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.ExchangeItemUpdater;
import org.polarsys.capella.core.projection.interfaces.generateInterfaces.InterfaceInfo;

public class InterfaceGenerationResult {
    private final InterfaceGenerationPreferences prefs;
    private final Collection<InterfaceInfo> infos = new LinkedHashSet<InterfaceInfo>();

    public InterfaceGenerationResult(InterfaceGenerationPreferences prefs) {
        this.prefs = prefs;
    }

    public Collection<Interface> getUpdatedInterfaces() {
        ArrayList<Interface> result = new ArrayList<Interface>();
        for (InterfaceInfo i : this.infos) {
            Interface existing = i.getInterface(false);
            if (existing == null) continue;
            result.add(existing);
        }
        return result;
    }

    public Collection<ExchangeItem> getRemovedExchangeItems(Interface i) {
        for (InterfaceInfo inf : this.infos) {
            if (inf.getInterface(false) != i) continue;
            return ExchangeItemUpdater.getRemovedExchangeItems(i, inf.getExchangeItems(this.prefs));
        }
        throw new IllegalArgumentException("Interface is not part of this generation result");
    }

    public Collection<ExchangeItem> getAddedExchangeItems(Interface i) {
        for (InterfaceInfo inf : this.infos) {
            if (i != inf.getInterface(false)) continue;
            return ExchangeItemUpdater.getAddedExchangeItems(i, inf.getExchangeItems(this.prefs));
        }
        throw new IllegalArgumentException("Interface is not part of this generation result");
    }

    public Collection<InterfaceInfo> getInterfaceInfos() {
        return this.infos;
    }

    public InterfaceInfo getInterfaceInfo(Interface iface) {
        for (InterfaceInfo info : this.getInterfaceInfos()) {
            if (info.getInterface(false) != iface) continue;
            return info;
        }
        throw new IllegalArgumentException("Interface is not part of this generation result");
    }
}

