/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionStatus;
import org.polarsys.capella.common.libraries.AccessPolicy;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.core.libraries.model.CapellaLibraryExt;
import org.polarsys.capella.core.libraries.utils.AbstractModelComparator;

public class LibraryManagerModel {
    public IModel.Edit rootModel;
    private HashMap<IModel, Collection<IModel>> model2currentReferencedLibraries;
    private List<IModel> allReferencedLibraries;
    private Collection<IModel> initialReferencedLibrariesByRootModel;
    private Collection<IModel> initialAllReferencedLibrariesByRootModel;
    private Collection<Collection<IModel>> cycles;
    private List<IModel> allLibraries;
    private HashMap<IModel, Boolean> library2InitialActiveState;
    private HashMap<IModel, Boolean> library2CurrentActiveState;
    private HashMap<IModel, AccessPolicy> initialAccessPolicies;
    private HashMap<IModel, AccessPolicy> currentAccessPolicies;
    TransactionalEditingDomain domain;

    public LibraryManagerModel(TransactionalEditingDomain transactionalEditingDomain_p, IModel.Edit rootModel_) {
        this.rootModel = rootModel_;
        this.domain = transactionalEditingDomain_p;
        this.allLibraries = new ArrayList<IModel>();
        this.allLibraries.addAll(rootModel_.getAvailableReferences());
        for (IModel model : ILibraryManager.INSTANCE.getAllModels(transactionalEditingDomain_p)) {
            if (!rootModel_.canReference(model) || this.allLibraries.contains(model)) continue;
            this.allLibraries.add(model);
        }
        this.allLibraries.remove(this.rootModel);
        Collections.sort(this.allLibraries, new AbstractModelComparator());
        this.initialReferencedLibrariesByRootModel = this.rootModel.getAvailableReferences();
        this.model2currentReferencedLibraries = new HashMap();
        this.model2currentReferencedLibraries.put((IModel)this.rootModel, new ArrayList<IModel>(this.initialReferencedLibrariesByRootModel));
        for (IModel library : this.allLibraries) {
            this.model2currentReferencedLibraries.put(library, library.getAvailableReferences());
        }
        this.cycles = new ArrayList<Collection<IModel>>();
        this.allReferencedLibraries = new ArrayList<IModel>();
        this.computeAllReferencedLibraries();
        this.initialAllReferencedLibrariesByRootModel = new ArrayList<IModel>(this.allReferencedLibraries);
        this.library2InitialActiveState = new HashMap();
        for (IModel library : this.allReferencedLibraries) {
            this.library2InitialActiveState.put(library, new Boolean(this.rootModel.isActive(library)));
        }
        this.library2CurrentActiveState = new HashMap<IModel, Boolean>(this.library2InitialActiveState);
        this.initialAccessPolicies = new HashMap();
        for (IModel library : this.allReferencedLibraries) {
            this.initialAccessPolicies.put(library, rootModel_.getAccess(library));
        }
        this.currentAccessPolicies = new HashMap<IModel, AccessPolicy>(this.initialAccessPolicies);
    }

    public Boolean getInitialActiveState(IModel library_p) {
        return this.library2InitialActiveState.get(library_p);
    }

    public Boolean getActiveState(IModel library_p) {
        Boolean activeState = this.library2CurrentActiveState.get(library_p);
        if (activeState == null) {
            activeState = new Boolean(this.rootModel.isActive(library_p));
            this.library2CurrentActiveState.put(library_p, Boolean.TRUE);
        }
        return this.library2CurrentActiveState.get(library_p);
    }

    public Collection<IModel> getInitialReferencedLibrariesByRootModel() {
        return this.initialReferencedLibrariesByRootModel;
    }

    public Collection<IModel> getInitialAllReferencedLibrariesByRootModel() {
        return this.initialAllReferencedLibrariesByRootModel;
    }

    public List<IModel> getAllReferencedLibrariesByRootModel() {
        return this.allReferencedLibraries;
    }

    public Collection<IModel> getReferencedLibrariesByRootModel() {
        return this.model2currentReferencedLibraries.get(this.rootModel);
    }

    public Collection<Collection<IModel>> getCycles() {
        return this.cycles;
    }

    public List<IModel> getAllLibraries() {
        return this.allLibraries;
    }

    public IModel.Edit getRootModel() {
        return this.rootModel;
    }

    public AccessPolicy getAccessPolicy(IModel library_p) {
        AccessPolicy accessPolicy = this.currentAccessPolicies.get(library_p);
        if (accessPolicy == null) {
            accessPolicy = this.rootModel.getDefaultNewAccess(library_p);
            this.currentAccessPolicies.put(library_p, accessPolicy);
        }
        return accessPolicy;
    }

    public AccessPolicy getInitialAccessPolicy(IModel library_p) {
        return this.initialAccessPolicies.get(library_p);
    }

    public boolean isAccessPolicyModifiable(IModel library) {
        return this.getReferencedLibrariesByRootModel().contains(library);
    }

    public void setAccessPolicy(IModel library_p, AccessPolicy accessPolicy_p) {
        this.currentAccessPolicies.put(library_p, accessPolicy_p);
    }

    public void setActiveState(IModel library_p, boolean activeState) {
        this.library2CurrentActiveState.put(library_p, new Boolean(activeState));
    }

    public void addReferencedLibrary(IModel library_p) {
        this.model2currentReferencedLibraries.get(this.rootModel).add(library_p);
        if (!this.library2CurrentActiveState.containsKey(library_p)) {
            this.library2CurrentActiveState.put(library_p, this.getActiveState(library_p));
        }
        this.computeAllReferencedLibraries();
        if (!this.currentAccessPolicies.containsKey(library_p)) {
            this.currentAccessPolicies.put(library_p, this.rootModel.getDefaultNewAccess(library_p));
        }
    }

    public void removeReferencedLibrary(IModel library_p) {
        this.model2currentReferencedLibraries.get(this.rootModel).remove(library_p);
        this.computeAllReferencedLibraries();
        if (this.allReferencedLibraries.contains(library_p)) {
            this.currentAccessPolicies.put(library_p, this.rootModel.getDefaultNewAccess(library_p));
        }
    }

    private void computeAllReferencedLibraries() {
        this.cycles.clear();
        ArrayList<IModel> list = new ArrayList<IModel>();
        ArrayList<IModel> currentPath = new ArrayList<IModel>();
        this.computeAllReferencedLibraries_((IModel)this.rootModel, list, this.cycles, currentPath);
        list.remove(this.rootModel);
        this.allReferencedLibraries.clear();
        this.allReferencedLibraries.addAll(list);
        Collections.sort(this.allReferencedLibraries, new AbstractModelComparator());
    }

    private void computeAllReferencedLibraries_(IModel referencingModel, Collection<IModel> result, Collection<Collection<IModel>> cycles_, Collection<IModel> currentPath) {
        if (currentPath.contains(referencingModel)) {
            ArrayList<IModel> cycle = new ArrayList<IModel>(currentPath);
            cycle.add(referencingModel);
            cycles_.add(cycle);
        } else if (!result.contains(referencingModel)) {
            result.add(referencingModel);
            currentPath.add(referencingModel);
            if (this.model2currentReferencedLibraries.containsKey(referencingModel)) {
                for (IModel library : this.model2currentReferencedLibraries.get(referencingModel)) {
                    this.computeAllReferencedLibraries_(library, result, cycles_, currentPath);
                }
            }
            currentPath.remove(referencingModel);
        }
    }

    public Collection<IModel> getUnsavedModels() {
        ArrayList<IModel> models = new ArrayList<IModel>();
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            IModel sessionModel;
            if (session.getStatus() != SessionStatus.DIRTY || (sessionModel = ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain())) == null || this.rootModel.equals(sessionModel)) continue;
            models.add(sessionModel);
        }
        return models;
    }

    public Collection<IModel> getUnresolvableReferencedLibraries() {
        return this.allReferencedLibraries.stream().filter(lib -> CapellaLibraryExt.isUnresolvableIdentifier(lib.getIdentifier())).collect(Collectors.toList());
    }

    public boolean isUnsavedRootModel() {
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            IModel sessionModel;
            if (session.getStatus() != SessionStatus.DIRTY || (sessionModel = ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain())) == null || !this.rootModel.equals(sessionModel)) continue;
            return true;
        }
        return false;
    }
}

