/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.manager;

import org.eclipse.amalgam.explorer.activity.ui.api.editor.ActivityExplorerEditor;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.input.ActivityExplorerEditorInput;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.pages.helper.SessionHelper;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IActivityExplorerEditorSessionListener;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.INotifier;
import org.eclipse.amalgam.explorer.activity.ui.internal.util.ActivityExplorerLoggerService;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ActivityExplorerManager
implements INotifier {
    public static final ActivityExplorerManager INSTANCE = new ActivityExplorerManager();
    private static final ListenerList editorListeners = new ListenerList();
    private ActivityExplorerEditor editor;

    private ActivityExplorerManager() {
    }

    public ActivityExplorerEditor getEditor() {
        return this.editor;
    }

    public ISelection getCurrentSelection() {
        ISelection selection = null;
        Object sObject = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getService(ISelectionService.class);
        if (sObject != null && sObject instanceof ISelectionService) {
            ISelectionService service = (ISelectionService)sObject;
            selection = service.getSelection();
        }
        return selection;
    }

    public Session getSession() {
        ActivityExplorerEditorInput input;
        Session session = null;
        ActivityExplorerEditor editor = this.getEditor();
        if (editor != null && (input = editor.getEditorInput()) != null) {
            session = input.getSession();
        }
        return session;
    }

    @Deprecated
    public EObject getRootSemanticModel() {
        ActivityExplorerEditor editor = this.getEditor();
        if (editor != null) {
            ActivityExplorerEditorInput input = editor.getEditorInput();
            return input.getRootSemanticElement();
        }
        return null;
    }

    public void setEditor(ActivityExplorerEditor activityEditor) {
        this.editor = activityEditor;
    }

    public ActivityExplorerEditor getEditorFromSession(Session session) {
        ActivityExplorerEditor current = null;
        if (session != null) {
            URunnable runnable = new URunnable(session);
            Display.getDefault().syncExec((Runnable)runnable);
            current = runnable.getEditor();
        }
        return current;
    }

    public IEditorPart getCurrentEditor() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
    }

    public void openEditor(final Session session) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    IFile file;
                    ActivityExplorerEditorInput input;
                    IEditorPart part;
                    IWorkbenchPage activePage;
                    Session currentSession = session;
                    if (currentSession != null && currentSession.isOpen() && (activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage()) != null && (part = activePage.findEditor((IEditorInput)(input = new ActivityExplorerEditorInput(file = SessionHelper.getFirstAnalysisFile((DAnalysisSession)currentSession))))) == null) {
                        activePage.openEditor((IEditorInput)input, "org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor");
                    }
                }
                catch (Exception exception) {
                    StringBuilder loggerMessage = new StringBuilder(".run(..) _ ActivityExplorer not Found.");
                    loggerMessage.append(exception.getMessage());
                    ActivityExplorerLoggerService.getInstance().log(4, loggerMessage.toString(), null);
                }
            }
        };
        this.run(runnable);
    }

    @Override
    public void dispatchEvent(int notification, Session session) {
        Object[] listeners = editorListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            ((IActivityExplorerEditorSessionListener)listeners[i]).executeRequest(notification, session);
            ++i;
        }
    }

    @Override
    public void addActivityExplorerEditorListener(IActivityExplorerEditorSessionListener observer) {
        editorListeners.add((Object)observer);
    }

    @Override
    public void removeActivityExplorerEditorListener(IActivityExplorerEditorSessionListener observer) {
        editorListeners.remove((Object)observer);
    }

    protected void run(Runnable runnable) {
        if (runnable != null) {
            Display display = Display.getCurrent();
            if (display == null) {
                PlatformUI.getWorkbench().getDisplay().asyncExec(runnable);
            } else {
                runnable.run();
            }
        }
    }

    private class URunnable
    implements Runnable {
        ActivityExplorerEditor ed = null;
        Session session = null;

        public URunnable(Session session) {
            this.session = session;
        }

        @Override
        public void run() {
            try {
                IWorkbenchPage activePage;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window != null && (activePage = window.getActivePage()) != null) {
                    IEditorReference[] references;
                    IEditorReference[] iEditorReferenceArray = references = activePage.getEditorReferences();
                    int n = references.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ActivityExplorerEditorInput dinput;
                        Session current;
                        IEditorInput input;
                        IEditorReference ref = iEditorReferenceArray[n2];
                        if (ref.getId().equals("org.eclipse.amalgam.explorer.activity.ui.editor.activityExplorerEditor") && (input = ref.getEditorInput()) instanceof ActivityExplorerEditorInput && this.session.equals(current = (dinput = (ActivityExplorerEditorInput)input).getSession())) {
                            this.ed = (ActivityExplorerEditor)ref.getEditor(false);
                        }
                        ++n2;
                    }
                }
            }
            catch (Exception ex) {
                ActivityExplorerLoggerService.getInstance().log(4, ex.getMessage(), ex);
            }
        }

        public ActivityExplorerEditor getEditor() {
            return this.ed;
        }
    }
}

