/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.dialogs;

import java.util.Arrays;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.polarsys.capella.common.ui.toolkit.dialogs.AbstractMdeElementListSelectionDialog;
import org.polarsys.capella.common.ui.toolkit.widgets.Messages;

public class MdeElementListSelectionDialog
extends AbstractMdeElementListSelectionDialog {
    private Text _statusBar;
    private Object[] _elements;
    private ILabelProvider _statusRenderer = null;

    public MdeElementListSelectionDialog(Shell parent, ILabelProvider renderer, ILabelProvider statusRenderer) {
        super(parent, renderer);
        this._statusRenderer = statusRenderer;
    }

    public void setElements(Object[] elements) {
        this._elements = elements;
    }

    protected void computeResult() {
        this.setResult(Arrays.asList(this.getSelectedElements()));
    }

    @Override
    protected Label createMessageArea(Composite composite) {
        Label lbl = super.createMessageArea(composite);
        lbl.setText(Messages.getString("FilteredTree_FilterMessageTitle"));
        return lbl;
    }

    @Override
    protected Text createFilterText(Composite parent) {
        Label regExpLabel = new Label(parent, 0);
        GridData gdData = new GridData(768);
        regExpLabel.setText(Messages.getString("FilteredTree_FilterMessageText"));
        regExpLabel.setLayoutData((Object)gdData);
        return super.createFilterText(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite contents = (Composite)super.createDialogArea(parent);
        this.createMessageArea(contents);
        this.createFilterText(contents);
        this.createFilteredList(contents);
        this.setListElements(this._elements);
        this.setSelection(this.getInitialElementSelections().toArray());
        this._statusBar = new Text(contents, 2056);
        GridData data = new GridData();
        data.grabExcessVerticalSpace = false;
        data.grabExcessHorizontalSpace = true;
        data.horizontalAlignment = 4;
        data.verticalAlignment = 1;
        this._statusBar.setLayoutData((Object)data);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                MdeElementListSelectionDialog.this.updateStatusBar(event);
            }
        };
        this._filteredList.addSelectionListener((SelectionListener)listener);
        return contents;
    }

    protected void updateStatusBar(SelectionEvent event) {
        Object[] objectSet = this._filteredList.getSelection();
        if (objectSet.length > 0) {
            Object object = this._filteredList.getSelection()[0];
            String text = this._statusRenderer.getText(object);
            this._statusBar.setText(text);
        } else {
            this._statusBar.setText("");
        }
    }
}

