/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ui.toolkit.provider;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IViewerNotification;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.NotifyChangedToViewerRefresh;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.capella.common.platform.sirius.ted.SiriusSessionListener;
import org.polarsys.capella.common.ui.toolkit.provider.Messages;

public class GroupedAdapterFactoryContentProvider
extends AdapterFactoryContentProvider {
    protected ResourceSetListener listener = null;
    protected Collection<Notification> notifications = null;
    protected Collection<EObject> toRefresh = new HashSet<EObject>();

    public GroupedAdapterFactoryContentProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected ResourceSetListener getListener() {
        if (this.listener == null) {
            this.listener = new ResourceSetListenerImpl(){

                public boolean isPostcommitOnly() {
                    return true;
                }

                public void resourceSetChanged(ResourceSetChangeEvent event) {
                    super.resourceSetChanged(event);
                    if (GroupedAdapterFactoryContentProvider.this.refreshRequired(event)) {
                        GroupedAdapterFactoryContentProvider.this.runRefresh();
                    }
                }
            };
        }
        return this.listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean refreshRequired(ResourceSetChangeEvent event) {
        if (SiriusSessionListener.isOpeningSession((EditingDomain)event.getEditingDomain())) {
            return false;
        }
        if (SiriusSessionListener.isClosingSession((EditingDomain)event.getEditingDomain())) {
            return false;
        }
        boolean shouldRefresh = true;
        GroupedAdapterFactoryContentProvider groupedAdapterFactoryContentProvider = this;
        synchronized (groupedAdapterFactoryContentProvider) {
            shouldRefresh = this.refreshRequiredForNotifications(this.notifications) || this.refreshRequiredForEobject(this.toRefresh);
        }
        return shouldRefresh;
    }

    protected boolean refreshRequiredForNotifications(Collection<Notification> notifications) {
        return notifications != null && !notifications.isEmpty();
    }

    protected boolean refreshRequiredForEobject(Collection<EObject> toRefresh) {
        return toRefresh != null && !toRefresh.isEmpty();
    }

    public void notifyChanged2(Notification notification) {
        if (notification instanceof IViewerNotification) {
            this.viewerRefresh.addNotification((IViewerNotification)notification);
        } else {
            new NotifyChangedToViewerRefresh().refresh(this.viewer, notification.getNotifier(), notification.getEventType(), notification.getFeature(), notification.getOldValue(), notification.getNewValue(), notification.getPosition());
        }
    }

    public void runRefresh() {
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            UIJob job = new UIJob(this.viewer.getControl().getDisplay(), Messages.GroupedAdapterFactoryContentProvider_RefreshViewer){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    GroupedAdapterFactoryContentProvider.this.processRefresh();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processRefresh() {
        Collection<Notification> currentNotifications = null;
        Collection<EObject> currentRefresh = null;
        GroupedAdapterFactoryContentProvider groupedAdapterFactoryContentProvider = this;
        synchronized (groupedAdapterFactoryContentProvider) {
            currentNotifications = this.notifications;
            this.notifications = null;
            currentRefresh = this.toRefresh;
            this.toRefresh = null;
        }
        if (this.viewer != null && this.viewer.getControl() != null && !this.viewer.getControl().isDisposed()) {
            HashSet<ChangeNotification> duplicateNotifications = new HashSet<ChangeNotification>();
            if (currentNotifications != null && !currentNotifications.isEmpty()) {
                this.viewerRefresh = new AdapterFactoryContentProvider.ViewerRefresh(this.viewer);
                for (Notification notification : currentNotifications) {
                    ChangeNotification changeNotification;
                    Object notifier = notification.getNotifier();
                    if (notifier instanceof EObject && ((EObject)notifier).eResource() == null || duplicateNotifications.contains(changeNotification = new ChangeNotification(notification))) continue;
                    duplicateNotifications.add(changeNotification);
                    this.notifyChanged2(notification);
                }
                duplicateNotifications.clear();
                this.viewerRefresh.run();
                this.viewerRefresh = null;
                currentNotifications.clear();
            }
            if (currentRefresh != null && !currentRefresh.isEmpty()) {
                ((StructuredViewer)this.viewer).update(currentRefresh.toArray(), null);
                currentRefresh.clear();
            }
        }
    }

    public synchronized void addNotification(Notification notification) {
        this.addNotifications(Collections.singletonList(notification));
    }

    protected synchronized void addNotifications(List<Notification> notifications) {
        if (this.notifications == null) {
            this.notifications = new ArrayList<Notification>();
        }
        this.notifications.addAll(notifications);
    }

    public synchronized void addObject(EObject eObject) {
        if (this.toRefresh == null) {
            this.toRefresh = new HashSet<EObject>();
        }
        this.toRefresh.add(eObject);
    }

    public void notifyChanged(Notification notification) {
        this.addNotification(notification);
    }

    protected class ChangeNotification {
        private WeakReference<Object> notifierReference;
        private WeakReference<Object> featureReference;
        private WeakReference<Object> newValueReference;
        private WeakReference<Object> element;
        private int eventType;

        @Deprecated
        public ChangeNotification(Object notifier, Object feature, Object newValue, int eventType) {
            this.notifierReference = new WeakReference<Object>(notifier);
            this.featureReference = new WeakReference<Object>(feature);
            this.newValueReference = new WeakReference<Object>(newValue);
            this.eventType = eventType;
        }

        public ChangeNotification(Notification notification) {
            this(notification.getNotifier(), notification.getFeature(), notification.getNewValue(), notification.getEventType());
            if (notification instanceof ViewerNotification) {
                this.element = new WeakReference<Object>(((ViewerNotification)notification).getElement());
            }
        }

        public boolean equals(Object object) {
            boolean cr = super.equals(object);
            if (!cr && object instanceof ChangeNotification) {
                ChangeNotification notification = (ChangeNotification)object;
                cr = true;
                if (!(this.notifierReference.get() == null && notification.notifierReference.get() == null || this.notifierReference.get() != null && this.notifierReference.get().equals(notification.notifierReference.get()))) {
                    cr = false;
                } else if (!(this.featureReference.get() == null && notification.featureReference.get() == null || this.featureReference.get() != null && this.featureReference.get().equals(notification.featureReference.get()))) {
                    cr = false;
                } else if (!(this.newValueReference.get() == null && notification.newValueReference.get() == null || this.newValueReference.get() != null && this.newValueReference.get().equals(notification.newValueReference.get()))) {
                    cr = false;
                } else if (!(this.element == null || this.element.get() == null && notification.element.get() == null || this.element.get() != null && this.element.get().equals(notification.element.get()))) {
                    cr = false;
                }
                cr = cr ? this.eventType == notification.eventType : false;
            }
            return cr;
        }

        public int hashCode() {
            int result = 17;
            if (this.notifierReference.get() != null) {
                result = 37 * result + this.notifierReference.get().hashCode();
            }
            if (this.featureReference.get() != null) {
                result = 37 * result + this.featureReference.get().hashCode();
            }
            if (this.newValueReference.get() != null) {
                result = 37 * result + this.newValueReference.get().hashCode();
            }
            if (this.element != null && this.element.get() != null) {
                result = 37 * result + this.element.get().hashCode();
            }
            result = 37 * result + this.eventType;
            return result;
        }
    }
}

