/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.validation.constraint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyChecker;
import org.polarsys.capella.core.model.helpers.intermodelInconsistencyDetection.DependencyViolation;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class InterModelConsistencyLiveValidationRule
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        DependencyChecker linkChecker = null;
        if (ctx.getEventType() == EMFEventType.NULL) {
            return ctx.createSuccessStatus();
        }
        for (Notification notification : ctx.getAllEvents()) {
            if (!(notification.getNotifier() instanceof EObject)) continue;
            ctx.skipCurrentConstraintFor((EObject)notification.getNotifier());
            if (!CapellaResourceHelper.isSemanticElement((Object)notification.getNotifier())) continue;
            if (linkChecker == null) {
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)notification.getNotifier());
                if (!(domain instanceof SemanticEditingDomainFactory.SemanticEditingDomain)) continue;
                linkChecker = new DependencyChecker((SemanticEditingDomainFactory.SemanticEditingDomain)domain);
            }
            if (!(notification.getFeature() instanceof EReference)) continue;
            EReference ref = (EReference)notification.getFeature();
            Collection<Object> check = Collections.emptyList();
            if (notification.getEventType() == 1 || notification.getEventType() == 3) {
                EObject eObject = (EObject)notification.getNewValue();
                if (eObject != null) {
                    check = Collections.singleton(eObject);
                }
            } else if (notification.getEventType() == 5) {
                check = (Collection)notification.getNewValue();
            }
            if (ref.isContainment()) {
                for (EObject eObject : check) {
                    linkChecker.checkAllLinks(eObject);
                }
                continue;
            }
            for (EObject eObject : check) {
                linkChecker.checkLink((EObject)notification.getNotifier(), eObject, ref);
            }
        }
        if (linkChecker != null && !linkChecker.getDependencyViolations().isEmpty()) {
            ArrayList<IStatus> children = new ArrayList<IStatus>();
            for (DependencyViolation v : linkChecker.getDependencyViolations()) {
                Object[] args = new Object[]{v.getSource(), ILibraryManager.INSTANCE.getModel(v.getSource()).getIdentifier().getName(), v.getTarget(), ILibraryManager.INSTANCE.getModel(v.getTarget()).getIdentifier().getName(), v.getEReference()};
                children.add(ctx.createFailureStatus(args));
            }
            return ConstraintStatus.createMultiStatus((IValidationContext)ctx, children);
        }
        return ctx.createSuccessStatus();
    }
}

