/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.fa.ui.quickfix.resolver;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.fa.FunctionalChainInvolvementLink;
import org.polarsys.capella.core.data.fa.SequenceLink;
import org.polarsys.capella.core.validation.ui.ide.PluginActivator;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class RemoveSequenceLinksAssociationsResolver
extends AbstractCapellaMarkerResolution {
    private final String PROCESS_ICON = "icons/full/obj16/capella_process.gif";
    private final SequenceLink sequenceLink;
    private final String overridenLabel;
    private final String ruleId;
    private boolean multiMarkerQuickFix;

    public RemoveSequenceLinksAssociationsResolver(String label, SequenceLink sequenceLink, boolean multiMarkerQuickFix, String ruleId) {
        this.sequenceLink = sequenceLink;
        this.overridenLabel = label;
        this.multiMarkerQuickFix = multiMarkerQuickFix;
        this.ruleId = ruleId;
        super.setContributorId("org.polarsys.capella.core.ui.resources");
        super.setImgKey("icons/full/obj16/capella_process.gif");
    }

    public SequenceLink sequenceLink() {
        return this.sequenceLink;
    }

    public String getLabel() {
        return this.overridenLabel;
    }

    public boolean enabled(Collection<IMarker> markers) {
        return markers.size() > 1 || !this.multiMarkerQuickFix;
    }

    public void run(IMarker marker) {
        final List modelElements = this.getModelElements(marker);
        if (!modelElements.isEmpty()) {
            this.getExecutionManager(marker).execute((ICommand)new AbstractReadWriteCommand(){

                public void run() {
                    for (EObject obj : modelElements) {
                        if (!(obj instanceof FunctionalChainInvolvementLink)) continue;
                        RemoveSequenceLinksAssociationsResolver.this.sequenceLink.getLinks().remove((Object)((FunctionalChainInvolvementLink)obj));
                    }
                }
            });
        }
        this.deleteMarker(marker);
    }

    protected ExecutionManager getExecutionManager(IMarker marker) {
        return TransactionHelper.getExecutionManager((Collection)this.getModelElements(marker));
    }

    protected void deleteMarker(IMarker marker) {
        if (marker.exists()) {
            try {
                marker.delete();
            }
            catch (CoreException e) {
                PluginActivator.getDefault().log(4, e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    protected boolean canResolve(IMarker marker) {
        String markerRuleId = MarkerViewHelper.getRuleID((IMarker)marker, (boolean)true);
        List elements = MarkerViewHelper.getModelElementsFromMarker((IMarker)marker);
        return this.multiMarkerQuickFix && this.ruleId.equals(markerRuleId) && this.sequenceLink != null && elements.contains(this.sequenceLink);
    }

    public String getRuleId() {
        return this.ruleId;
    }
}

