/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.validation.ui.ide.quickfix;

import java.text.MessageFormat;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution2;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;

public class CapellaElementGoToResolver
implements IMarkerResolution2 {
    private static final String QUICK_FIX_LABEL_PATTERN = "Show {0} {1} ({2})";
    private final Image image;
    private final String label;
    private final EObject modelElement;

    public CapellaElementGoToResolver(String elementToGoToDescription, EObject modelElement) {
        String modelElementClassName = EObjectLabelProviderHelper.getMetaclassLabel((EObject)modelElement, (boolean)false);
        String modelElementName = EObjectLabelProviderHelper.getText((Object)modelElement);
        this.label = MessageFormat.format(QUICK_FIX_LABEL_PATTERN, elementToGoToDescription, modelElementName, modelElementClassName);
        this.image = ExtendedImageRegistry.getInstance().getImage(EObjectLabelProviderHelper.getImage((EObject)modelElement));
        this.modelElement = modelElement;
    }

    public CapellaElementGoToResolver(String elementToGoToDescription, EObject modelElement, String modelElementClassName) {
        String modelElementName = EObjectLabelProviderHelper.getText((Object)modelElement);
        this.label = MessageFormat.format(QUICK_FIX_LABEL_PATTERN, elementToGoToDescription, modelElementName, modelElementClassName);
        this.image = ExtendedImageRegistry.getInstance().getImage(EObjectLabelProviderHelper.getImage((EObject)modelElement));
        this.modelElement = modelElement;
    }

    public Image getImage() {
        return this.image;
    }

    public String getLabel() {
        return this.label;
    }

    public void run(IMarker marker) {
        LocateInCapellaExplorerAction selectElementAction = new LocateInCapellaExplorerAction();
        selectElementAction.selectionChanged(null, (ISelection)new StructuredSelection((Object)this.modelElement));
        selectElementAction.shouldIgnoreWorkbenchPartSite(true);
        selectElementAction.run(null);
    }

    public String getDescription() {
        return null;
    }

    public EObject getModelElement() {
        return this.modelElement;
    }
}

