/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef;

import java.util.Map;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.requests.GroupRequest;
import org.eclipse.gef.rulers.RulerProvider;

public class SnapToGuides
extends SnapToHelper {
    public static final String KEY_VERTICAL_GUIDE = "SnapToGuides.VerticalGuide";
    public static final String KEY_HORIZONTAL_GUIDE = "SnapToGuides.HorizontalGuide";
    public static final String KEY_VERTICAL_ANCHOR = "SnapToGuides.VerticalAttachment";
    public static final String KEY_HORIZONTAL_ANCHOR = "SnapToGuides.HorizontalAttachment";
    protected static final double THRESHOLD = 5.001;
    private double threshold = 5.001;
    protected GraphicalEditPart container;
    protected int[] verticalGuides;
    protected int[] horizontalGuides;

    public SnapToGuides(GraphicalEditPart container) {
        this.container = container;
    }

    protected double getThreshold() {
        return this.threshold;
    }

    protected void setThreshold(double newThreshold) {
        this.threshold = newThreshold;
    }

    protected double getCorrectionFor(int[] guides, double near, double far, Map extendedData, boolean isVertical) {
        double result;
        double total = near + (far -= 1.0);
        if ((int)(near - far) % 2 == 0) {
            total -= 1.0;
        }
        if ((result = this.getCorrectionFor(guides, total / 2.0, extendedData, isVertical, 0)) == this.getThreshold()) {
            result = this.getCorrectionFor(guides, near, extendedData, isVertical, -1);
        }
        if (result == this.getThreshold()) {
            result = this.getCorrectionFor(guides, far, extendedData, isVertical, 1);
        }
        return result;
    }

    protected double getCorrectionFor(int[] guides, double value, Map extendedData, boolean vert, int side) {
        double resultMag = this.getThreshold();
        double result = this.getThreshold();
        int i = 0;
        while (i < guides.length) {
            int offset = guides[i];
            double magnitude = Math.abs(value - (double)offset);
            if (magnitude < resultMag) {
                extendedData.put(vert ? KEY_VERTICAL_GUIDE : KEY_HORIZONTAL_GUIDE, guides[i]);
                extendedData.put(vert ? KEY_VERTICAL_ANCHOR : KEY_HORIZONTAL_ANCHOR, side);
                resultMag = magnitude;
                result = (double)offset - value;
            }
            ++i;
        }
        return result;
    }

    protected int[] getHorizontalGuides() {
        if (this.horizontalGuides == null) {
            RulerProvider rProvider = (RulerProvider)this.container.getViewer().getProperty("vertical ruler");
            this.horizontalGuides = rProvider != null ? rProvider.getGuidePositions() : new int[0];
        }
        return this.horizontalGuides;
    }

    protected int[] getVerticalGuides() {
        if (this.verticalGuides == null) {
            RulerProvider rProvider = (RulerProvider)this.container.getViewer().getProperty("horizontal ruler");
            this.verticalGuides = rProvider != null ? rProvider.getGuidePositions() : new int[0];
        }
        return this.verticalGuides;
    }

    @Override
    public int snapRectangle(Request request, int snapOrientation, PrecisionRectangle baseRect, PrecisionRectangle result) {
        double bottom;
        double topCorrection;
        double rightCorrection;
        double leftCorrection;
        boolean snapped;
        double ycorrect;
        double xcorrect;
        if (request instanceof GroupRequest && ((GroupRequest)request).getEditParts().size() > 1) {
            return snapOrientation;
        }
        baseRect = baseRect.getPreciseCopy();
        this.makeRelative(this.container.getContentPane(), (Translatable)baseRect);
        PrecisionRectangle correction = new PrecisionRectangle();
        this.makeRelative(this.container.getContentPane(), (Translatable)correction);
        if ((snapOrientation & 0x40) != 0 && (xcorrect = this.getCorrectionFor(this.getVerticalGuides(), baseRect.preciseX(), baseRect.preciseRight(), request.getExtendedData(), true)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFBF;
            correction.setPreciseX(correction.preciseX() + xcorrect);
        }
        if ((snapOrientation & 0x80) != 0 && (ycorrect = this.getCorrectionFor(this.getHorizontalGuides(), baseRect.preciseY(), baseRect.preciseBottom(), request.getExtendedData(), false)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFF7F;
            correction.setPreciseY(correction.preciseY() + ycorrect);
        }
        if (!(snapped = false) && (snapOrientation & 8) != 0 && (leftCorrection = this.getCorrectionFor(this.getVerticalGuides(), baseRect.preciseX(), request.getExtendedData(), true, -1)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFF7;
            correction.setPreciseWidth(correction.preciseWidth() - leftCorrection);
            correction.setPreciseX(correction.preciseX() + leftCorrection);
        }
        if (!snapped && (snapOrientation & 0x10) != 0 && (rightCorrection = this.getCorrectionFor(this.getVerticalGuides(), baseRect.preciseRight() - 1.0, request.getExtendedData(), true, 1)) != this.getThreshold()) {
            snapped = true;
            snapOrientation &= 0xFFFFFFEF;
            correction.setPreciseWidth(correction.preciseWidth() + rightCorrection);
        }
        if (!(snapped = false) && (snapOrientation & 1) != 0 && (topCorrection = this.getCorrectionFor(this.getHorizontalGuides(), baseRect.preciseY(), request.getExtendedData(), false, -1)) != this.getThreshold()) {
            snapOrientation &= 0xFFFFFFFE;
            correction.setPreciseHeight(correction.preciseHeight() - topCorrection);
            correction.setPreciseY(correction.preciseY() + topCorrection);
        }
        if (!snapped && (snapOrientation & 4) != 0 && (bottom = this.getCorrectionFor(this.getHorizontalGuides(), baseRect.preciseBottom() - 1.0, request.getExtendedData(), false, 1)) != this.getThreshold()) {
            snapped = true;
            snapOrientation &= 0xFFFFFFFB;
            correction.setPreciseHeight(correction.preciseHeight() + bottom);
        }
        this.makeAbsolute(this.container.getContentPane(), (Translatable)correction);
        result.setPreciseX(result.preciseX() + correction.preciseX());
        result.setPreciseY(result.preciseY() + correction.preciseY());
        result.setPreciseWidth(result.preciseWidth() + correction.preciseWidth());
        result.setPreciseHeight(result.preciseHeight() + correction.preciseHeight());
        return snapOrientation;
    }
}

