/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.view;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorSaveablesService;
import org.eclipse.ui.navigator.SaveablesProvider;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.platform.sirius.ted.SemanticEditingDomainFactory;
import org.polarsys.capella.core.commands.preferences.util.PreferencesHelper;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateFilteredElementsInCommonNavigatorAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigatorActionGroup;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigatorFilteredTree;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigatorPatternFilter;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ActiveSessionManager;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.CapellaNavigatorContentProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.ICommandStackSelectionProvider;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorEditingDomainDispatcher;
import org.polarsys.capella.core.platform.sirius.ui.navigator.viewer.NavigatorSessionManagerListener;
import org.polarsys.capella.core.preferences.Activator;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;
import org.polarsys.capella.core.ui.properties.CapellaTabbedPropertySheetPage;

public class CapellaCommonNavigator
extends CommonNavigator
implements IEditingDomainProvider,
ITabbedPropertySheetPageContributor,
ICommandStackSelectionProvider,
IPropertyChangeListener {
    public static final String ID = "capella.project.explorer";
    public static final int IS_SEARCH_IN_DESCRIPTION_ENABLED_PROPERTY = 65537;
    private boolean isSearchInDescriptionEnabled = false;
    public static final int IS_SEARCH_CASE_SENSITIVE_ENABLED_PROPERTY = 65538;
    private boolean isSearchCaseSensitiveEnabled = false;
    private static final String TAG_MEMENTO = "memento";
    private CapellaCommonNavigatorFilteredTree filteredTree;
    private NavigatorSessionManagerListener sessionManagerListener;
    private TabbedPropertySheetPage propertySheetPage;
    private IDialogSettings viewSettings = this.getDialogSettingsSection();
    private CapellaNavigatorContentProvider _contentProvider;

    public CapellaCommonNavigator() {
        NavigatorEditingDomainDispatcher.registerCommandStackSelectionProvider(this);
    }

    protected CommonViewer createCommonViewerObject(Composite aParent) {
        this.filteredTree = new CapellaCommonNavigatorFilteredTree(aParent, 770, new CapellaCommonNavigatorPatternFilter());
        this.filteredTree.setCaseSensitiveEnabled(this.isSearchCaseSensitiveEnabled);
        return (CommonViewer)this.filteredTree.getViewer();
    }

    protected void initListeners(TreeViewer viewer) {
        super.initListeners(viewer);
        CapellaNavigatorPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(event -> {
            String propertyName = event.getProperty();
            if ("GROUP_ENABLE".equals(propertyName) || "GROUP_TRIGGER".equals(propertyName) || "GROUP_SIZE".equals(propertyName)) {
                viewer.refresh();
            }
        });
    }

    public void createPartControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        FillLayout layout = new FillLayout(512);
        composite.setLayout((Layout)layout);
        super.createPartControl(composite);
        if (this.sessionManagerListener == null) {
            this.sessionManagerListener = new NavigatorSessionManagerListener(this);
        }
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        Activator.getDefault().addProjectsPropertyChangeListener((IPropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if ("preference.show.capella.project.concept".equals(property) || "preference.show.part.explicit".equals(property)) {
            for (Session session : SessionManager.INSTANCE.getSessions()) {
                if (!PreferencesHelper.isNonReferencesCapellaProject((Object)event.getSource(), (Project)SessionHelper.getCapellaProject((Session)session), (Session)session) || this.sessionManagerListener == null) continue;
                this.sessionManagerListener.notifyUpdatedSession(session);
            }
        }
    }

    public void enableContentNotifications() {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().enableContentNotifications();
    }

    public void disableContentNotifications() {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().disableContentNotifications();
    }

    public void enableContentNotifications(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().enableContentNotifications(editingDomain);
    }

    public void disableContentNotifications(SemanticEditingDomainFactory.SemanticEditingDomain editingDomain) {
        CapellaNavigatorContentProvider contentProvider = this.getContentProvider();
        if (contentProvider == null) {
            return;
        }
        ActiveSessionManager.getInstance().disableContentNotifications(editingDomain);
    }

    public void dispose() {
        if (this.sessionManagerListener != null) {
            this.sessionManagerListener.dispose();
            this.sessionManagerListener = null;
        }
        NavigatorEditingDomainDispatcher.unregisterCommandStackSelectionProvider(this);
        CapellaNavigatorPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        this.saveViewSettings();
        super.dispose();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IPropertySheetPage.class.equals(adapter)) {
            return (T)this.getPropertySheetPage();
        }
        return (T)super.getAdapter(adapter);
    }

    public boolean show(ShowInContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            LocateFilteredElementsInCommonNavigatorAction locateFilteredElementsInCommonNavigatorAction = new LocateFilteredElementsInCommonNavigatorAction(this.getSite().getId());
            locateFilteredElementsInCommonNavigatorAction.run(structuredSelection);
            this.selectReveal((ISelection)structuredSelection);
            ISelection actualSelection = this.getCommonViewer().getSelection();
            if (actualSelection == null || actualSelection.isEmpty()) {
                MessageDialog.openInformation((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)NLS.bind((String)Messages.LocateInCommonNavigator_SelectedElementNotVisible_Title, (Object)this.getPartName()), (String)NLS.bind((String)Messages.LocateInCommonNavigator_SelectedElementNotVisible_2, (Object)this.getPartName()));
            }
            return true;
        }
        return false;
    }

    public CapellaNavigatorContentProvider getContentProvider() {
        if (this._contentProvider != null && this._contentProvider.getSessionContentProvider() != null) {
            return this._contentProvider;
        }
        INavigatorContentService navigatorContentService = this.getCommonViewer().getNavigatorContentService();
        INavigatorContentExtension contentExt = navigatorContentService.getContentExtensionById("capella.project.explorer.content");
        ITreeContentProvider contentProvider = contentExt.getContentProvider();
        this._contentProvider = contentProvider instanceof CapellaNavigatorContentProvider ? (CapellaNavigatorContentProvider)contentProvider : null;
        return this._contentProvider;
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    private IDialogSettings getDialogSettingsSection() {
        String sectionName;
        IDialogSettings dialogSettings = CapellaNavigatorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(sectionName = this.getClass().getName());
        if (section == null) {
            section = dialogSettings.addNewSection(sectionName);
        }
        return section;
    }

    private IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new CapellaTabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    CapellaCommonNavigator.this.propertySheetPage = null;
                }

                public void init(IPageSite pageSite) {
                    super.init(pageSite);
                    pageSite.setSelectionProvider((ISelectionProvider)CapellaCommonNavigator.this.getCommonViewer());
                }
            };
        }
        return this.propertySheetPage;
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        memento = this.restoreViewSettings(memento);
        super.init(site, memento);
    }

    private IMemento restoreViewSettings(IMemento memento) {
        String persistedMemento;
        IMemento memento1 = memento;
        if (memento1 == null && (persistedMemento = this.viewSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento1 = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        return memento1;
    }

    private void saveViewSettings() {
        String rootName = this.getClass().getSimpleName();
        XMLMemento memento1 = XMLMemento.createWriteRoot((String)rootName);
        this.saveState((IMemento)memento1);
        StringWriter writer = new StringWriter();
        try {
            memento1.save((Writer)writer);
            this.viewSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Saveable[] getActiveSaveables() {
        INavigatorSaveablesService navigatorSaveablesService = this.getCommonViewer().getNavigatorContentService().getSaveablesService();
        return navigatorSaveablesService.getActiveSaveables();
    }

    public Saveable[] getSaveables() {
        SaveablesProvider saveablesProvider = (SaveablesProvider)this.getContentProvider().getAdapter(SaveablesProvider.class);
        return saveablesProvider.getSaveables();
    }

    @Override
    public void commandStackSelectionChanged(ISelection selection) {
        boolean enabled = true;
        if (selection instanceof IStructuredSelection) {
            TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)((IStructuredSelection)selection).getFirstElement());
            enabled = ActiveSessionManager.getInstance().isEnabledContentNotifications(domain);
        }
        if (enabled) {
            this.selectReveal(selection);
        }
    }

    public EditingDomain getEditingDomain() {
        ISelection selection = this.getCommonViewer().getSelection();
        if (selection instanceof IStructuredSelection) {
            ArrayList<EObject> selectedElements = new ArrayList<EObject>();
            for (Object element : (IStructuredSelection)selection) {
                if (!(element instanceof EObject)) continue;
                selectedElements.add((EObject)element);
            }
            return TransactionHelper.getEditingDomain(selectedElements);
        }
        return null;
    }

    protected ActionGroup createCommonActionGroup() {
        return new CapellaCommonNavigatorActionGroup(this, this.getCommonViewer(), this.getLinkHelperService());
    }

    public boolean isSearchInDescriptionEnabled() {
        return this.isSearchInDescriptionEnabled;
    }

    public boolean isSearchCaseSensitiveEnabled() {
        return this.isSearchCaseSensitiveEnabled;
    }

    public void setSearchInDescriptionEnabled(boolean isSearchInDescriptionEnabled) {
        this.isSearchInDescriptionEnabled = isSearchInDescriptionEnabled;
        this.filteredTree.setSearchInDescriptionEnabled(isSearchInDescriptionEnabled);
        this.firePropertyChange(65537);
    }

    public void setSearchCaseSensitiveEnabled(boolean isSearchCaseSensitiveEnabled) {
        this.isSearchCaseSensitiveEnabled = isSearchCaseSensitiveEnabled;
        this.filteredTree.setCaseSensitiveEnabled(isSearchCaseSensitiveEnabled);
        this.firePropertyChange(65538);
    }

    public void refreshViewer() {
        this.filteredTree.refresh();
    }
}

