/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.tiger.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.osgi.framework.Bundle;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.core.tiger.IResolver;
import org.polarsys.capella.core.tiger.impl.Transfo;

public class TransfoRuleLoader {
    protected static final String BUNDLE_ID = "bundle";
    protected static final String CONTEXT_NAME_ID = "context";
    protected static final String FINALIZER_CLASS_ID = "class";
    protected static final String FINALIZER_ID = "finalizer";
    protected static final String PACKAGE_NAME_ID = "rulepackage";
    protected static final String PLUGIN_ID = "org.polarsys.capella.core.tiger";
    protected static final String PRIORITY_HIGH = "high";
    protected static final String PRIORITY_ID = "priority";
    protected static final String PRIORITY_LOW = "low";
    protected static final String PRIORITY_NORMAL = "normal";
    protected static final String RESOLVER_ID = "resolver";
    protected static final String RESOLVER_ID_ID = "id";
    protected static final String RULE_ID = "rule";
    protected static final String RULE_NAME_ID = "rulename";
    protected static final String RULESET_ID = "ruleset";
    protected static final String SHARED_CONTEXT_ID = "sharedContext";
    protected static final String SHARED_RULES_ID = "sharedRuleset";
    protected static final String TRANSFO_LINK_ID = "transfolink";
    protected HashMap<String, IRuleSet> allRuleSets = new HashMap();
    protected HashMap<String, IContext> contexts = new HashMap();
    EClass defaultTrace;
    Transfo transfo;

    TransfoRuleLoader(Transfo transfo) {
        this.transfo = transfo;
        this.initContextsFromRegistry();
        this.loadResolvers();
    }

    public EClass getDefaultTrace() {
        return this.defaultTrace;
    }

    protected void initContext(String contextName) {
        if (contextName != null) {
            if (!this.contexts.containsKey(contextName)) {
                return;
            }
            IContext context = this.contexts.get(contextName);
            if (context.isInitialized) {
                return;
            }
            context.isInitialized = true;
            this.initElements(context.elements);
        } else {
            for (IContext context : this.contexts.values()) {
                if (context.isInitialized) continue;
                context.isInitialized = true;
                this.initElements(context.elements);
            }
        }
    }

    protected void initContextsFromRegistry() {
        IConfigurationElement[] elementsForPlugin;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = elementsForPlugin = extensionRegistry.getConfigurationElementsFor(PLUGIN_ID);
        int n = elementsForPlugin.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            String contextName = configurationElement.getAttribute(CONTEXT_NAME_ID);
            if (this.contexts.get(contextName) == null) {
                this.contexts.put(contextName, new IContext(contextName));
            }
            this.contexts.get((Object)contextName).elements.add(configurationElement);
            ++n2;
        }
    }

    protected void initElements(Collection<IConfigurationElement> elements) {
        HashSet<String> contextToLoads = new HashSet<String>();
        for (IConfigurationElement element : elements) {
            IConfigurationElement[] sharedContextList;
            IConfigurationElement[] sharedRuleList;
            String transfoLinkName;
            Bundle bundle = Platform.getBundle((String)element.getNamespaceIdentifier());
            String packageName = element.getAttribute(PACKAGE_NAME_ID);
            if (this.defaultTrace == null && (transfoLinkName = element.getAttribute(TRANSFO_LINK_ID)) != null && transfoLinkName.length() > 0) {
                this.defaultTrace = this.transfo.loadTrace(bundle, transfoLinkName);
            }
            IRuleSet set = this.retrieveRuleSet(bundle, packageName);
            IConfigurationElement[] ruleList = element.getChildren(RULE_ID);
            this.initRulesForRuleSet(set, ruleList);
            IConfigurationElement[] iConfigurationElementArray = sharedRuleList = element.getChildren(SHARED_RULES_ID);
            int n = sharedRuleList.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement ruleElement = iConfigurationElementArray[n2];
                String sharedPackageName = ruleElement.getAttribute(PACKAGE_NAME_ID);
                String sharedBundleId = ruleElement.getAttribute(BUNDLE_ID);
                IRuleSet sharedSet = this.retrieveRuleSet(Platform.getBundle((String)sharedBundleId), sharedPackageName);
                IConfigurationElement[] subRuleList = ruleElement.getChildren(RULE_ID);
                this.initRulesForRuleSet(sharedSet, subRuleList);
                ++n2;
            }
            IConfigurationElement[] iConfigurationElementArray2 = sharedContextList = element.getChildren(SHARED_CONTEXT_ID);
            int n3 = sharedContextList.length;
            n = 0;
            while (n < n3) {
                IConfigurationElement contextElement = iConfigurationElementArray2[n];
                String sharedContext = contextElement.getAttribute(CONTEXT_NAME_ID);
                if (sharedContext != null) {
                    contextToLoads.add(sharedContext);
                }
                ++n;
            }
            IConfigurationElement[] finalizers = element.getChildren(FINALIZER_ID);
            this.initFinalizersForRuleSet(set, finalizers);
        }
        for (String contextName : contextToLoads) {
            this.initContext(contextName);
        }
    }

    protected void initFinalizersForRuleSet(IRuleSet set, IConfigurationElement[] rules) {
        IConfigurationElement[] iConfigurationElementArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ruleElement = iConfigurationElementArray[n2];
            String ruleName = ruleElement.getAttribute(FINALIZER_CLASS_ID);
            if (ruleName != null && ruleName.length() > 0 && !set.finalizers.containsKey(ruleName)) {
                IFinalizer rule = new IFinalizer(ruleElement);
                set.finalizers.put(rule.name, rule);
            }
            ++n2;
        }
    }

    protected void initRulesForRuleSet(IRuleSet set, IConfigurationElement[] rules) {
        IConfigurationElement[] iConfigurationElementArray = rules;
        int n = rules.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ruleElement = iConfigurationElementArray[n2];
            String ruleName = ruleElement.getAttribute(RULE_NAME_ID);
            if (ruleName != null && ruleName.length() > 0 && !set.rules.containsKey(ruleName)) {
                IRule rule = new IRule(ruleElement);
                set.rules.put(rule.name, rule);
            }
            ++n2;
        }
    }

    public void loadContext(String contextName) {
        this.initContext(contextName);
        this.loadRuleSets();
    }

    private void loadResolvers() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IConfigurationElement[] elementsForPlugin = extensionRegistry.getConfigurationElementsFor(PLUGIN_ID);
        TreeSet<IConfigurationElement> elements = new TreeSet<IConfigurationElement>(new Comparator<IConfigurationElement>(){

            @Override
            public int compare(IConfigurationElement arg0, IConfigurationElement arg1) {
                int priority2;
                int priority1 = this.getPriority(arg0);
                if (priority1 == (priority2 = this.getPriority(arg1))) {
                    return arg0.getAttribute(TransfoRuleLoader.RESOLVER_ID_ID).compareTo(arg1.getAttribute(TransfoRuleLoader.RESOLVER_ID_ID));
                }
                return priority2 - priority1;
            }

            private int getPriority(IConfigurationElement configurationElement) {
                String value = configurationElement.getAttribute(TransfoRuleLoader.PRIORITY_ID);
                if (value == null) {
                    return 0;
                }
                if (TransfoRuleLoader.PRIORITY_LOW.equals(value)) {
                    return -1;
                }
                if (TransfoRuleLoader.PRIORITY_NORMAL.equals(value)) {
                    return 0;
                }
                if (TransfoRuleLoader.PRIORITY_HIGH.equals(value)) {
                    return 1;
                }
                return 0;
            }
        });
        IConfigurationElement[] iConfigurationElementArray = elementsForPlugin;
        int n = elementsForPlugin.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement configurationElement = iConfigurationElementArray[n2];
            if (RESOLVER_ID.equals(configurationElement.getName())) {
                elements.add(configurationElement);
            }
            ++n2;
        }
        for (IConfigurationElement configurationElement : elements) {
            IResolver resolver = (IResolver)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)FINALIZER_CLASS_ID);
            if (resolver == null) continue;
            this.transfo.addResolver(resolver);
        }
    }

    protected void loadRuleSets() {
        for (IRuleSet ruleSet : this.allRuleSets.values()) {
            for (IRule rule : ruleSet.rules.values()) {
                this.transfo.loadRule(ruleSet.bundle, ruleSet.packageName, rule.element);
            }
            for (IFinalizer finalizer : ruleSet.finalizers.values()) {
                this.transfo.loadFinalizer(ruleSet.bundle, finalizer.name);
            }
        }
    }

    protected IRuleSet retrieveRuleSet(Bundle bundle, String packageName) {
        if (!this.allRuleSets.containsKey(packageName)) {
            IRuleSet set = new IRuleSet(bundle, packageName);
            this.allRuleSets.put(packageName, set);
        }
        return this.allRuleSets.get(packageName);
    }

    protected class IContext {
        List<IConfigurationElement> elements;
        String id;
        boolean isInitialized;
        List<IRuleSet> ruleSets;

        IContext(String id) {
            this.id = id;
            this.isInitialized = false;
            this.ruleSets = new ArrayList<IRuleSet>();
            this.elements = new ArrayList<IConfigurationElement>();
        }
    }

    private class IFinalizer
    extends IRule {
        IFinalizer(IConfigurationElement name) {
            super(name);
            this.name = name.getAttribute(TransfoRuleLoader.FINALIZER_CLASS_ID);
        }
    }

    private class IRule {
        IConfigurationElement element;
        String name;

        IRule(IConfigurationElement element) {
            this.element = element;
            this.name = element.getAttribute(TransfoRuleLoader.RULE_NAME_ID);
        }
    }

    private class IRuleSet {
        Bundle bundle;
        HashMap<String, IFinalizer> finalizers = new HashMap();
        String packageName;
        HashMap<String, IRule> rules = new HashMap();

        IRuleSet(Bundle bundle, String packageName) {
            this.bundle = bundle;
            this.packageName = packageName;
        }
    }
}

