/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.composer.ui.wizards;

import java.util.Set;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.cadence.core.api.parameter.GenericParameter;
import org.polarsys.kitalpha.cadence.core.api.parameter.WorkflowActivityParameter;
import org.polarsys.kitalpha.composer.api.CodeManagerCadenceLaunchConfiguration;
import org.polarsys.kitalpha.composer.api.configuration.CodeManagerConfiguration;
import org.polarsys.kitalpha.composer.ui.wizards.GenericConfigurationWizardPage;

public class CadenceConfigurationWizardPage
extends GenericConfigurationWizardPage {
    private CodeManagerConfiguration configuration;
    private CodeManagerCadenceLaunchConfiguration cadenceConfig;

    protected CadenceConfigurationWizardPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    @Override
    public void setConfiguration(CodeManagerConfiguration configuration) {
        this.configuration = configuration;
        this.cadenceConfig = configuration.getCodeManagerCadenceLaunchConfiguration();
    }

    @Override
    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData compositeData = new GridData(1808);
        composite.setLayoutData((Object)compositeData);
        composite.setLayout((Layout)new GridLayout(1, true));
        CTabFolder tabFolder = new CTabFolder(composite, 2560);
        compositeData = new GridData(1808);
        tabFolder.setLayoutData((Object)compositeData);
        tabFolder.setSimple(false);
        this.createTab(tabFolder, "Before Strategy", this.cadenceConfig.getBeforeStrategyActivities());
        this.createTab(tabFolder, "Before Refinery", this.cadenceConfig.getBeforeRefineryActivities());
        this.createTab(tabFolder, "Before Generation", this.cadenceConfig.getBeforeGenerationActivities());
        this.createTab(tabFolder, "After Generation", this.cadenceConfig.getAfterGenerationActivities());
        this.setControl((Control)composite);
        composite.pack();
    }

    private void createTab(CTabFolder tabFolder, String title, WorkflowActivityParameter parameter) {
        CTabItem item = new CTabItem(tabFolder, 512, 0);
        item.setText(title);
        Set activities = parameter.getActivitiesID();
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)new GridLayout(1, true));
        GridData compositeData = new GridData(1808);
        compositeData.grabExcessVerticalSpace = true;
        composite.setLayoutData((Object)compositeData);
        for (String id : activities) {
            Group strategyParametersGroup = new Group(composite, 4);
            strategyParametersGroup.setLayout((Layout)new GridLayout(2, false));
            GridData groupData = new GridData(768);
            strategyParametersGroup.setLayoutData((Object)groupData);
            strategyParametersGroup.setText(id);
            this.createParametersComposite((Composite)strategyParametersGroup, parameter.getActivityParameters(id));
        }
        item.setControl((Control)composite);
    }

    private void createParametersComposite(Composite parent, ActivityParameters parameters) {
        for (GenericParameter parameter : parameters.getParameters()) {
            Label label = new Label(parent, 16384);
            label.setText(parameter.getName());
            label.setToolTipText(parameter.getDescription());
            Text text = new Text(parent, 2048);
            text.setLayoutData((Object)new GridData(768));
            text.setToolTipText(parameter.getDescription());
            text.setText(parameter.getValue().toString());
            text.addModifyListener((ModifyListener)new TextListener(text, (GenericParameter<Object>)parameter, parameter.getName()));
        }
    }

    private static class TextListener
    implements ModifyListener {
        private Text text;
        private GenericParameter<Object> parameter;
        private String key;

        public TextListener(Text text, GenericParameter<Object> parameter, String key) {
            this.text = text;
            this.parameter = parameter;
            this.key = key;
        }

        public void modifyText(ModifyEvent e) {
            this.parameter.setValue((Object)this.text.getText());
        }
    }
}

