/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.commands.preferences.util;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.polarsys.capella.core.commands.preferences.internalization.l10n.CustomPreferencesMessages;
import org.polarsys.capella.core.commands.preferences.preferences.ConfigurabilityPreferences;
import org.polarsys.capella.core.commands.preferences.service.AbstractItemDescriptor;
import org.polarsys.capella.core.commands.preferences.service.PreferencesItemsRegistry;
import org.polarsys.capella.core.commands.preferences.xml.IExtensionPointItemDescriptor;
import org.polarsys.capella.core.preferences.commands.exceptions.ItemExistsException;

public final class ExtensionPointItemDescriptor
extends AbstractItemDescriptor
implements IExtensionPointItemDescriptor {
    static final String ITEM_ID = CustomPreferencesMessages.rule_id;
    static final String ITEM_NAME = CustomPreferencesMessages.rule_name;
    private final IConfigurationElement config;
    private String name;
    private String id;
    private final String pluginId;
    private String description;
    private boolean isEnabledByDefault;

    public ExtensionPointItemDescriptor(IConfigurationElement config) throws ItemExistsException {
        block9: {
            this.isEnabledByDefault = true;
            this.config = config;
            this.name = config.getAttribute("name");
            this.description = config.getAttribute("description");
            this.pluginId = config.getDeclaringExtension().getNamespaceIdentifier();
            this.id = ExtensionPointItemDescriptor.normalizedId(this.pluginId, config.getAttribute("id"));
            this.id = config.getAttribute("id");
            try {
                Command command;
                ICommandService service;
                this.assertNotNull(this.id, this.pluginId);
                PreferencesItemsRegistry.getInstance().register(this);
                this.parseIsEnabledByDefault(config);
                this.setEnabled(ConfigurabilityPreferences.isInstanceScopePreferenceItemEnabled(this.id));
                if (this.name == null) {
                    service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    command = service.getCommand(this.id);
                    try {
                        this.name = command.getName();
                        this.description = command.getDescription();
                    }
                    catch (NotDefinedException e1) {
                        this.name = this.id;
                    }
                }
                if (this.description == null) {
                    service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
                    command = service.getCommand(this.id);
                    try {
                        this.description = command.getDescription();
                    }
                    catch (NotDefinedException notDefinedException) {}
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
                this.setError(e);
                if (this.id != null) break block9;
                this.id = "$error." + System.identityHashCode(this);
            }
        }
        if (this.name == null) {
            this.name = this.id;
        }
    }

    public static String normalizedId(String pluginId, String id) {
        assert (pluginId != null);
        assert (id != null);
        String result = id;
        if (!result.startsWith(pluginId)) {
            result = String.valueOf(pluginId) + '.' + result;
        }
        return result;
    }

    @Override
    public IConfigurationElement getConfig() {
        return this.config;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPluginId() {
        return this.pluginId;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    private void setDescription(String description) {
        this.description = description;
    }

    public String getLanguage() {
        return this.getConfig().getAttribute("lang");
    }

    @Override
    public boolean isEnabledByDefault() {
        return this.isEnabledByDefault;
    }

    private void parseIsEnabledByDefault(IConfigurationElement extConfig) {
        String attr = extConfig.getAttribute("enableByDefault");
        boolean result = true;
        if (attr != null && !attr.isEmpty()) {
            result = Boolean.parseBoolean(attr);
        }
        this.isEnabledByDefault = result;
        ConfigurabilityPreferences.setItemDisabledDefault(this.id, this.isEnabledByDefault);
    }
}

