/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.pa.validation.physicalComponent;

import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.EMFEventType;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.PhysicalComponentExt;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class PhysicalComponentContainedAndDeployed
extends AbstractValidationRule {
    private String validatorMessage = "{0} (PhysicalComponent) of Nature {1} should not be contained and deployed in the same parent {2} (PhysicalComponent)";

    public IStatus validate(IValidationContext ctx) {
        PhysicalComponent physicalComponent;
        EObject eObj = ctx.getTarget();
        EMFEventType eType = ctx.getEventType();
        if (eType == EMFEventType.NULL && eObj instanceof PhysicalComponent && !ComponentExt.isActor((Component)(physicalComponent = (PhysicalComponent)eObj)) && (PhysicalComponentExt.isNode((PhysicalComponent)physicalComponent) || PhysicalComponentExt.isBehaviour((PhysicalComponent)physicalComponent))) {
            EList deployingPhysicalComponents = physicalComponent.getDeployingPhysicalComponents();
            EObject parent = physicalComponent.eContainer();
            if (parent instanceof PhysicalComponent && deployingPhysicalComponents.contains((Object)parent)) {
                ArrayList<Object> resultLocus = new ArrayList<Object>();
                resultLocus.add(physicalComponent);
                resultLocus.add(parent);
                return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)eObj, resultLocus, (String)this.validatorMessage, (Object[])new Object[]{physicalComponent.getName(), physicalComponent.getNature(), EObjectLabelProviderHelper.getText((Object)parent)});
            }
        }
        return ctx.createSuccessStatus();
    }
}

