/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.structures.common.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.gef.EditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.ViewpointPackage;

public final class SiriusLayersUtil {
    private SiriusLayersUtil() {
    }

    public static View downGefToGmf(EditPart editPart_p) {
        Object modelElement;
        View result = null;
        if (editPart_p != null && (modelElement = editPart_p.getModel()) instanceof View) {
            result = (View)modelElement;
        }
        return result;
    }

    public static DSemanticDecorator downGmfToViewpoint(View view_p) {
        EObject representedElement;
        DSemanticDecorator result = null;
        if (view_p != null && (representedElement = view_p.getElement()) instanceof DSemanticDecorator) {
            result = (DSemanticDecorator)representedElement;
        }
        return result;
    }

    public static EObject downViewpointToSemantic(DSemanticDecorator decorator_p) {
        EObject result = null;
        if (decorator_p != null) {
            result = decorator_p.getTarget();
        }
        return result;
    }

    private static ECrossReferenceAdapter getGlobalReferencer(EObject elementInSession_p) {
        Session session;
        ECrossReferenceAdapter result = null;
        EObject semanticElement = SiriusLayersUtil.getSemanticElement(elementInSession_p);
        if (semanticElement != null && (session = SessionManager.INSTANCE.getSession(semanticElement)) != null) {
            result = session.getSemanticCrossReferencer();
        }
        return result;
    }

    private static List<EObject> getOpposites(EObject element_p, EReference ref_p) {
        FOrderedSet result = new FOrderedSet();
        ECrossReferenceAdapter referencer = SiriusLayersUtil.getGlobalReferencer(element_p);
        if (referencer != null) {
            Collection settings = referencer.getNonNavigableInverseReferences(element_p);
            for (EStructuralFeature.Setting setting : settings) {
                if (!ref_p.equals(setting.getEStructuralFeature())) continue;
                result.add(setting.getEObject());
            }
        }
        return Collections.unmodifiableList(result);
    }

    public static EObject getSemanticElement(Object element_p) {
        EObject result = SiriusLayersUtil.getViewpointElement(element_p);
        if (result instanceof DSemanticDecorator) {
            result = SiriusLayersUtil.downViewpointToSemantic((DSemanticDecorator)result);
        }
        return result;
    }

    public static EObject getViewpointElement(Object element_p) {
        EObject result = null;
        Object current = element_p;
        if (current instanceof EditPart) {
            current = SiriusLayersUtil.downGefToGmf((EditPart)current);
        }
        if (current instanceof View) {
            current = SiriusLayersUtil.downGmfToViewpoint((View)current);
        }
        if (current instanceof EObject) {
            result = (EObject)current;
        }
        return result;
    }

    public static List<DSemanticDecorator> upSemanticToViewpoint(EObject semanticElement_p) {
        return SiriusLayersUtil.getOpposites(semanticElement_p, ViewpointPackage.eINSTANCE.getDSemanticDecorator_Target());
    }

    public static List<View> upViewpointToGmf(DSemanticDecorator decorator_p) {
        return SiriusLayersUtil.getOpposites((EObject)decorator_p, NotationPackage.eINSTANCE.getView_Element());
    }
}

