/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.esf2esb.rules;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.osgi.util.NLS;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.interaction.Event;
import org.polarsys.capella.core.data.interaction.EventReceiptOperation;
import org.polarsys.capella.core.data.interaction.EventSentOperation;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.projection.common.ProjectionMessages;
import org.polarsys.capella.core.projection.scenario.Messages;
import org.polarsys.capella.core.projection.scenario.common.rules.Rule_InteractionElement;
import org.polarsys.capella.core.projection.scenario.esf2esb.ESF2ESBExt;
import org.polarsys.capella.core.projection.scenario.helpers.ScenarioExt;
import org.polarsys.capella.core.projection.scenario.helpers.UnwantedObjects;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.TransfoException;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;

public class Rule_Event
extends Rule_InteractionElement {
    protected boolean transformIsRequired(EObject element_p, ITransfo transfo_p) {
        return !UnwantedObjects.contains(element_p, transfo_p);
    }

    protected String reasonTransformFailed(EObject element_p, ITransfo transfo_p) {
        Event event = (Event)element_p;
        AbstractEventOperation operation = ScenarioExt.getOperation((EObject)event);
        if (operation != null) {
            if (operation instanceof ComponentExchange) {
                return ProjectionMessages.RelatedComponentExchangeConveyNoExchangeItem;
            }
            if (operation instanceof FunctionalExchange) {
                return ProjectionMessages.RelatedFunctionalExchangeConveyNoExchangeItem;
            }
        }
        return "";
    }

    public Rule_Event() {
        super(InteractionPackage.Literals.EVENT, InteractionPackage.Literals.EVENT);
    }

    public void firstAttach(EObject element_p, ITransfo transfo_p) throws TransfoException {
        int i = 0;
        if (element_p instanceof EventSentOperation) {
            EventSentOperation src = (EventSentOperation)element_p;
            for (EObject eTgt : Query.retrieveUnattachedTransformedElements((EObject)src, (ITransfo)transfo_p, (EClass)InteractionPackage.Literals.EVENT_SENT_OPERATION)) {
                EventSentOperation tgt = (EventSentOperation)eTgt;
                AbstractEventOperation operation = this.getRelatedConnection(src.getOperation(), (Event)element_p, i, transfo_p);
                if (operation != null) {
                    TigerRelationshipHelper.attachElementByRel((EObject)tgt, (EObject)operation, (EReference)InteractionPackage.Literals.EVENT_SENT_OPERATION__OPERATION);
                }
                ++i;
            }
        } else if (element_p instanceof EventReceiptOperation) {
            EventReceiptOperation src = (EventReceiptOperation)element_p;
            for (EObject eTgt : Query.retrieveUnattachedTransformedElements((EObject)src, (ITransfo)transfo_p, (EClass)InteractionPackage.Literals.EVENT_RECEIPT_OPERATION)) {
                EventReceiptOperation tgt = (EventReceiptOperation)eTgt;
                AbstractEventOperation operation = this.getRelatedConnection(src.getOperation(), (Event)element_p, i, transfo_p);
                if (operation != null) {
                    TigerRelationshipHelper.attachElementByRel((EObject)tgt, (EObject)operation, (EReference)InteractionPackage.Literals.EVENT_RECEIPT_OPERATION__OPERATION);
                }
                ++i;
            }
        }
        TigerRelationshipHelper.attachUnattachedIntoTransformedContainer((EObject)element_p, (EClass)this.getTargetType(), (EReference)InteractionPackage.Literals.SCENARIO__OWNED_EVENTS, (ITransfo)transfo_p);
    }

    private AbstractEventOperation getRelatedConnection(AbstractEventOperation operation_p, Event event_p, int n, ITransfo transfo_p) {
        SequenceMessage relatedMessage = ScenarioExt.getRelatedSequenceMessage(event_p);
        AbstractEventOperation operation = ESF2ESBExt.getTargetOperation(operation_p, relatedMessage, transfo_p);
        if (operation == null) {
            this.notifyMessage(NLS.bind((String)Messages.Rule_Event_FunctionalExchangeNotAllocated, (Object)EObjectLabelProviderHelper.getText((Object)operation_p), (Object)EObjectLabelProviderHelper.getText((Object)relatedMessage)), new Object[]{relatedMessage, operation_p}, "WARN", transfo_p);
        }
        return operation;
    }

    protected Object transformElement(EObject element_p, ITransfo transfo_p) {
        EPackage pkg = (EPackage)element_p.eClass().eContainer();
        return pkg.getEFactoryInstance().create(element_p.eClass());
    }
}

