/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.projection.scenario.topdown.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.information.AbstractEventOperation;
import org.polarsys.capella.core.data.information.AbstractInstance;
import org.polarsys.capella.core.data.interaction.AbstractCapability;
import org.polarsys.capella.core.data.interaction.InstanceRole;
import org.polarsys.capella.core.data.interaction.InteractionPackage;
import org.polarsys.capella.core.data.interaction.Scenario;
import org.polarsys.capella.core.data.interaction.ScenarioKind;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.utils.CapellaLayerCheckingExt;
import org.polarsys.capella.core.projection.common.TransitionHelper;
import org.polarsys.capella.core.projection.scenario.common.rules.Rule_InteractionElement;
import org.polarsys.capella.core.projection.scenario.helpers.ScenarioExt;
import org.polarsys.capella.core.projection.scenario.topdown.TopDownExt;
import org.polarsys.capella.core.tiger.ITransfo;
import org.polarsys.capella.core.tiger.helpers.Query;
import org.polarsys.capella.core.tiger.helpers.TigerRelationshipHelper;
import org.polarsys.capella.core.transition.system.topdown.commands.TransitionCommandHelper;
import org.polarsys.capella.core.transition.system.topdown.preferences.PreferenceHelper;

public class Rule_Scenario
extends Rule_InteractionElement {
    public Rule_Scenario() {
        super(InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO, InteractionPackage.Literals.SCENARIO_REALIZATION);
    }

    protected void runSubTransitionBeforeTransform(EObject element_p, ITransfo transfo_p) {
        ICommand command;
        NullProgressMonitor monitor;
        ArrayList<Object> elements;
        Scenario scenario = (Scenario)element_p;
        if (!Query.isElementTransformed((EObject)element_p.eContainer(), (ITransfo)this._transfo)) {
            AbstractCapability capa = (AbstractCapability)scenario.eContainer();
            Iterator command2 = TransitionCommandHelper.getInstance().getCapabilityTransitionCommand(Arrays.asList(capa), (IProgressMonitor)new NullProgressMonitor());
            command2.run();
        }
        for (InstanceRole role : scenario.getOwnedInstanceRoles()) {
            AbstractInstance instance = role.getRepresentedInstance();
            if (instance == null || !(instance.getAbstractType() instanceof Component)) continue;
            Component type = (Component)instance.getAbstractType();
            elements = new ArrayList<Object>();
            elements.add(instance);
            monitor = new NullProgressMonitor();
            command = null;
            if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)type)) {
                command = type.isActor() ? TransitionCommandHelper.getInstance().getActorTransitionCommand(elements, (IProgressMonitor)monitor) : TransitionCommandHelper.getInstance().getSystemTransitionCommand(elements, (IProgressMonitor)monitor);
            } else if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)type)) {
                command = type.isActor() ? TransitionCommandHelper.getInstance().getActorTransitionCommand(elements, (IProgressMonitor)monitor) : TransitionCommandHelper.getInstance().getLC2PCTransitionCommand(elements, (IProgressMonitor)monitor);
            } else if (CapellaLayerCheckingExt.isAOrInOperationalAnalysisLayer((CapellaElement)type)) {
                if (!Query.isElementTransformed((EObject)type, (ITransfo)transfo_p)) {
                    command = TransitionCommandHelper.getInstance().getOE2ActorTransitionCommand(elements, (IProgressMonitor)monitor);
                }
            } else if (CapellaLayerCheckingExt.isAOrInPhysicalLayer((CapellaElement)type) && !Query.isElementTransformed((EObject)type, (ITransfo)transfo_p) && PreferenceHelper.getInstance().transitionPC2CIWhileScenarioTransition()) {
                command = TransitionCommandHelper.getInstance().getPC2CITransitionCommand(elements, (IProgressMonitor)monitor);
            }
            if (command == null) continue;
            command.run();
        }
        ArrayList<AbstractEventOperation> transformedOperations = new ArrayList<AbstractEventOperation>();
        for (SequenceMessage message : scenario.getOwnedMessages()) {
            AbstractEventOperation operation = ScenarioExt.getOperation((EObject)message);
            if (operation == null || transformedOperations.contains(operation) || !(operation instanceof FunctionalExchange)) continue;
            elements = new ArrayList();
            elements.add(operation);
            monitor = new NullProgressMonitor();
            command = null;
            if (CapellaLayerCheckingExt.isInContextLayer((CapellaElement)operation)) {
                command = TransitionCommandHelper.getInstance().getFunctionalTransitionCommand(elements, (IProgressMonitor)monitor);
            } else if (CapellaLayerCheckingExt.isInLogicalLayer((CapellaElement)operation)) {
                command = TransitionCommandHelper.getInstance().getFunctionalTransitionCommand(elements, (IProgressMonitor)monitor);
            } else if (CapellaLayerCheckingExt.isInOperationalAnalysisLayer((CapellaElement)operation)) {
                command = TransitionCommandHelper.getInstance().getFunctionalTransitionCommand(elements, (IProgressMonitor)monitor);
            }
            if (command != null) {
                command.run();
            }
            transformedOperations.add(operation);
        }
    }

    protected Object transformElement(EObject element_p, ITransfo transfo_p) {
        Object result = super.transformElement(element_p, transfo_p);
        transfo_p.put((Object)"transfoTarget", result);
        TopDownExt.getTargetInstances((Scenario)element_p, transfo_p);
        return result;
    }

    public void update_(EObject element_p, ITransfo transfo_p) {
        super.update_(element_p, transfo_p);
        Scenario source = (Scenario)element_p;
        ScenarioKind targetKind = source.getKind();
        if (targetKind == ScenarioKind.INTERACTION) {
            boolean isFunctionalScenario = TransitionHelper.getService().isFunctionalScenario(source);
            targetKind = isFunctionalScenario ? ScenarioKind.FUNCTIONAL : ScenarioKind.DATA_FLOW;
        }
        for (Scenario target : Query.retrieveUnattachedTransformedElements((EObject)source, (ITransfo)transfo_p, (EClass)this.getTargetType())) {
            target.setKind(targetKind);
        }
    }

    public void firstAttach(EObject element_p, ITransfo transfo_p) {
        TigerRelationshipHelper.attachUnattachedIntoTransformedContainer((EObject)element_p, (EClass)this.getTargetType(), (EReference)InteractionPackage.Literals.ABSTRACT_CAPABILITY__OWNED_SCENARIOS, (ITransfo)transfo_p);
        TigerRelationshipHelper.attachTransformedRelatedElements((EObject)element_p, (EReference)InteractionPackage.Literals.SCENARIO__PRE_CONDITION, (ITransfo)transfo_p);
        TigerRelationshipHelper.attachTransformedRelatedElements((EObject)element_p, (EReference)InteractionPackage.Literals.SCENARIO__POST_CONDITION, (ITransfo)transfo_p);
    }

    @Override
    protected void doGoDeep(EObject element_p, List<EObject> result_p) {
        super.doGoDeep(element_p, result_p);
        Scenario s = (Scenario)element_p;
        result_p.add((EObject)s.getPreCondition());
        result_p.add((EObject)s.getPostCondition());
        result_p.addAll((Collection<EObject>)s.getOwnedMessages());
        result_p.addAll((Collection<EObject>)s.getOwnedEvents());
        result_p.addAll((Collection<EObject>)s.getOwnedInteractionFragments());
        result_p.addAll((Collection<EObject>)s.getOwnedTimeLapses());
        result_p.addAll((Collection<EObject>)s.getOwnedInstanceRoles());
    }

    protected void doAddContainer(EObject element_p, List<EObject> result_p) {
    }
}

