/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.interpreter.EvaluationException;
import org.eclipse.sirius.common.tools.api.interpreter.IInterpreter;
import org.eclipse.sirius.common.tools.api.util.StringUtil;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tools.api.interpreter.IInterpreterMessages;
import org.eclipse.sirius.tools.api.interpreter.InterpreterUtil;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.ui.toolkit.dialogs.Messages;
import org.polarsys.capella.core.sirius.analysis.commands.NewRepresentationCommand;
import org.polarsys.capella.core.sirius.ui.actions.AbstractNewRepresentationAction;

public class NewRepresentationAction
extends AbstractNewRepresentationAction {
    protected RepresentationDescription description;
    protected boolean forceDefaultName;
    private String descriptionLabel;

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, String message) {
        this(description, selectedEObject, session, false, true);
        this.message = message;
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session) {
        this(description, selectedEObject, session, false, true);
    }

    public NewRepresentationAction(RepresentationDescription description, EObject selectedEObject, Session session, boolean forceDefaultName, boolean openRepresentation) {
        super(description.getName());
        this.selectedEObject = selectedEObject;
        this.description = description;
        this.session = session;
        this.forceDefaultName = forceDefaultName;
        this.openRepresentation = openRepresentation;
        this.descriptionLabel = this.getDescriptionLabel(description);
        if (!StringUtil.isEmpty((String)this.descriptionLabel)) {
            this.setText(this.descriptionLabel);
        }
        ImageDescriptor imageDescriptor = this.getDescriptionImageDescriptor(description);
        this.setImageDescriptor(imageDescriptor);
    }

    protected String computeDefaultName(EObject eObject, RepresentationDescription repDescription) {
        IInterpreter interpreter = InterpreterUtil.getInterpreter((EObject)eObject);
        String newName = "New ";
        newName = !StringUtil.isEmpty((String)this.descriptionLabel) ? String.valueOf(newName) + this.descriptionLabel : String.valueOf(newName) + repDescription.getName();
        String titleExpression = repDescription.getTitleExpression();
        if (!StringUtil.isEmpty((String)titleExpression)) {
            try {
                newName = interpreter.evaluateString(eObject, titleExpression);
            }
            catch (EvaluationException e) {
                SiriusPlugin.getDefault().error(IInterpreterMessages.EVALUATION_ERROR_ON_MODEL_MODIFICATION, (Throwable)e);
            }
        }
        return newName;
    }

    public void run() {
        String defaultName = this.computeDefaultName(this.selectedEObject, this.description);
        if (!this.forceDefaultName) {
            String dialogTitle = "New " + this.descriptionLabel;
            String dialogMessage = this.message != null ? String.valueOf(this.message) + "\n" + "Name:" : "Name:";
            Shell activeShell = Display.getDefault().getActiveShell();
            IInputValidator validator = new IInputValidator(){

                public String isValid(String newText) {
                    if (newText.isBlank()) {
                        return Messages.blankName;
                    }
                    return null;
                }
            };
            InputDialog representationNameDialog = new InputDialog(activeShell, dialogTitle, dialogMessage, defaultName, validator);
            boolean bl = this.isCanceled = 1 == representationNameDialog.open();
            if (!this.isCanceled) {
                defaultName = representationNameDialog.getValue();
            } else {
                return;
            }
        }
        NewRepresentationCommand command = new NewRepresentationCommand(defaultName, this.selectedEObject, this.description, this.session);
        TransactionHelper.getExecutionManager((Session)this.session).execute((ICommand)command);
        if (command.getRepresentation() != null) {
            SessionManager.INSTANCE.notifyRepresentationCreated(this.session);
            if (this.openRepresentation) {
                DialectUIManager.INSTANCE.openEditor(this.session, command.getRepresentation(), (IProgressMonitor)new NullProgressMonitor());
            }
        }
    }
}

