/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.commandline;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.ui.PlatformUI;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.commandline.core.ui.AbstractWorkbenchCommandLine;
import org.polarsys.capella.core.commandline.core.ui.CloseWorkbenchJob;
import org.polarsys.capella.core.sirius.ui.handlers.RefreshDiagramJob;

public class RefreshAirdCommandLine
extends AbstractWorkbenchCommandLine {
    public RefreshAirdCommandLine() {
        super(true);
    }

    protected IStatus executeWithinWorkbench() {
        List airdFiles = this.getAirdFilesFromInput();
        final ArrayList<RefreshDiagramJob> jobs = new ArrayList<RefreshDiagramJob>();
        for (IFile file : airdFiles) {
            jobs.add(new RefreshDiagramJob(file));
        }
        int i = 0;
        while (i < jobs.size()) {
            final int index = i;
            Job currentJob = (Job)jobs.get(i);
            currentJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    Job eventJob = event.getJob();
                    if (eventJob instanceof RefreshDiagramJob) {
                        RefreshDiagramJob job = (RefreshDiagramJob)eventJob;
                        IFile file = job.getFile();
                        URI selectedUri = EcoreUtil2.getURI((IFile)file);
                        Session session = SessionManager.INSTANCE.getSession(selectedUri, (IProgressMonitor)new NullProgressMonitor());
                        session.save((IProgressMonitor)new NullProgressMonitor());
                        try {
                            session.close((IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        if (index < jobs.size() - 1) {
                            Job nextJob = (Job)jobs.get(index + 1);
                            nextJob.schedule();
                        } else if (PlatformUI.getTestableObject() == null || PlatformUI.getTestableObject().getTestHarness() == null) {
                            new CloseWorkbenchJob().schedule();
                        }
                    }
                }
            });
            ++i;
        }
        if (!jobs.isEmpty()) {
            Job entryJob = (Job)jobs.get(0);
            entryJob.schedule();
        }
        return Status.OK_STATUS;
    }
}

