/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.helper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.business.api.modelingproject.ModelingProject;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.ui.business.api.dialect.DialectEditor;
import org.eclipse.sirius.ui.business.api.session.IEditingSession;
import org.eclipse.sirius.ui.business.api.session.SessionEditorInput;
import org.eclipse.sirius.ui.business.api.session.SessionUIManager;
import org.eclipse.sirius.ui.business.api.viewpoint.ViewpointSelectionCallback;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IReusableEditor;
import org.polarsys.capella.common.ef.ExecutionManager;
import org.polarsys.capella.common.ef.command.AbstractNonDirtyingCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.EObjectExt;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;
import org.polarsys.capella.common.mdsofa.common.misc.Couple;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.utils.IFileRequestor;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.actions.CloseSessionAction;
import org.polarsys.capella.core.sirius.ui.session.ISessionAdvisor;

public class SessionHelper {
    public static void closeUiSessions(List<?> list) {
        for (IResource resource : list) {
            if (4 != resource.getType()) continue;
            for (Session session : SessionHelper.getExistingSessions((IProject)resource)) {
                SessionHelper.closeUiSession(session);
            }
        }
    }

    public static void closeUiSession(Session session) {
        CloseSessionAction closeSessionAction = new CloseSessionAction();
        closeSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection(Collections.singletonList(session).toArray()));
        closeSessionAction.run();
    }

    public static IFile getFirstAnalysisFile(DAnalysisSession session) {
        return EcoreUtil2.getFile((Resource)session.getSessionResource());
    }

    public static Project getCapellaProject(Session session) {
        Project result = null;
        for (Resource semanticResource : session.getSemanticResources()) {
            EObject object = (EObject)semanticResource.getContents().get(0);
            if (!(object instanceof Project)) continue;
            result = (Project)object;
            break;
        }
        return result;
    }

    public static Session getSession(IFile firstDiagramResourceFile) {
        Session result = null;
        Iterator allActiveSessions = SessionManager.INSTANCE.getSessions().iterator();
        while (allActiveSessions.hasNext() && result == null) {
            IFile sessionAnalysisFile;
            Session session = (Session)allActiveSessions.next();
            if (!(session instanceof DAnalysisSession) || !firstDiagramResourceFile.equals((Object)(sessionAnalysisFile = SessionHelper.getFirstAnalysisFile((DAnalysisSession)session)))) continue;
            result = session;
        }
        return result;
    }

    public static Session getSessionForDiagramFile(IFile diagramResourceFile) {
        Session result = null;
        Iterator allActiveSessions = SessionManager.INSTANCE.getSessions().iterator();
        while (allActiveSessions.hasNext() && result == null) {
            Session session = (Session)allActiveSessions.next();
            if (!(session instanceof DAnalysisSession) || !SessionHelper.isAnalysisFileInvolvedIn((DAnalysisSession)session, diagramResourceFile)) continue;
            result = session;
        }
        return result;
    }

    public static Session getSession(Resource airdResource) {
        Session result = null;
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            if (!SessionHelper.getAllAirdResources(session).contains(airdResource)) continue;
            result = session;
            break;
        }
        return result;
    }

    public static List<Couple<Session, IFile>> getSessionsFromSelection(IStructuredSelection selection) {
        ArrayList<Couple<Session, IFile>> sessions = new ArrayList<Couple<Session, IFile>>(0);
        for (Object selectedElement : selection) {
            Session session;
            if (!(selectedElement instanceof IFile) || (session = SessionHelper.getSessionForDiagramFile((IFile)selectedElement)) == null) continue;
            Couple couple = new Couple((Object)session, (Object)((IFile)selectedElement));
            sessions.add((Couple<Session, IFile>)couple);
        }
        return sessions;
    }

    @Deprecated
    public static Session getSessions(IProject project) {
        ModelingProject modelingProject;
        block3: {
            try {
                modelingProject = (ModelingProject)project.getNature("org.polarsys.capella.project.nature");
                if (modelingProject != null) break block3;
                return null;
            }
            catch (CoreException coreException) {
                return null;
            }
        }
        return modelingProject.getSession();
    }

    public static Collection<Session> getExistingSessions(IProject project) {
        ArrayList<Session> sessions = new ArrayList<Session>();
        List files = new IFileRequestor().search((IContainer)project, "aird", false);
        for (IFile mmFile : files) {
            Session session = SessionManager.INSTANCE.getExistingSession(EcoreUtil2.getURI((IFile)mmFile));
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    public static boolean isAnalysisFileInvolvedIn(DAnalysisSession session, IFile analysisFile) {
        boolean result = false;
        try {
            if (session == null || analysisFile == null) {
                return result;
            }
            Collection<Resource> allAnalysisResources = SessionHelper.getAllAirdResources((Session)session);
            for (Resource resource : allAnalysisResources) {
                if (!analysisFile.equals((Object)EcoreUtil2.getFile((Resource)resource))) continue;
                result = true;
                break;
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        return result;
    }

    public static Collection<Resource> getAllAirdResources(Session session) {
        HashSet<Resource> allAnalysisResources = new HashSet<Resource>(session.getReferencedSessionResources());
        allAnalysisResources.add(session.getSessionResource());
        return allAnalysisResources;
    }

    public static Collection<Resource> getSemanticResources(Session session) {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (Resource resource : session.getSemanticResources()) {
            if (!CapellaResourceHelper.isCapellaResource((Resource)resource)) continue;
            resources.add(resource);
        }
        return resources;
    }

    public static List<ISessionAdvisor> getSessionAdvisors() {
        ArrayList<ISessionAdvisor> sessionAdvisors = new ArrayList<ISessionAdvisor>(0);
        IConfigurationElement[] configurationElements = ExtensionPointHelper.getConfigurationElements((String)"org.polarsys.capella.core.sirius.ui", (String)"sessionAdvisor");
        if (configurationElements.length > 0) {
            ISessionAdvisor sessionAdvisor = (ISessionAdvisor)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElements[0], (String)"class");
            sessionAdvisors.add(sessionAdvisor);
        }
        return sessionAdvisors;
    }

    public static void activateViewpoints(final Session session, final Collection<Viewpoint> viewpoints) {
        ExecutionManager manager = TransactionHelper.getExecutionManager((Session)session);
        manager.execute((ICommand)new AbstractNonDirtyingCommand(){

            public void run() {
                ViewpointSelectionCallback viewpointSelectionCallback = new ViewpointSelectionCallback();
                for (Viewpoint viewpoint : viewpoints) {
                    viewpointSelectionCallback.selectViewpoint(viewpoint, session, (IProgressMonitor)new NullProgressMonitor());
                }
            }
        });
    }

    public static void reloadEditors(Session session, Set<DRepresentation> representations) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
        for (DRepresentation representation : representations) {
            DialectEditor editor = uiSession.getEditor(representation);
            if (!(editor instanceof IReusableEditor)) continue;
            IReusableEditor iReusableEditor = (IReusableEditor)editor;
            SessionEditorInput updatedEditorInput = new SessionEditorInput(EcoreUtil.getURI((EObject)representation), EObjectExt.getText((EObject)representation), session);
            iReusableEditor.setInput((IEditorInput)updatedEditorInput);
        }
    }

    public static void reloadEditors(Session session) {
        IEditingSession uiSession = SessionUIManager.INSTANCE.getUISession(session);
        for (DialectEditor dialectEditor : uiSession.getEditors()) {
            if (!(dialectEditor instanceof IReusableEditor)) continue;
            IReusableEditor iReusableEditor = (IReusableEditor)dialectEditor;
            DRepresentation representation = dialectEditor.getRepresentation();
            SessionEditorInput updatedEditorInput = new SessionEditorInput(EcoreUtil.getURI((EObject)representation), EObjectExt.getText((EObject)representation), session);
            iReusableEditor.setInput((IEditorInput)updatedEditorInput);
        }
    }
}

