/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.ui.quickfix.resolver;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.information.datavalue.EnumerationLiteral;
import org.polarsys.capella.core.data.information.datavalue.LiteralBooleanValue;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class DWFD57Resolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        EObject eObj = (EObject)this.getModelElements(marker).get(0);
        ICommand moveCommand = null;
        if (eObj instanceof EnumerationLiteral && eObj.eContainer() instanceof Enumeration) {
            moveCommand = this.getMoveEnumerationLiteralCmd((EnumerationLiteral)eObj);
        } else if (eObj instanceof LiteralBooleanValue && eObj.eContainer() instanceof BooleanType) {
            moveCommand = this.getMoveLiteralBooleanValueCmd((LiteralBooleanValue)eObj);
        }
        if (moveCommand != null) {
            TransactionHelper.getExecutionManager((EObject)eObj).execute(moveCommand);
            try {
                marker.delete();
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
    }

    private ICommand getMoveEnumerationLiteralCmd(final EnumerationLiteral enumerationLiteral) {
        return new AbstractReadWriteCommand(){

            public void run() {
                Enumeration enumeration = (Enumeration)enumerationLiteral.eContainer();
                enumeration.getOwnedDataValues().remove((Object)enumerationLiteral);
                enumeration.getOwnedLiterals().add((Object)enumerationLiteral);
            }
        };
    }

    private ICommand getMoveLiteralBooleanValueCmd(final LiteralBooleanValue literalBooleanValue) {
        return new AbstractReadWriteCommand(){

            public void run() {
                BooleanType booleanType = (BooleanType)literalBooleanValue.eContainer();
                booleanType.getOwnedDataValues().remove((Object)literalBooleanValue);
                booleanType.getOwnedLiterals().add((Object)literalBooleanValue);
            }
        };
    }
}

