/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.contextual.core.ui.view;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.MissingResourceException;
import org.eclipse.amalgam.explorer.contextual.core.category.ICategory;
import org.eclipse.amalgam.explorer.contextual.core.model.IExplorerContextualModel;
import org.eclipse.amalgam.explorer.contextual.core.provider.AbstractContentProvider;
import org.eclipse.amalgam.explorer.contextual.core.provider.AbstractContentProviderFactory;
import org.eclipse.amalgam.explorer.contextual.core.provider.AbstractLabelProviderFactory;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.CategoryWrapper;
import org.eclipse.amalgam.explorer.contextual.core.provider.wrapper.ExplorerElementWrapper;
import org.eclipse.amalgam.explorer.contextual.core.ui.ExplorerContextualActivator;
import org.eclipse.amalgam.explorer.contextual.core.ui.action.ExplorerActionFactory;
import org.eclipse.amalgam.explorer.contextual.core.ui.action.ExplorerHistory;
import org.eclipse.amalgam.explorer.contextual.core.ui.model.ExplorerContextualModel;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.DelegateSelectionProvider;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.ExplorerComposite;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.IExplorerContextualViewPart;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.Messages;
import org.eclipse.amalgam.explorer.contextual.core.ui.view.ext.SelectionHelpersManager;
import org.eclipse.amalgam.explorer.contextual.core.util.ViewerHelper;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.keys.IKeyLookup;
import org.eclipse.jface.bindings.keys.KeyLookupFactory;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.SessionManagerListener;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.internal.views.properties.tabbed.view.TabbedPropertyTitle;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public abstract class ExplorerContextualView
extends ViewPart
implements IExplorerContextualViewPart,
ITabbedPropertySheetPageContributor {
    public static final String EXPLORER_CONTEXTUAL_CONTRIBUTOR_ID = "org.eclipse.amalgam.explorer.contextual.core.ui.propertyContributorID";
    private static volatile boolean __isListeningToPageSelectionEvents;
    private static final String ALL_RELATED_DIAGRAMS = "All Related Diagrams";
    private static final String ALL_RELATED_TABLES = "All Related Tables";
    private static final String LISTENING_TO_WORKBENCH_PAGE_SELECTION_EVENTS = "listeningToWorkbenchPageSelectionEvents";
    private static final String REFERENCING_ELEMENTS_LABEL_TXT;
    private static final String TAG_MEMENTO = "memento";
    private ActionFactory.IWorkbenchAction _backAction;
    private TreeViewer _currentViewer;
    private DelegateSelectionProvider _delegateSelectionProvider;
    private ActionFactory.IWorkbenchAction _forwardAction;
    private ExplorerHistory _history;
    private boolean _isCtrlKeyPressed;
    private IMemento _memento;
    private SessionManagerListener _semCloseSessionListener;
    private TabbedPropertySheetPage _propertySheetPage;
    private TreeViewer _referencedViewer;
    private TreeViewer _referencingViewer;
    private ISelectionListener _selectionListener;
    private TabbedPropertyTitle _explorerContextualTitle;
    private boolean _shouldSetFocus;
    private IDoubleClickListener _viewerDoubleClickListener;
    private ISelectionChangedListener _viewerSelectionListener;
    private IDialogSettings _viewSettings = this.getDialogSettingsSection();
    protected IExplorerContextualModel model = new ExplorerContextualModel();
    protected IAction limitateTreeExpansionAction;

    static {
        REFERENCING_ELEMENTS_LABEL_TXT = Messages.ExplorerContextualView_Referencing_Elements_Title;
    }

    public String getExplorerContextualViewID() {
        return "";
    }

    @Override
    public IExplorerContextualModel getModel() {
        return this.model;
    }

    public void activateListeningToPageSelectionEvents() {
        this._selectionListener = this.getSelectionListener();
        if (this._selectionListener != null) {
            this.getSite().getPage().addSelectionListener(this._selectionListener);
        }
        __isListeningToPageSelectionEvents = true;
    }

    protected void addDndDragSupport(final TreeViewer viewer_p) {
        int operations = 3;
        Transfer[] transferTypes = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        viewer_p.addDragSupport(operations, transferTypes, new DragSourceListener(){

            public void dragSetData(DragSourceEvent event_p) {
                event_p.data = LocalSelectionTransfer.getTransfer().getSelection();
            }

            public void dragStart(DragSourceEvent event_p) {
                ISelection selection = viewer_p.getSelection();
                if (selection != null && selection instanceof IStructuredSelection && ExplorerContextualView.this.isSemanticElements(((IStructuredSelection)selection).toList())) {
                    LocalSelectionTransfer.getTransfer().setSelection(selection);
                    LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event_p.time & 0xFFFFFFFFL);
                    event_p.doit = true;
                } else {
                    event_p.doit = false;
                }
            }

            public void dragFinished(DragSourceEvent event_p) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
            }
        });
    }

    protected void addListeners(TreeViewer viewer_p) {
        if (this._viewerSelectionListener == null) {
            this._viewerSelectionListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ISelectionProvider provider = event.getSelectionProvider();
                    ExplorerContextualView.this.refreshPropertyPage(provider);
                }
            };
        }
        viewer_p.addSelectionChangedListener(this._viewerSelectionListener);
        viewer_p.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent event_p) {
                Object source = event_p.getSource();
                TreeViewer newSelectionProvider = null;
                if (source.equals(ExplorerContextualView.this._currentViewer.getControl())) {
                    newSelectionProvider = ExplorerContextualView.this._currentViewer;
                } else if (source.equals(ExplorerContextualView.this._referencedViewer.getControl())) {
                    newSelectionProvider = ExplorerContextualView.this._referencedViewer;
                } else if (source.equals(ExplorerContextualView.this._referencingViewer.getControl())) {
                    newSelectionProvider = ExplorerContextualView.this._referencingViewer;
                }
                if (newSelectionProvider != null) {
                    ExplorerContextualView.this.updateSelectionProvider((ISelectionProvider)newSelectionProvider);
                    ExplorerContextualView.this.refreshPropertyPage((ISelectionProvider)newSelectionProvider);
                    try {
                        String explorerContextualViewID = ExplorerContextualView.this.getExplorerContextualViewID();
                        if (explorerContextualViewID != null && explorerContextualViewID.length() > 0) {
                            ExplorerContextualView.this.getViewSite().getPage().showView(explorerContextualViewID, null, 3);
                        }
                    }
                    catch (PartInitException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        if (this._viewerDoubleClickListener == null) {
            this._viewerDoubleClickListener = new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event_p) {
                    try {
                        ExplorerContextualView.this.handleDoubleClick(event_p);
                    }
                    catch (RuntimeException exception_p) {
                        StringBuilder loggerMessage = new StringBuilder("ExplorerContextualView.addListeners(..) _ ");
                        loggerMessage.append(exception_p.getMessage());
                        ExplorerContextualView.this.logError(loggerMessage.toString(), exception_p);
                    }
                }
            };
        }
        viewer_p.addDoubleClickListener(this._viewerDoubleClickListener);
        viewer_p.getControl().addKeyListener((KeyListener)new KeyAdapter(){

            protected boolean isCtrlPressed(KeyEvent event_p) {
                IKeyLookup keyLookup = KeyLookupFactory.getSWTKeyLookup();
                return keyLookup.getCtrl() == event_p.stateMask || keyLookup.getCtrl() == event_p.keyCode;
            }

            public void keyPressed(KeyEvent keyEvent_p) {
                if (this.isCtrlPressed(keyEvent_p)) {
                    ExplorerContextualView.this._isCtrlKeyPressed = true;
                }
            }

            public void keyReleased(KeyEvent keyEvent_p) {
                if (this.isCtrlPressed(keyEvent_p)) {
                    ExplorerContextualView.this._isCtrlKeyPressed = false;
                }
            }
        });
    }

    @Override
    public void clean() {
        boolean restoreState = this._shouldSetFocus;
        this._shouldSetFocus = false;
        this.setInput(null);
        if (restoreState) {
            this._shouldSetFocus = true;
        }
    }

    public void createPartControl(Composite parent_p) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        parent_p.setLayout((Layout)layout);
        this._explorerContextualTitle = new TabbedPropertyTitle(parent_p, new TabbedPropertySheetWidgetFactory());
        GridData titleLayoutData = new GridData(768);
        titleLayoutData.grabExcessVerticalSpace = false;
        this._explorerContextualTitle.setLayoutData((Object)titleLayoutData);
        this._explorerContextualTitle.setTitle(Messages.ExplorerContextualView_Default_Name, null);
        SashForm mainSashForm = new SashForm(parent_p, 256);
        GridLayout gridLayoutTop = new GridLayout(3, true);
        mainSashForm.setLayout((Layout)gridLayoutTop);
        mainSashForm.setLayoutData((Object)new GridData(1808));
        AbstractContentProviderFactory.getInstance().setModel(this.model);
        ViewerSorter sorter = new ViewerSorter();
        AbstractContentProvider treeProvider = (AbstractContentProvider)AbstractContentProviderFactory.getInstance().getReferencingContentProvider();
        this._referencingViewer = this.createViewer((Composite)mainSashForm, REFERENCING_ELEMENTS_LABEL_TXT, 3, treeProvider.getExplorerId());
        this.initializeViewer(this._referencingViewer, (IContentProvider)treeProvider, (IBaseLabelProvider)AbstractLabelProviderFactory.getInstance().getReferencingLabelProvider(), sorter);
        treeProvider = (AbstractContentProvider)AbstractContentProviderFactory.getInstance().getCurrentContentProvider();
        this._currentViewer = this.createViewer((Composite)mainSashForm, Messages.ExplorerContextualView_Current_Element_Title, 3, treeProvider.getExplorerId());
        this.initializeViewer(this._currentViewer, (IContentProvider)treeProvider, (IBaseLabelProvider)AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider(), new ViewerSorter(){

            public int compare(Viewer viewer_p, Object e1_p, Object e2_p) {
                if (e1_p instanceof CategoryWrapper && this.isRepresentationCategory((CategoryWrapper)e1_p)) {
                    return 1;
                }
                if (e2_p instanceof CategoryWrapper && this.isRepresentationCategory((CategoryWrapper)e2_p)) {
                    return -1;
                }
                return super.compare(viewer_p, e1_p, e2_p);
            }

            private boolean isRepresentationCategory(CategoryWrapper categoryWrapper_p) {
                ICategory category = (ICategory)categoryWrapper_p.getElement();
                String categoryName = category.getName();
                return categoryName.equals(ExplorerContextualView.ALL_RELATED_DIAGRAMS) || categoryName.equals(ExplorerContextualView.ALL_RELATED_TABLES);
            }
        });
        treeProvider = (AbstractContentProvider)AbstractContentProviderFactory.getInstance().getReferencedContentProvider();
        this._referencedViewer = this.createViewer((Composite)mainSashForm, Messages.ExplorerContextualView_Referenced_Elements_Title, 3, treeProvider.getExplorerId());
        this.initializeViewer(this._referencedViewer, (IContentProvider)treeProvider, (IBaseLabelProvider)AbstractLabelProviderFactory.getInstance().getReferencedLabelProvider(), sorter);
        this.initializeContextMenus();
        this._delegateSelectionProvider = new DelegateSelectionProvider((ISelectionProvider)this._currentViewer);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this._delegateSelectionProvider);
        this.makeActions();
        this._semCloseSessionListener = new SemClosedSessionListener();
        SessionManager.INSTANCE.addSessionsListener(this._semCloseSessionListener);
    }

    protected TreeViewer createViewer(Composite parent_p, String label_p, int autoExpandLevel_p, String explorerID) {
        ExplorerComposite composite = new ExplorerComposite(parent_p, this.model, 770, label_p, explorerID);
        TreeViewer treeViewer = composite.getTreeviewer();
        treeViewer.setUseHashlookup(true);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)treeViewer, (int)1);
        this.addListeners(treeViewer);
        this.addDndDragSupport(treeViewer);
        return treeViewer;
    }

    public void deactivateListeningToPageSelectionEvents() {
        if (this._selectionListener != null) {
            this.getSite().getPage().removeSelectionListener(this._selectionListener);
            this._selectionListener = null;
        }
        __isListeningToPageSelectionEvents = false;
    }

    public void dispose() {
        this.saveViewSettings();
        this.deactivateListeningToPageSelectionEvents();
        if (this._propertySheetPage != null) {
            this._propertySheetPage.dispose();
            this._propertySheetPage = null;
        }
        if (this._referencingViewer != null) {
            this.removeListeners(this._referencingViewer);
            this._referencingViewer = null;
        }
        if (this._referencedViewer != null) {
            this.removeListeners(this._referencedViewer);
            this._referencedViewer = null;
        }
        if (this._currentViewer != null) {
            this.removeListeners(this._currentViewer);
        }
        this._viewerSelectionListener = null;
        this._viewerDoubleClickListener = null;
        if (this._history != null) {
            this._history.dispose();
            this._history = null;
        }
        SessionManager.INSTANCE.removeSessionsListener(this._semCloseSessionListener);
        this._semCloseSessionListener = null;
        this.model = null;
        super.dispose();
    }

    public Object getAdapter(Class adapter_p) {
        if (IPropertySheetPage.class.equals((Object)adapter_p)) {
            return this.getPropertySheetPage();
        }
        if (Control.class.equals((Object)adapter_p)) {
            return this.getParentControl();
        }
        return super.getAdapter(adapter_p);
    }

    @Override
    public TreeViewer getCurrentViewer() {
        return this._currentViewer;
    }

    private IDialogSettings getDialogSettingsSection() {
        String sectionName;
        IDialogSettings dialogSettings = ExplorerContextualActivator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(sectionName = this.getClass().getName());
        if (section == null) {
            section = dialogSettings.addNewSection(sectionName);
        }
        return section;
    }

    @Override
    public ExplorerHistory getHistory() {
        if (this._history == null) {
            this._history = new ExplorerHistory();
        }
        return this._history;
    }

    protected Control getParentControl() {
        if (this._explorerContextualTitle != null) {
            return this._explorerContextualTitle.getParent();
        }
        return null;
    }

    protected TabbedPropertySheetPage getPropertySheetPage() {
        if (this._propertySheetPage == null) {
            this._propertySheetPage = new TabbedPropertySheetPage(this){

                public void labelProviderChanged(LabelProviderChangedEvent event_p) {
                    if (!this.getControl().isDisposed()) {
                        super.labelProviderChanged(event_p);
                    }
                }

                public void refresh() {
                    if (this.getCurrentTab() != null) {
                        super.refresh();
                    }
                }

                public void dispose() {
                    super.dispose();
                    ExplorerContextualView.this._propertySheetPage = null;
                }

                public void init(IPageSite pageSite_p) {
                    super.init(pageSite_p);
                    pageSite_p.setSelectionProvider(ExplorerContextualView.this.getViewSite().getSelectionProvider());
                }
            };
        }
        return this._propertySheetPage;
    }

    @Override
    public TreeViewer getReferencedViewer() {
        return this._referencedViewer;
    }

    @Override
    public TreeViewer getReferencingViewer() {
        return this._referencingViewer;
    }

    @Override
    public EObject getRootElement() {
        return ((AbstractContentProvider)this._currentViewer.getContentProvider()).getRootElement();
    }

    protected ISelectionListener getSelectionListener() {
        return new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part_p, ISelection selection_p) {
                Object newInput = ExplorerContextualView.this.handleWorkbenchPageSelectionEvent(part_p, selection_p);
                String viewIDToIgnore = ExplorerContextualView.this.ingoredViewAsSelectionProvider();
                if (newInput != null && newInput instanceof EObject) {
                    if (viewIDToIgnore != null && viewIDToIgnore.equals(part_p.getSite().getId())) {
                        return;
                    }
                    try {
                        ExplorerContextualView.this._shouldSetFocus = false;
                        ExplorerContextualView.this.setInput(newInput);
                    }
                    finally {
                        ExplorerContextualView.this._shouldSetFocus = true;
                    }
                } else if (viewIDToIgnore != null && part_p != ExplorerContextualView.this && !viewIDToIgnore.equals(part_p.getSite().getId())) {
                    ExplorerContextualView.this.clean();
                }
            }
        };
    }

    protected void handleDoubleClick(DoubleClickEvent event_p) {
        ITreeSelection selection = (ITreeSelection)event_p.getSelection();
        if (!selection.isEmpty()) {
            Object doubleClickedElement = selection.getFirstElement();
            if (doubleClickedElement instanceof ExplorerElementWrapper) {
                doubleClickedElement = ((ExplorerElementWrapper)doubleClickedElement).getElement();
            }
            if (doubleClickedElement instanceof EObject) {
                if (this._isCtrlKeyPressed) {
                    this.handleDoubleClickWithCtrlKeyPressed(event_p, doubleClickedElement);
                } else {
                    this.handleDoubleClickWithCtrlKeyNotPressed(event_p, doubleClickedElement);
                }
            }
        }
    }

    public void init(IViewSite site_p, IMemento memento_p) throws PartInitException {
        boolean isListeningOnStartup;
        this._memento = this.restoreViewSettings(memento_p);
        super.init(site_p, this._memento);
        Integer value = null;
        if (this._memento != null) {
            value = this._memento.getInteger(LISTENING_TO_WORKBENCH_PAGE_SELECTION_EVENTS);
        }
        boolean bl = isListeningOnStartup = !ExplorerContextualActivator.getDefault().getPreferenceStore().getBoolean("disable.explorer.contextual.sync");
        __isListeningToPageSelectionEvents = value != null ? value == 1 : isListeningOnStartup;
    }

    private void initializeContextMenu(String menuManagerText_p, String menuManagerId_p, TreeViewer viewer_p) {
        MenuManager menuManager = new MenuManager(menuManagerText_p, menuManagerId_p);
        menuManager.setRemoveAllWhenShown(true);
        Tree tree = viewer_p.getTree();
        Menu currentMenu = menuManager.createContextMenu((Control)tree);
        tree.setMenu(currentMenu);
        this.getSite().registerContextMenu(menuManager, (ISelectionProvider)viewer_p);
    }

    private void initializeContextMenus() {
        this.initializeContextMenu("current#PopupMenu", null, this._currentViewer);
        this.initializeContextMenu("referenced#PopupMenu", null, this._referencedViewer);
        this.initializeContextMenu("referencing#PopupMenu", null, this._referencingViewer);
    }

    private void initializeViewer(TreeViewer viewer_p, IContentProvider contentProvider_p, IBaseLabelProvider labelProvider_p, ViewerSorter sorter_p) {
        viewer_p.getControl().setLayoutData((Object)new GridData(1808));
        viewer_p.setContentProvider(contentProvider_p);
        viewer_p.setLabelProvider(labelProvider_p);
        viewer_p.setSorter(sorter_p);
    }

    protected boolean isCtrlKeyPressed() {
        return this._isCtrlKeyPressed;
    }

    public ImageDescriptor getImageDescriptor(String key_p) {
        ImageRegistry imageRegistry = ExplorerContextualActivator.getDefault().getImageRegistry();
        ImageDescriptor imageDescriptor = imageRegistry.getDescriptor(key_p);
        if (imageDescriptor == null) {
            imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.amalgam.explorer.contextual.core.ui", (String)("icons/" + key_p));
            imageRegistry.put(key_p, imageDescriptor);
        }
        return imageDescriptor;
    }

    protected void makeActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        this._backAction = ExplorerActionFactory.BACKWARD_HISTORY.create(this.getViewSite().getWorkbenchWindow(), this);
        this._backAction.setActionDefinitionId("org.eclipse.amalgam.explorer.contextual.core.ui.backwardNavigation");
        toolBarManager.add((IAction)this._backAction);
        this._forwardAction = ExplorerActionFactory.FORWARD_HISTORY.create(this.getViewSite().getWorkbenchWindow(), this);
        this._forwardAction.setActionDefinitionId("org.eclipse.amalgam.explorer.contextual.core.ui.forwardNavigation");
        toolBarManager.add((IAction)this._forwardAction);
        this.limitateTreeExpansionAction = new Action(null, 2){

            public void run() {
                ExplorerContextualView.this.model.setLimitateTreeExpansion(this.isChecked());
                Object input = ExplorerContextualView.this.getCurrentViewer().getInput();
                ExplorerContextualView.this.setInputOnViewers(input);
            }
        };
        this.limitateTreeExpansionAction.setChecked(this.model.doesLimitateTreeExpansion());
        this.limitateTreeExpansionAction.setToolTipText(Messages.ExplorerContextualView_LimitateTreeExpansionAction_Tooltip);
        this.limitateTreeExpansionAction.setImageDescriptor(this.getImageDescriptor("full/clcl16/collapseCategories.gif"));
        toolBarManager.add(this.limitateTreeExpansionAction);
        Action refreshAction = new Action(null, this.getImageDescriptor("full/clcl16/refresh.gif")){

            public void run() {
                Object input = ExplorerContextualView.this.getCurrentViewer().getInput();
                ExplorerContextualView.this.refreshTitleBar(input);
                ExplorerContextualView.this.setInputOnViewers(input);
            }
        };
        toolBarManager.add((IAction)refreshAction);
        Action listeningToPageSelectionEventsAction = new Action(null, 2){

            private ISelection getSelection(IWorkbenchPart part_p) {
                return part_p.getSite().getSelectionProvider().getSelection();
            }

            private boolean isSomethingSelectable(ISelection selection) {
                return selection != null && !selection.isEmpty();
            }

            public void run() {
                if (this.isChecked()) {
                    ExplorerContextualView.this.activateListeningToPageSelectionEvents();
                    IWorkbenchPage activePage = ExplorerContextualView.this.getSite().getPage();
                    IWorkbenchPart activePart = activePage.getActivePart();
                    IWorkbenchPart part = null;
                    ISelection selection = null;
                    if (activePart != null && ExplorerContextualView.this != activePart) {
                        ISelectionProvider selectionProvider = activePart.getSite().getSelectionProvider();
                        if (selectionProvider != null && this.isSomethingSelectable(selection = selectionProvider.getSelection())) {
                            part = activePart;
                        }
                    } else {
                        String viewIDForSyncAction = ExplorerContextualView.this.getViewIDForSyncAction();
                        if (viewIDForSyncAction != null && !viewIDForSyncAction.isEmpty()) {
                            IEditorPart activeEditor;
                            IViewPart viewPart = activePage.findView(viewIDForSyncAction);
                            if (viewPart != null && this.isSomethingSelectable(selection = this.getSelection((IWorkbenchPart)viewPart))) {
                                part = viewPart;
                            }
                            if (part == null && (activeEditor = activePage.getActiveEditor()) != null && this.isSomethingSelectable(selection = this.getSelection((IWorkbenchPart)activeEditor))) {
                                part = activeEditor;
                            }
                        }
                    }
                    if (part != null) {
                        ExplorerContextualView.this._selectionListener.selectionChanged(part, selection);
                    }
                } else {
                    ExplorerContextualView.this.deactivateListeningToPageSelectionEvents();
                }
            }
        };
        listeningToPageSelectionEventsAction.setText(Messages.ExplorerContextualView_ListeningToPageSelectionEventsAction_Title);
        listeningToPageSelectionEventsAction.setToolTipText(Messages.ExplorerContextualView_ListeningToPageSelectionEventsAction_Tooltip);
        listeningToPageSelectionEventsAction.setImageDescriptor(this.getImageDescriptor("full/clcl16/synced.gif"));
        toolBarManager.add((IAction)listeningToPageSelectionEventsAction);
        listeningToPageSelectionEventsAction.setChecked(__isListeningToPageSelectionEvents);
        if (__isListeningToPageSelectionEvents) {
            listeningToPageSelectionEventsAction.run();
        }
    }

    @Override
    public void refresh() {
        ViewerHelper.refresh((StructuredViewer)this._referencingViewer);
        ViewerHelper.refresh((StructuredViewer)this._referencedViewer);
        ViewerHelper.refresh((StructuredViewer)this._currentViewer);
    }

    protected void refreshPropertyPage(ISelectionProvider selectionProvider_p) {
        IStructuredSelection selection = (IStructuredSelection)selectionProvider_p.getSelection();
        if (this._propertySheetPage != null && !this._propertySheetPage.getControl().isDisposed()) {
            ISelectionProvider pageSelectionProvider = this._propertySheetPage.getSite().getSelectionProvider();
            if (pageSelectionProvider == null || pageSelectionProvider != selectionProvider_p) {
                this._propertySheetPage.getSite().setSelectionProvider(selectionProvider_p);
            }
            this._propertySheetPage.selectionChanged((IWorkbenchPart)this, (ISelection)selection);
        }
    }

    @Override
    public void setInputOnViewers(final Object input_p) {
        TreeViewer currentViewer = this.getCurrentViewer();
        if (currentViewer != null && currentViewer.getControl() != null && !currentViewer.getControl().isDisposed()) {
            Display display = currentViewer.getControl().getDisplay();
            BusyIndicator.showWhile((Display)display, (Runnable)new Runnable(){

                @Override
                public void run() {
                    ViewerHelper.run((StructuredViewer)ExplorerContextualView.this._referencingViewer, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ExplorerContextualView.this._referencingViewer.getControl() != null && !(this).ExplorerContextualView.this._referencingViewer.getControl().isDisposed()) {
                                (this).ExplorerContextualView.this._referencingViewer.setInput(input_p);
                            }
                        }
                    });
                    ViewerHelper.run((StructuredViewer)ExplorerContextualView.this._referencedViewer, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ExplorerContextualView.this._referencedViewer.getControl() != null && !(this).ExplorerContextualView.this._referencedViewer.getControl().isDisposed()) {
                                (this).ExplorerContextualView.this._referencedViewer.setInput(input_p);
                            }
                        }
                    });
                    ViewerHelper.run((StructuredViewer)ExplorerContextualView.this._currentViewer, (Runnable)new Runnable(){

                        @Override
                        public void run() {
                            if ((this).ExplorerContextualView.this._currentViewer.getControl() != null && !(this).ExplorerContextualView.this._currentViewer.getControl().isDisposed()) {
                                (this).ExplorerContextualView.this._currentViewer.setInput(input_p);
                            }
                        }
                    });
                }
            });
        }
    }

    public static String getTitle(EObject object_p) {
        IEditingDomainItemProvider provider;
        String title = AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider().getText((Object)object_p);
        AdapterFactoryEditingDomain editingDomain = (AdapterFactoryEditingDomain)AdapterFactoryEditingDomain.getEditingDomainFor((EObject)object_p);
        if (editingDomain != null && (provider = AdapterFactoryEditingDomain.getEditingDomainItemProviderFor((Object)object_p)) instanceof ItemProviderAdapter) {
            EClass eClass = object_p.eClass();
            try {
                String className = ((ItemProviderAdapter)provider).getString("_UI_" + eClass.getName() + "_type");
                if (className != null && !className.isEmpty()) {
                    className = "[" + className + "]";
                }
                if (!title.equals(className)) {
                    title = String.valueOf(className) + " " + title;
                }
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return title;
    }

    protected void refreshTitleBar(Object selectedElement_p) {
        String title = Messages.ExplorerContextualView_Default_Name;
        Image image = null;
        if (selectedElement_p != null) {
            title = ExplorerContextualView.getTitle((EObject)selectedElement_p);
            image = AbstractLabelProviderFactory.getInstance().getCurrentLabelProvider().getImage(selectedElement_p);
        }
        if (!this._explorerContextualTitle.isDisposed()) {
            this._explorerContextualTitle.setRedraw(false);
            this._explorerContextualTitle.setTitle(title, image);
            this._explorerContextualTitle.setRedraw(true);
        }
    }

    protected void removeListeners(TreeViewer viewer_p) {
        viewer_p.removeDoubleClickListener(this._viewerDoubleClickListener);
        viewer_p.removeSelectionChangedListener(this._viewerSelectionListener);
    }

    private IMemento restoreViewSettings(IMemento memento_p) {
        String persistedMemento;
        IMemento memento_l = memento_p;
        if (memento_l == null && (persistedMemento = this._viewSettings.get(TAG_MEMENTO)) != null) {
            try {
                memento_l = XMLMemento.createReadRoot((Reader)new StringReader(persistedMemento));
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        return memento_l;
    }

    public void saveState(IMemento memento_p) {
        memento_p.putInteger(LISTENING_TO_WORKBENCH_PAGE_SELECTION_EVENTS, __isListeningToPageSelectionEvents ? 1 : 0);
    }

    private void saveViewSettings() {
        String rootName = this.getClass().getSimpleName();
        XMLMemento memento = XMLMemento.createWriteRoot((String)rootName);
        this.saveState((IMemento)memento);
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
            this._viewSettings.put(TAG_MEMENTO, writer.getBuffer().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setFocus() {
        ISelectionProvider selectionProvider = this._delegateSelectionProvider.getDelegate();
        if (selectionProvider != null && selectionProvider instanceof TreeViewer) {
            ((TreeViewer)selectionProvider).getControl().setFocus();
        } else {
            this._currentViewer.getControl().setFocus();
        }
    }

    @Override
    public void setInput(Object input_p) {
        TreeViewer currentViewer = this.getCurrentViewer();
        Object lastInput = currentViewer.getInput();
        if (lastInput != null && lastInput.equals(input_p)) {
            return;
        }
        this.refreshTitleBar(input_p);
        this._delegateSelectionProvider.setDelegate((ISelectionProvider)this._currentViewer);
        this.setInputOnViewers(input_p);
        this.onSetNewInput(input_p, lastInput);
        this.getHistory().update(input_p);
        if (this._shouldSetFocus) {
            this.setFocus();
        }
    }

    protected void updateSelectionProvider(ISelectionProvider newSelectionProvider_p) {
        ISelectionProvider currentSelectionProvider = this._delegateSelectionProvider.getDelegate();
        if (currentSelectionProvider == null || currentSelectionProvider != newSelectionProvider_p) {
            this._delegateSelectionProvider.setDelegate(newSelectionProvider_p);
        }
    }

    public static boolean isListeningToPageSelectionEvents() {
        return __isListeningToPageSelectionEvents;
    }

    protected Object handleWorkbenchPageSelectionEvent(IWorkbenchPart part_p, ISelection selection_p) {
        Object result = null;
        if (!selection_p.isEmpty() && !(part_p instanceof ExplorerContextualView) && selection_p instanceof IStructuredSelection) {
            IStructuredSelection selection_l = (IStructuredSelection)selection_p;
            Object firstElement = selection_l.getFirstElement();
            result = SelectionHelpersManager.getInstance().getSelection(part_p, selection_p, firstElement);
        }
        return result;
    }

    public void logError(String message, Throwable throwable) {
        ExplorerContextualActivator.getDefault().getLog().log((IStatus)new Status(4, "org.eclipse.amalgam.explorer.contextual.core.ui", message, throwable));
    }

    protected final void handleDoubleClickWithCtrlKeyPressed(DoubleClickEvent event_p, Object object_p) {
        if (this.getRootElement() != object_p) {
            this.setInput(object_p);
            this._currentViewer.setSelection((ISelection)new StructuredSelection(object_p), true);
        }
    }

    public String getContributorId() {
        return EXPLORER_CONTEXTUAL_CONTRIBUTOR_ID;
    }

    protected void handleDoubleClickWithCtrlKeyNotPressed(DoubleClickEvent event_p, Object object_p) {
    }

    protected void onSetNewInput(Object input_p, Object lastInput_p) {
    }

    public abstract boolean isSemanticElements(Collection<?> var1);

    protected abstract String getViewIDForSyncAction();

    protected abstract String ingoredViewAsSelectionProvider();

    class SemClosedSessionListener
    extends SessionManagerListener.Stub {
        SemClosedSessionListener() {
        }

        public void notify(Session updated_p, int notification_p) {
            switch (notification_p) {
                case 8: {
                    Session session;
                    Object currentInput = ExplorerContextualView.this.getCurrentViewer().getInput();
                    if (!(currentInput instanceof EObject) || !updated_p.equals(session = SessionManager.INSTANCE.getSession((EObject)currentInput))) break;
                    ExplorerContextualView.this.clean();
                    break;
                }
                case 9: {
                    ExplorerContextualView.this.getHistory().update(null);
                }
            }
        }
    }
}

