/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd.agent.connector;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.PageantConnector;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.Texts;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.UnixDomainSocketConnector;
import org.eclipse.jgit.internal.transport.sshd.agent.connector.WinPipeConnector;
import org.eclipse.jgit.transport.sshd.agent.Connector;
import org.eclipse.jgit.transport.sshd.agent.ConnectorFactory;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public class Factory
implements ConnectorFactory {
    private static final String NAME = "jgit-builtin";

    public Connector create(String identityAgent, File homeDir) throws IOException {
        if (SystemReader.getInstance().isWindows()) {
            if (StringUtils.isEmptyOrNull((String)identityAgent)) {
                return new PageantConnector();
            }
            String winPath = identityAgent.replace('/', '\\');
            if (PageantConnector.DESCRIPTOR.getIdentityAgent().equalsIgnoreCase(winPath)) {
                return new PageantConnector();
            }
            if (winPath.toLowerCase(Locale.ROOT).startsWith("\\\\.\\pipe\\")) {
                return new WinPipeConnector(winPath);
            }
            throw new IOException(MessageFormat.format(Texts.get().errUnknownIdentityAgent, identityAgent));
        }
        return new UnixDomainSocketConnector(identityAgent);
    }

    public boolean isSupported() {
        return true;
    }

    public String getName() {
        return NAME;
    }

    public Collection<ConnectorFactory.ConnectorDescriptor> getSupportedConnectors() {
        if (SystemReader.getInstance().isWindows()) {
            return List.of(PageantConnector.DESCRIPTOR, WinPipeConnector.DESCRIPTOR);
        }
        return Collections.singleton(UnixDomainSocketConnector.DESCRIPTOR);
    }

    public ConnectorFactory.ConnectorDescriptor getDefaultConnector() {
        if (SystemReader.getInstance().isWindows()) {
            return PageantConnector.DESCRIPTOR;
        }
        return UnixDomainSocketConnector.DESCRIPTOR;
    }
}

