/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.usage.util;

import org.apache.log4j.Appender;
import org.apache.log4j.Logger;
import org.osgi.framework.Bundle;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageAppenderPlugin;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageAppender;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;

public class UsageLogger {
    private static final String USAGE_LOGGER = "Usage";
    private String applicationName;
    private String applicationVersion;
    private Logger logger;
    public static final String NONE = "";
    public static final String OK = "OK";
    public static final String ERROR = "ERROR";

    public Logger getLogger() {
        if (this.logger == null) {
            String defaultConfiguration = ReportManagerRegistry.getConfigurationFile((Bundle)UsageAppenderPlugin.getDefault().getBundle(), (String)"usageConfiguration.xml");
            this.logger = ReportManagerRegistry.getInstance().subscribe(USAGE_LOGGER, defaultConfiguration);
            try {
                UsageAppender appender = new UsageAppender();
                this.logger.addAppender((Appender)appender);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.logger;
    }

    public UsageLogger(String applicationName, String applicationVersion) {
        this.applicationName = applicationName;
        this.applicationVersion = applicationVersion;
    }

    public void log(String eventName, UsageMonitoring.EventStatus eventStatus) {
        this.log(eventName, NONE, eventStatus, NONE);
    }

    public void log(String eventName, String eventContext, UsageMonitoring.EventStatus eventStatus) {
        this.log(eventName, eventContext, eventStatus, NONE);
    }

    public void log(String eventName, String eventContext, UsageMonitoring.EventStatus eventStatus, String addendum) {
        try {
            this.getLogger().info((Object)new UsageMonitoring(this.applicationName, this.applicationVersion, eventName, eventContext, eventStatus, addendum));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

