/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.portfolio.genchain.tools.ui.actions;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.util.DomainSwitch;
import org.eclipse.egf.portfolio.genchain.generationChain.FeatureAddition;
import org.eclipse.egf.portfolio.genchain.generationChain.GenerationChain;
import org.eclipse.egf.portfolio.genchain.generationChain.util.GenerationChainSwitch;
import org.eclipse.egf.portfolio.genchain.tools.ui.Activator;
import org.eclipse.egf.portfolio.genchain.tools.ui.actions.CreateFcoreHelper;
import org.eclipse.egf.portfolio.genchain.tools.utils.QualifierReplacer;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.exports.FeatureExportInfo;
import org.eclipse.pde.internal.core.exports.FeatureExportOperation;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class BuildApplicationHelper
extends CreateFcoreHelper {
    private static final String ORG_ECLIPSE_PDE_PLUGIN_NATURE = "org.eclipse.pde.PluginNature";
    public static final BuildApplicationHelper INSTANCE = new BuildApplicationHelper();
    private static final String OS_NAME = "os.name";
    private static final String WINDOWS = "Windows";
    protected GenerationChain generationChain;

    public void build(URI uri) {
        this.createJob(uri, true).schedule();
    }

    @Override
    public WorkspaceJob createJob(GenerationChain generationChain, boolean run) {
        this.generationChain = generationChain;
        return super.createJob(generationChain, run);
    }

    @Override
    public WorkspaceJob createAfterJob() {
        final WorkspaceJob buildJob = new WorkspaceJob("Building Models"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    BuildApplicationHelper.this.buildApplication();
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
        return new WorkspaceJob("Build application"){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                try {
                    BuildApplicationHelper.this.generateFeaturePlugin(BuildApplicationHelper.this.generationChain.eResource().getResourceSet(), BuildApplicationHelper.this.generationChain, monitor);
                    buildJob.schedule(1000L);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
                }
                return Status.OK_STATUS;
            }
        };
    }

    private void buildApplication() throws CoreException {
        final String pluginName = this.generationChain.getFactoryComponentName();
        final String name = this.generationChain.getName();
        ArrayList<IProject> featureProjects = new ArrayList<IProject>();
        featureProjects.add(ResourcesPlugin.getWorkspace().getRoot().getProject(String.valueOf(pluginName) + ".feature"));
        this.collectAdditionalFeatures(featureProjects);
        final FeatureExportInfo exportInfo = this.createFeatureExportInfo(name, featureProjects);
        new FeatureExportOperation(exportInfo, "Build application"){

            protected IStatus run(IProgressMonitor monitor) {
                String osName;
                IStatus run = super.run(monitor);
                BuildApplicationHelper.this.createEclipseExtensionFile(pluginName, name, exportInfo);
                if (run.isOK() && !monitor.isCanceled() && (osName = System.getProperty(BuildApplicationHelper.OS_NAME)).contains(BuildApplicationHelper.WINDOWS)) {
                    try {
                        Runtime.getRuntime().exec("explorer.exe " + new File(exportInfo.destinationDirectory).getParentFile().getParent());
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return run;
            }
        }.schedule(500L);
    }

    private void collectAdditionalFeatures(final List<IProject> featureProjects) {
        new GenerationChainSwitch<Object>(){

            public Object caseGenerationChain(GenerationChain object) {
                for (EObject obj : object.getElements()) {
                    this.doSwitch(obj);
                }
                return this;
            }

            public Object caseFeatureAddition(FeatureAddition addition) {
                for (String projectName : addition.getAdditions()) {
                    IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
                    featureProjects.add(project);
                }
                return this;
            }
        }.doSwitch((EObject)this.generationChain);
    }

    private void createEclipseExtensionFile(String pluginName, String name, FeatureExportInfo exportInfo) {
        block12: {
            File eclipseExtensionFile = new File(exportInfo.destinationDirectory, ".eclipseextension");
            OutputStreamWriter fileWriter = null;
            try {
                try {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append("name=");
                    stringBuilder.append(name);
                    stringBuilder.append("\n");
                    stringBuilder.append("id=");
                    stringBuilder.append(pluginName);
                    stringBuilder.append("\n");
                    stringBuilder.append("version=");
                    stringBuilder.append("1.0.0.qualifier");
                    stringBuilder.append("\n");
                    fileWriter = new FileWriter(eclipseExtensionFile);
                    fileWriter.append(stringBuilder.toString());
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    if (fileWriter == null) break block12;
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            finally {
                if (fileWriter != null) {
                    try {
                        fileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    private FeatureExportInfo createFeatureExportInfo(String name, List<IProject> featureProjects) throws CoreException {
        File tempFile;
        FeatureExportInfo f = new FeatureExportInfo();
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        ArrayList<IFeatureModel> featureModels = new ArrayList<IFeatureModel>();
        for (IProject feature : featureProjects) {
            IFeatureModel featureModel = manager.getFeatureModel(feature);
            if (featureModel == null) {
                throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), "Cannot get project for feature '" + feature.getName() + "'", null));
            }
            featureModels.add(featureModel);
        }
        f.qualifier = QualifierReplacer.getDate();
        try {
            tempFile = File.createTempFile("" + System.currentTimeMillis(), "");
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getDefault().getPluginID(), e.getMessage(), (Throwable)e));
        }
        String separator = System.getProperty("file.separator");
        f.destinationDirectory = String.valueOf(tempFile.getParent()) + separator + f.qualifier + separator + name + "_" + f.qualifier + separator + "eclipse";
        f.items = featureModels.toArray();
        f.exportSource = false;
        f.toDirectory = true;
        f.useJarFormat = false;
        f.allowBinaryCycles = true;
        return f;
    }

    private EList<EObject> collectDomains(ResourceSet resourceSet, String fcPath) {
        BasicEList result = new BasicEList();
        DomainSwitch<Object> _switch = new DomainSwitch<Object>((EList)result, resourceSet){
            private final /* synthetic */ EList val$result;
            private final /* synthetic */ ResourceSet val$resourceSet;
            {
                this.val$result = eList;
                this.val$resourceSet = resourceSet;
            }

            public Object caseEMFDomain(EMFDomain object) {
                this.val$result.add((Object)((EObject)this.val$resourceSet.getResource(object.getUri(), true).getContents().get(0)));
                return this;
            }

            public Object defaultCase(EObject object) {
                for (EObject obj : object.eContents()) {
                    this.doSwitch(obj);
                }
                return null;
            }
        };
        for (EObject obj : resourceSet.getResource(URI.createPlatformPluginURI((String)fcPath, (boolean)false), true).getContents()) {
            _switch.doSwitch(obj);
        }
        return result;
    }
}

