/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.model.detachment.ui.internal;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.polarsys.kitalpha.model.common.share.resource.loading.LoadResource;

public class DetachmentResourceProviderUtil {
    public static synchronized Resource getResource(IFile airdFile) throws IllegalArgumentException {
        if (airdFile == null) {
            throw new IllegalArgumentException("the file must be not null");
        }
        Map extensionToFactoryMap = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!extensionToFactoryMap.containsKey(airdFile.getFileExtension())) {
            throw new IllegalArgumentException("Cannot resolve resource from: " + airdFile.getFullPath().toString());
        }
        URI uri = URI.createPlatformResourceURI((String)airdFile.getFullPath().toString(), (boolean)true);
        Session session = SessionManager.INSTANCE.getExistingSession(uri);
        if (session != null) {
            return session.getSessionResource();
        }
        return new LoadResource(airdFile).getResource();
    }
}

