/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.tools.report.appenders.console;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.LoggingEvent;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.console.MessageConsoleStream;
import org.polarsys.capella.common.tools.report.appenders.console.ConsoleAppenderActivator;
import org.polarsys.capella.common.tools.report.appenders.console.IReportConsole;

public class ReportManagerConsoleAppender
extends AppenderSkeleton {
    private static final String CONSOLE_APPENDER_JOB_FAMILY = "ConsoleAppenderJob";
    protected IReportConsole console;
    private volatile boolean running;
    private Map<Level, Writer> logWriters;

    public ReportManagerConsoleAppender() {
        this((Layout)new PatternLayout("%d{MM-dd HH:mm:ss} %-5.5p %m%n"));
    }

    public ReportManagerConsoleAppender(Layout layout) {
        this.setLayout(layout);
        this.setName("Console");
        this.console = ConsoleAppenderActivator.getDefault().getReportConsole();
        this.logWriters = new HashMap<Level, Writer>();
        if (this.console != null) {
            HashMap<Level, MessageConsoleStream> messageStreams = this.console.getOutputStreams();
            for (Map.Entry entry : messageStreams.entrySet()) {
                this.logWriters.put((Level)entry.getKey(), new BufferedWriter(new OutputStreamWriter((OutputStream)entry.getValue())));
            }
        }
        this.running = true;
    }

    protected void append(LoggingEvent event) {
        ConsoleAppenderJob job = this.getAppenderJob();
        job.addLoggingEvent(event);
        job.schedule();
    }

    public void close() {
        this.running = false;
    }

    public boolean requiresLayout() {
        return true;
    }

    private ConsoleAppenderJob getAppenderJob() {
        Job[] jobs = Job.getJobManager().find((Object)CONSOLE_APPENDER_JOB_FAMILY);
        if (jobs.length != 0) {
            return (ConsoleAppenderJob)jobs[0];
        }
        return new ConsoleAppenderJob();
    }

    class ConsoleAppenderJob
    extends Job {
        LinkedList<LoggingEvent> fifo;

        public ConsoleAppenderJob() {
            super("Capella Console Appender");
            this.fifo = new LinkedList();
        }

        public boolean belongsTo(Object family) {
            return ReportManagerConsoleAppender.CONSOLE_APPENDER_JOB_FAMILY.equals(family);
        }

        public void addLoggingEvent(LoggingEvent event) {
            this.fifo.addLast(event);
        }

        protected IStatus run(IProgressMonitor monitor) {
            while (ReportManagerConsoleAppender.this.running && !this.fifo.isEmpty()) {
                this.writeToConsole(this.fifo.removeFirst());
            }
            return Status.OK_STATUS;
        }

        private void writeToConsole(LoggingEvent event) {
            try {
                Writer writer = ReportManagerConsoleAppender.this.logWriters.get(event.getLevel());
                if (writer != null) {
                    String[] s;
                    writer.write(" [From " + event.getLoggerName() + "] ");
                    writer.write(ReportManagerConsoleAppender.this.layout.format(event));
                    if (ReportManagerConsoleAppender.this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
                        int len = s.length;
                        int i = 0;
                        while (i < len) {
                            writer.write(s[i]);
                            writer.write(Layout.LINE_SEP);
                            ++i;
                        }
                    }
                }
            }
            catch (IOException e) {
                ConsoleAppenderActivator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.common.tools.report.appenders.console", e.getMessage(), (Throwable)e));
            }
        }
    }
}

