/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.information.validation.property;

import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.validation.IValidationContext;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.validation.rule.AbstractValidationRule;

public class PropertyOrRoleRespectsCovariance
extends AbstractValidationRule {
    public IStatus validate(IValidationContext ctx) {
        Class ownerClass;
        Property property;
        Class parentClass;
        EObject eObj = ctx.getTarget();
        if (eObj instanceof Property && eObj.eContainer() instanceof Class && (parentClass = this.notRespectCovariance(property = (Property)eObj, ownerClass = (Class)eObj.eContainer())) != null) {
            return ctx.createFailureStatus(new Object[]{ownerClass.getName(), property.getName(), parentClass.getName()});
        }
        return ctx.createSuccessStatus();
    }

    private Class notRespectCovariance(Property property, Class ownerClass) {
        for (GeneralizableElement parent : GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)ownerClass)) {
            if (!(parent instanceof Class)) continue;
            Class parentClass = (Class)parent;
            for (Property parentPoperty : parentClass.getContainedProperties()) {
                AbstractType parentType;
                AbstractType type;
                if (!parentPoperty.getName().equals(property.getName()) || this.isInstanceOf(type = property.getAbstractType(), parentType = parentPoperty.getAbstractType())) continue;
                return parentClass;
            }
        }
        return null;
    }

    private boolean isInstanceOf(AbstractType child, AbstractType parent) {
        if (child == parent) {
            return true;
        }
        if (child instanceof GeneralizableElement) {
            GeneralizableElement theChild = (GeneralizableElement)child;
            List allParents = GeneralizableElementExt.getAllSuperGeneralizableElements((GeneralizableElement)theChild);
            return allParents.contains(parent);
        }
        return false;
    }
}

