/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.common.ef;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.ef.internal.command.AbstractNonDirtyingRecordingCommand;
import org.polarsys.capella.common.mdsofa.common.helper.ExtensionPointHelper;

public class ExecutionManager {
    private TransactionalEditingDomain _editingDomain = this.createEditingDomain();
    static final String EDITING_DOMAIN_ID = "org.polarsys.capella.common.platform.sirius.ted.EditingDomain";

    public TransactionalEditingDomain getEditingDomain() {
        return this._editingDomain;
    }

    public void execute(ICommand command) {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        Assert.isNotNull((Object)editingDomain);
        Assert.isNotNull((Object)command);
        if (command.isReadOnly()) {
            this.executeReadOnlyCommand(command, editingDomain);
        } else {
            this.executeReadWriteCommand(command, editingDomain);
        }
    }

    protected void executeReadOnlyCommand(ICommand command, TransactionalEditingDomain editingDomain) {
        try {
            editingDomain.runExclusive((Runnable)command);
        }
        catch (InterruptedException ie) {
            command.commandInterrupted();
        }
    }

    protected void executeReadWriteCommand(ICommand command, TransactionalEditingDomain editingDomain) {
        TransactionalCommandStack stack = (TransactionalCommandStack)editingDomain.getCommandStack();
        try {
            stack.execute((Command)this.createRecordingCommand(command, editingDomain), command.getExecutionOptions());
        }
        catch (InterruptedException exception) {
            command.commandInterrupted();
        }
        catch (RollbackException exception) {
            command.commandRolledBack();
        }
    }

    protected RecordingCommand createRecordingCommand(final ICommand command, TransactionalEditingDomain editingDomain) {
        RecordingCommand result = null;
        result = command instanceof AbstractCommand.NonDirtying ? new AbstractNonDirtyingRecordingCommand(editingDomain){

            protected void doExecute() {
                command.run();
            }

            public Collection<?> getAffectedObjects() {
                return command.getAffectedObjects();
            }
        } : new RecordingCommand(editingDomain){

            protected void doExecute() {
                command.run();
            }

            public Collection<?> getAffectedObjects() {
                return command.getAffectedObjects();
            }
        };
        result.setLabel(command.toString());
        return result;
    }

    protected TransactionalEditingDomain createEditingDomain() {
        TransactionalEditingDomain.Factory factory = this.getEditingDomainFactory();
        if (factory != null) {
            return factory.createEditingDomain();
        }
        return null;
    }

    public TransactionalEditingDomain.Factory getEditingDomainFactory() {
        IConfigurationElement configurationElement = ExtensionPointHelper.getConfigurationElement((String)"org.eclipse.emf.transaction", (String)"editingDomains", (String)EDITING_DOMAIN_ID);
        if (configurationElement != null) {
            return (TransactionalEditingDomain.Factory)ExtensionPointHelper.createInstance((IConfigurationElement)configurationElement, (String)"factory");
        }
        return null;
    }
}

