/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.handlers;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.DragAndDropTarget;
import org.eclipse.sirius.diagram.EdgeTarget;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.diagram.description.filter.FilterDescription;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.transition.diagram.handlers.DiagramDescriptionHelper;
import org.polarsys.capella.core.transition.diagram.handlers.IDiagramHandler;
import org.polarsys.capella.core.transition.diagram.helpers.TraceabilityHelper;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public abstract class AbstractDiagramHandler
implements IDiagramHandler {
    @Override
    public boolean handles(IContext context_p, RepresentationDescription representation_p) {
        return true;
    }

    @Override
    public boolean covers(IContext context_p, DRepresentationDescriptor representation_p) {
        return true;
    }

    @Override
    public boolean backCovers(IContext context_p, DRepresentationDescriptor representation_p) {
        return true;
    }

    @Override
    public FilterDescription getTargetFilterDescription(IContext context_p, DiagramDescription description_p, DiagramDescription description2_p, FilterDescription description3_p) {
        String sourceLabel = description3_p.getName();
        if (description3_p.getLabel() != null) {
            sourceLabel = description3_p.getLabel();
        }
        for (FilterDescription description : description2_p.getFilters()) {
            String targetLabel = description.getName();
            if (description.getLabel() != null) {
                targetLabel = description.getLabel();
            }
            if (!sourceLabel.equals(targetLabel)) continue;
            return description;
        }
        return null;
    }

    @Override
    public boolean isReconciliable(IContext context_p, RepresentationDescription sourceDescription_p, DEdge edgeTarget_p, DSemanticDecorator sourceNode_p, DSemanticDecorator targetNode_p) {
        return sourceNode_p.equals(edgeTarget_p.getSourceNode()) && targetNode_p.equals(edgeTarget_p.getTargetNode());
    }

    @Override
    public boolean isReconciliable(IContext context_p, RepresentationDescription sourceDescription_p, AbstractDNode currentNode_p, DSemanticDecorator eContainer_p) {
        return currentNode_p.eContainer().equals(eContainer_p);
    }

    public IStatus init(IContext context_p) {
        return Status.OK_STATUS;
    }

    public IStatus dispose(IContext context_p) {
        return Status.OK_STATUS;
    }

    @Override
    public DSemanticDecorator showNode(IContext context_p, RepresentationDescription sourceDescription_p, DDiagramContents targetContents_p, AbstractNodeMapping mapping_p, DSemanticDecorator containerNode_p, EObject targetSemantic_p) {
        Collection nodes = targetContents_p.getDiagramElements(targetSemantic_p, (DiagramElementMapping)mapping_p, containerNode_p);
        if (nodes.size() > 0) {
            for (DSemanticDecorator target : nodes) {
                if (!(target instanceof AbstractDNode) || !this.isReconciliable(context_p, sourceDescription_p, (AbstractDNode)target, containerNode_p)) continue;
                return target;
            }
        }
        if (DiagramServices.getDiagramServices().isValidMapping(mapping_p, containerNode_p) && DiagramServices.getDiagramServices().evaluateNodePrecondition(mapping_p, targetContents_p.getDDiagram(), containerNode_p, targetSemantic_p)) {
            AbstractDNode targetView = DiagramServices.getDiagramServices().createAbstractDNode(mapping_p, targetSemantic_p, (DragAndDropTarget)containerNode_p, targetContents_p.getDDiagram());
            return targetView;
        }
        return null;
    }

    @Override
    public DDiagramElement showEdge(IContext context_p, RepresentationDescription sourceDescription_p, DDiagramContents targetContents_p, EdgeMapping mapping_p, DSemanticDecorator sourceNode_p, DSemanticDecorator targetNode_p, EObject targetSemantic_p) {
        for (DSemanticDecorator target : targetContents_p.getDiagramElements(targetSemantic_p, (DiagramElementMapping)mapping_p)) {
            if (!(target instanceof DEdge)) continue;
            DEdge edgeTarget = (DEdge)target;
            if (!DiagramDescriptionHelper.getService(context_p).isReconciliable(context_p, sourceDescription_p, edgeTarget, sourceNode_p, targetNode_p)) continue;
            return (DEdge)target;
        }
        DEdge targetView = DiagramServices.getDiagramServices().createEdge(mapping_p, (EdgeTarget)sourceNode_p, (EdgeTarget)targetNode_p, targetSemantic_p);
        return targetView;
    }

    @Override
    public Collection<EObject> getTargetSemantics(IContext context_p, EObject sourceSemantic_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p) {
        return TraceabilityHelper.getService(context_p).getAllocatingElements(context_p, sourceSemantic_p);
    }

    @Override
    public EObject getTargetSemantic(IContext context_p, EObject sourceSemantic_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p) {
        EObject targetArchitecture;
        EObject target = this._getTargetSemantic(context_p, sourceSemantic_p, sourceDescription_p, targetDescription_p);
        if (target != null) {
            return target;
        }
        BlockArchitecture architecture = BlockArchitectureExt.getRootBlockArchitecture((EObject)sourceSemantic_p);
        target = this._getTargetSemantic(context_p, (EObject)architecture, sourceDescription_p, targetDescription_p);
        if (target != null && (targetArchitecture = target) instanceof BlockArchitecture) {
            return DiagramDescriptionHelper.getService(context_p).getTargetDefaultLocation(context_p, (BlockArchitecture)targetArchitecture, targetDescription_p);
        }
        return null;
    }

    protected EObject _getTargetSemantic(IContext context_p, EObject sourceSemantic_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p) {
        Collection<EObject> result = this.getTargetSemantics(context_p, sourceSemantic_p, sourceDescription_p, targetDescription_p);
        if (!result.isEmpty()) {
            return result.iterator().next();
        }
        return null;
    }
}

