/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.diagram.handlers;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DEdge;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.EdgeMapping;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.diagram.helpers.DiagramHelper;
import org.polarsys.capella.core.diagram.helpers.naming.DiagramNamingConstants;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.sirius.analysis.DDiagramContents;
import org.polarsys.capella.core.sirius.analysis.DiagramServices;
import org.polarsys.capella.core.sirius.analysis.FaServices;
import org.polarsys.capella.core.transition.diagram.handlers.AbstractDiagramHandler;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class DataflowHandler
extends AbstractDiagramHandler {
    @Override
    public boolean handles(IContext context_p, RepresentationDescription representation_p) {
        if (DiagramHelper.getService().isA(representation_p, "Operational Activity Interaction Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(representation_p, "System Data Flow Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(representation_p, "Logical Data Flow Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(representation_p, "Physical Data Flow Blank");
    }

    @Override
    public boolean covers(IContext context_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Operational Activity Interaction Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(description_p, "System Data Flow Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(description_p, "Logical Data Flow Blank");
    }

    @Override
    public boolean backCovers(IContext context_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "System Data Flow Blank")) {
            return true;
        }
        if (DiagramHelper.getService().isA(description_p, "Logical Data Flow Blank")) {
            return true;
        }
        return DiagramHelper.getService().isA(description_p, "Physical Data Flow Blank");
    }

    @Override
    public DDiagramElement showEdge(IContext context_p, RepresentationDescription sourceDescription_p, DDiagramContents targetContents_p, EdgeMapping mapping_p, DSemanticDecorator sourceNode_p, DSemanticDecorator targetNode_p, EObject targetSemantic_p) {
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Activity Interaction Blank") && targetSemantic_p instanceof FunctionalExchange) {
            FaServices.getFaServices().showDFFunctionalExchange((AbstractDNode)sourceNode_p, (FunctionalExchange)targetSemantic_p, targetContents_p, false);
        }
        return super.showEdge(context_p, sourceDescription_p, targetContents_p, mapping_p, sourceNode_p, targetNode_p, targetSemantic_p);
    }

    @Override
    public boolean isReconciliable(IContext context_p, RepresentationDescription sourceDescription_p, DEdge edgeTarget_p, DSemanticDecorator sourceNode_p, DSemanticDecorator targetNode_p) {
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Activity Interaction Blank") && edgeTarget_p.getTarget() instanceof FunctionalExchange) {
            return EcoreUtil.isAncestor((EObject)sourceNode_p, (EObject)edgeTarget_p.getSourceNode()) && EcoreUtil.isAncestor((EObject)targetNode_p, (EObject)edgeTarget_p.getTargetNode());
        }
        return sourceNode_p.equals(edgeTarget_p.getSourceNode()) && targetNode_p.equals(edgeTarget_p.getTargetNode());
    }

    @Override
    public DiagramElementMapping getTargetMapping(IContext context_p, RepresentationDescription sourceDescription_p, RepresentationDescription targetDescription_p, DiagramElementMapping sourceMapping_p, EObject source_p, EObject target_p) {
        String mappingName = sourceMapping_p.getName();
        String targetMappingName = null;
        if (DiagramHelper.getService().isA(sourceDescription_p, "Operational Activity Interaction Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "System Data Flow Blank")) {
                if ("OAIB Operational Activity".equals(mappingName)) {
                    targetMappingName = "SDFB_Function";
                } else if ("OAIB Interaction".equals(mappingName)) {
                    targetMappingName = "SDFB_Exchange";
                } else if ("OAIB_OperationalProcessEnd".equals(mappingName)) {
                    targetMappingName = "SDFB_FunctionalChainEnd";
                } else if ("OAIB_OperationalProcess".equals(mappingName)) {
                    targetMappingName = "SDFB_FunctionalChain";
                }
            }
        } else if (DiagramHelper.getService().isA(sourceDescription_p, "System Data Flow Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "Logical Data Flow Blank")) {
                if ("SDFB_Function".equals(mappingName)) {
                    targetMappingName = "LDFB_Function";
                } else if ("SDFB_Exchange".equals(mappingName)) {
                    targetMappingName = "LDFB_Exchange";
                } else if ("SDFB_FunctionalChain".equals(mappingName)) {
                    targetMappingName = "LDFB_FunctionalChain";
                } else if ("SDFB_FunctionalChainEnd".equals(mappingName)) {
                    targetMappingName = "LDFB_FunctionalChainEnd";
                } else if ("SDFB_Node".equals(mappingName)) {
                    targetMappingName = "LDFB_Node";
                } else if ("SDFB_Pin".equals(mappingName)) {
                    targetMappingName = "LDFB_Pin";
                } else if ("SDFB_InternLink".equals(mappingName)) {
                    targetMappingName = "LDFB_InternLink";
                } else if ("SDFB_InputPin by Categorie".equals(mappingName)) {
                    targetMappingName = "LDFB_InputPin by Categorie";
                } else if ("SDFB_OutputPin by Categorie".equals(mappingName)) {
                    targetMappingName = "LDFB_OutputPin by Categorie";
                } else if ("SDFB_Exchange by Categorie".equals(mappingName)) {
                    targetMappingName = "LDFB_Exchange by Categorie";
                }
            }
        } else if (DiagramHelper.getService().isA(sourceDescription_p, "Logical Data Flow Blank") && DiagramHelper.getService().isA(targetDescription_p, "Physical Data Flow Blank")) {
            if ("LDFB_Function".equals(mappingName)) {
                targetMappingName = "PDFB_Function";
            } else if ("LDFB_Exchange".equals(mappingName)) {
                targetMappingName = "PDFB_Exchange";
            } else if ("LDFB_FunctionalChain".equals(mappingName)) {
                targetMappingName = "PDFB_FunctionalChain";
            } else if ("LDFB_FunctionalChainEnd".equals(mappingName)) {
                targetMappingName = "PDFB_FunctionalChainEnd";
            } else if ("LDFB_Node".equals(mappingName)) {
                targetMappingName = "PDFB_Node";
            } else if ("LDFB_Pin".equals(mappingName)) {
                targetMappingName = "PDFB_Pin";
            } else if ("LDFB_InternLink".equals(mappingName)) {
                targetMappingName = "PDFB_InternLink";
            } else if ("LDFB_InputPin by Categorie".equals(mappingName)) {
                targetMappingName = "PDFB_InputPin by Categorie";
            } else if ("LDFB_OutputPin by Categorie".equals(mappingName)) {
                targetMappingName = "PDFB_OutputPin by Categorie";
            } else if ("LDFB_Exchange by Categorie".equals(mappingName)) {
                targetMappingName = "PDFB_Exchange by Categorie";
            }
        }
        return DiagramServices.getDiagramServices().getMappingByName(targetDescription_p, targetMappingName);
    }

    @Override
    public RepresentationDescription getTargetDescription(IContext context_p, Session session_p, RepresentationDescription description_p) {
        DiagramHelper service = DiagramHelper.getService();
        if (service.isA(description_p, "Operational Activity Interaction Blank")) {
            return service.getDescription(session_p, "System Data Flow Blank");
        }
        if (service.isA(description_p, "System Data Flow Blank")) {
            return service.getDescription(session_p, "Logical Data Flow Blank");
        }
        if (service.isA(description_p, "Logical Data Flow Blank")) {
            return service.getDescription(session_p, "Physical Data Flow Blank");
        }
        return null;
    }

    @Override
    public String getTargetName(IContext context_p, DRepresentation diagram_p, RepresentationDescription targetDescription_p) {
        RepresentationDescription description = DiagramHelper.getService().getDescription(diagram_p);
        String name = RepresentationHelper.getRepresentationDescriptor((DRepresentation)diagram_p).getName();
        name = name.replace(description.getName(), targetDescription_p.getName());
        if (DiagramHelper.getService().isA(description, "Operational Activity Interaction Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "System Data Flow Blank")) {
                name = name.replace(DiagramNamingConstants.OPERATIONAL_ACTIVITY_INTERACTION_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.SYSTEM_DATA_FLOW_BLANK_DIAGRAM_PREFIX);
            }
        } else if (DiagramHelper.getService().isA(description, "System Data Flow Blank")) {
            if (DiagramHelper.getService().isA(targetDescription_p, "Logical Data Flow Blank")) {
                name = name.replace(DiagramNamingConstants.SYSTEM_DATA_FLOW_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.LOGICAL_DATA_FLOW_BLANK_DIAGRAM_PREFIX);
            }
        } else if (DiagramHelper.getService().isA(description, "Logical Data Flow Blank") && DiagramHelper.getService().isA(targetDescription_p, "Physical Data Flow Blank")) {
            name = name.replace(DiagramNamingConstants.LOGICAL_DATA_FLOW_BLANK_DIAGRAM_PREFIX, DiagramNamingConstants.PHYSICAL_DATA_FLOW_BLANK_DIAGRAM_PREFIX);
        }
        return name;
    }

    @Override
    public EObject getTargetDefaultLocation(IContext context_p, BlockArchitecture root_p, RepresentationDescription description_p) {
        if (DiagramHelper.getService().isA(description_p, "Operational Activity Interaction Blank")) {
            return BlockArchitectureExt.getFunctionPkg((BlockArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "System Data Flow Blank")) {
            return BlockArchitectureExt.getFunctionPkg((BlockArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "Logical Data Flow Blank")) {
            return BlockArchitectureExt.getFunctionPkg((BlockArchitecture)root_p);
        }
        if (DiagramHelper.getService().isA(description_p, "Physical Data Flow Blank")) {
            return BlockArchitectureExt.getFunctionPkg((BlockArchitecture)root_p);
        }
        return null;
    }
}

